block('b-showclients-list').mod('type', 'archived')(

    def()(function() {
        var data = this.data,
            form = data.FORM || {},
            rows = data.dc_list,
            listParams = {
                defaultSort: 'tm',
                textEmpty: iget2('b-showclients-list', 'net-zaarhivirovannyh-klientov', 'Нет заархивированных клиентов'),
                isEmptyOfflineSearch: !rows.length
            },
            columns = [
                {
                    key: 'login',
                    title: iget2('b-showclients-list', 'login', 'Логин'),
                    transformData: function(row) {
                        var res = [{
                            block: 'link',
                            url: u.getUrl('showCamps', {
                                ulogin: row.login
                            }),
                            content: row.login
                        }];

                        (row.not_resident == 'Yes') && res.push({
                            block: 'b-showclients-list',
                            elem: 'not-resident',
                            attrs: {
                                title: iget2('b-showclients-list', 'nerezident', 'Нерезидент')
                            },
                            content: '(' + iget2('b-showclients-list', 'nr', 'нр') + ')'
                        });

                        (row.statusMove == 'Yes' || row.statusMove == 'Moving') && res.push({
                            block: 'b-showclients-list',
                            elem: 'note',
                            content: row.statusMove == 'Yes' ? '1' : '2'
                        });

                        return u.spacer(res);
                    }
                },
                {
                    key: 'ClientID',
                    title: iget2('b-showclients-list', 'clientid', 'ClientID'),
                    transformData: function(row) {
                        var clientId = row.ClientID;

                        return clientId ?
                            ({
                                block: 'link',
                                url: u.formatUrl({
                                    host: u.consts('balance_admin'),
                                    path: 'invoices.xml',
                                    query: {
                                        client_id: clientId
                                    }
                                }),
                                content: clientId
                            }) :
                            '&nbsp;';
                    }
                },
                {
                    key: 'fio',
                    title: iget2('b-showclients-list', 'nazvanie', 'Название')
                },
                {
                    key: 'domains',
                    title: iget2('b-showclients-list', 'reklamiruemye-domeny', 'Рекламируемые домены'),
                    transformData: function(row) {
                        return (row.domains || []).map(function(domain) {
                            return {
                                content: {
                                    block: 'link',
                                    url: u.formatUrl({
                                        protocol: 'http',
                                        host: domain
                                    }),
                                    content: domain
                                }
                            };
                        });
                    },
                    sortDisable: true
                },
                {
                    key: 'phone',
                    title: iget2('b-showclients-list', 'telefon', 'Телефон'),
                    sortDisable: true
                },
                {
                    key: 'email',
                    title: iget2('b-showclients-list', 'e-mail', 'E-mail'),
                    transformData: function(row) {
                        var email = row.email;

                        return email ?
                            ({
                                block: 'link',
                                url: 'mailto:' + row.email,
                                content: row.email
                            }) :
                            '&nbsp;';
                    }
                },
                {
                    key: 'tm',
                    title: iget2('b-showclients-list', 'data-ostanovki', 'Дата остановки'),
                    transformData: function(row) {
                        var tm = row.tm;

                        return tm === '0000-00-00 00:00:00' ?
                            '&mdash;' :
                            tm.split(' ')[0].split('-').reverse().join('.');
                    }
                },
                {
                    key: 'campcount',
                    title: iget2('b-showclients-list', 'kampaniy', 'Кампаний')
                },
                {
                    key: 'types',
                    title: iget2('b-showclients-list', 'tipy-kampaniy', 'Типы кампаний'),
                    transformData: function(row) {
                        var types = row.types || {},
                            res = [];

                        types.text && res.push(iget2('b-showclients-list', 'direkt', 'Директ'));

                        return res.length ? u.spacer(res, ' + ') : '&nbsp;';
                    }
                },
                {
                    key: 'sum',
                    title: iget2('b-showclients-list', 'vsego', 'Всего'),
                    transformData: function(row) {
                        return u.formatPrice(row.sum);
                    }
                },
                {
                    key: 'currency',
                    title: iget2('b-showclients-list', 'valyuta', 'Валюта'),
                    transformData: function(row) {
                        return u.currencies.getName(row.currency);
                    }
                },
                {
                    key: 'managers',
                    title: iget2('b-showclients-list', 'menedzhery', 'Менеджеры'),
                    transformData: function(row) {
                        return (row.managers || []).map(function(manager) {
                            return {
                                content: manager.fio
                            };
                        });
                    },
                    sortDisable: true
                }
            ],
            tableMixes = {
                row: [
                    {
                        block: 'b-style-table',
                        elem: 'row'
                    },
                    {
                        block: 'b-showclients-list',
                        elem: 'row'
                    }
                ],
                headerRow: [
                    {
                        block: 'b-style-table',
                        elem: 'head'
                    },
                    {
                        block: 'b-showclients-list',
                        elem: 'head'
                    }
                ],
                cell: function(key) {
                    var cellMods = {};

                    ~['domains', 'phone', 'email', 'types', 'sum', 'currency', 'managers'].indexOf(key) &&
                        (cellMods.nowrap = 'yes');

                    ~['tm', 'campcount', 'currency'].indexOf(key) && (cellMods.align = 'center');

                    return [
                        {
                            block: 'b-style-table',
                            elem: 'cell',
                            elemMods: cellMods
                        },
                        {
                            block: 'b-showclients-list',
                            elem: 'cell'
                        }
                    ];
                },
                headerCell: function(key) {
                    return [
                        {
                            block: 'b-style-table',
                            elem: 'cell'
                        },
                        {
                            block: 'b-showclients-list',
                            elem: 'cell'
                        }
                    ];
                }
            },
            currentPage = +(data.page || form.page) || 1;

        return applyNext({
            listParams: listParams,
            columns: columns,
            rows: rows,
            tableMixes: tableMixes,
            currentPage: currentPage,
            startIndex: (currentPage - 1) * 30
        });
    }),

    content()(function() {
        var data = this.data,
            pagesCount = data.page_count;

        return [
            applyNext(),
            pagesCount > 1 ?
                {
                    block: 'b-pager',
                    currentPage: this.currentPage,
                    pageParam: 'page',
                    startFrom: 1,
                    totalCount: pagesCount * 30,
                    perpageCount: 30,
                    pageUrl: u.formatUrl({
                        host: data.script,
                        query: u.getUrlParams(['page'])
                    }),
                    content: [
                        {
                            elem: 'title',
                            content: iget2('b-showclients-list', 'stranicy', 'Страницы')
                        },
                        {
                            elem: 'button-prev',
                            content: iget2('b-showclients-list', 'predydushchaya', 'предыдущая')
                        },
                        {
                            elem: 'button-next',
                            content: iget2('b-showclients-list', 'sleduyushchaya', 'следующая')
                        },
                        {
                            elem: 'pages',
                            showFirst: true,
                            showLast: true
                        }
                    ]
                } :
                ''
        ];
    })
);
