block('b-showclients-list').mod('type', 'clients')(

    addJs()(true),

    def()(function() {
        var data = this.data,
            form = data.FORM || {},
            offlineSearch = form.search || '',
            offlineSearchLength = offlineSearch.length,
            offlineSearchRegexp = offlineSearchLength && new RegExp('(' + offlineSearch.replace(/(.)/g, function(s) {
                return '[' + (s == '\\' ? '\\\\' : s) + ']';
            }) + ')', 'i'),
            ulogin = form.ulogin,
            pageParams = this.pageParams || {},
            isAgencySearch = pageParams.isAgencySearch,
            rows = data.subclients,
            repsToggle = data.have_client_reps,
            isAgencyViewOwnRep = pageParams.isAgencyViewOwnRep,
            searchText = function(text) {
                return text ? text.search(offlineSearchRegexp) : -1;
            },
            isNumber = function(value) {
                return typeof value == 'number';
            },
            highlight = function(text) {
                var index = searchText(text);

                return ~index ? [
                    text.substring(0, index),
                    {
                        block: 'b-search-on-list',
                        elem: 'hlted',
                        content: text.substring(index, index + offlineSearchLength)
                    },
                    text.substring(index + offlineSearchLength, text.length)
                ] : text;
            },
            hltWrap = function(text) {
                text = u.escapeHTML(text);

                return offlineSearchLength && text ?
                    highlight(text) : {
                        block: 'b-showclients-list',
                        elem: 'hlt',
                        content: text
                    };
            },
            columns = [
                isAgencyViewOwnRep || isAgencySearch || {
                    key: 'checkboxes',
                    title: {
                        block: 'checkbox',
                        checkboxAttrs: {
                            autocomplete: 'off'
                        },
                        mix: [{
                            block: 'b-checkboxes-group',
                            elem: 'item'
                        }]
                    },
                    sortDisable: true,
                    transformData: function(row) {
                        return !row.isChild && {
                            block: 'checkbox',
                            checkboxAttrs: {
                                autocomplete: 'off'
                            },
                            mix: [{
                                block: 'b-checkboxes-group',
                                elem: 'item'
                            }]
                        };
                    }
                },
                repsToggle && {
                    key: 'reps-toggle',
                    transformData: function(row) {
                        if ((row.client_reps || []).length) {
                            return {
                                block: 'b-showclients-list',
                                elem: 'reps-toggle'
                            };
                        }
                    },
                    sortDisable: true
                },
                {
                    key: 'login',
                    title: iget2('b-showclients-list', 'login', 'Логин'),
                    transformData: function(row) {
                        var res = [{
                            block: 'link',
                            url: u.getUrl('showCamps', {
                                ulogin: row.login
                            }),
                            content: hltWrap(row.login)
                        }];

                        (row.not_resident == 'Yes') && res.push({
                            block: 'b-showclients-list',
                            elem: 'not-resident',
                            attrs: {
                                title: iget2('b-showclients-list', 'nerezident', 'Нерезидент')
                            },
                            content: '(' + iget2('b-showclients-list', 'nr', 'нр') + ')'
                        });

                        (row.is_SuperRightsToSSC || row.is_super_subclient) && res.push({
                            block: 'b-showclients-list',
                            elem: 'note',
                            content: row.is_SuperRightsToSSC ? '2' : row.is_super_subclient && '1'
                        });

                        return u.spacer(res);
                    }
                },
                isAgencySearch && {
                    key: 'ClientID',
                    title: iget2('b-showclients-list', 'clientid', 'ClientID')
                },
                {
                    key: 'FIO',
                    title: iget2('b-showclients-list', 'nazvanie', 'Название'),
                    transformData: function(row) {
                        return hltWrap(row.FIO);
                    }

                },
                data.show_account_score && {
                    key: 'account_score',
                    title: iget2('b-showclients-list', 'kachestvo-akkaunta', 'Качество аккаунта'),
                    transformData: function(row) {
                        return {
                            block: 'b-list-numeric',
                            content: row.account_score ? u.formatShowsOrMoney(row.account_score, 'money') : '&mdash;'
                        };
                    }
                },
                {
                    key: 'phone',
                    title: iget2('b-showclients-list', 'telefon', 'Телефон'),
                    transformData: function(row) {
                        return hltWrap(row.phone);
                    }
                },
                {
                    key: 'email',
                    title: iget2('b-showclients-list', 'email', 'email'),
                    transformData: function(row) {
                        return row.email ?
                            ({
                                block: 'link',
                                url: 'mailto:' + row.email,
                                content: hltWrap(row.email)
                            }) :
                            '';
                    }
                },
                isAgencyViewOwnRep || {
                    key: 'createtime',
                    title: iget2('b-showclients-list', 'sozdan', 'создан'),
                    transformData: function(row) {
                        return row.createtime_text;
                    }
                },
                data.show_limited_agency_column && {
                    key: 'limited_agency_name',
                    title: iget2('b-showclients-list', 'predstavitel', 'представитель'),
                    transformData: function(row) {
                        function displayRep(login, name) {
                            return u.spacer([
                                {
                                    block: 'link',
                                    content: u.escapeHTML(name),
                                    url: u.getUrl('showClients', {
                                        ulogin: login
                                    })
                                },
                                '(' + u.escapeHTML(login) + ')'
                            ]);
                        }

                        if (row.limited_agency) {
                            return u.spacer(
                                row.limited_agency.map(function(rep) {
                                    return displayRep(rep.limited_agency_login, rep.limited_agency_name);
                                }),
                                ', ');
                        }

                        return row.limited_agency_login && displayRep(row.limited_agency_login, row.limited_agency_name);
                    }
                },
                isAgencyViewOwnRep || {
                    key: 'campcount',
                    title: iget2('b-showclients-list', 'kampaniy-102', 'кампаний'),
                    transformData: function(row) {
                        return {
                            block: 'b-list-numeric',
                            content: row.campcount || 0
                        };
                    },
                    reverse: '1'
                },
                isAgencyViewOwnRep || {
                    key: 'shows',
                    title: iget2('b-showclients-list', 'pokazov', 'показов'),
                    transformData: function(row) {
                        return {
                            block: 'b-list-numeric',
                            content: isNumber(row.shows) ?
                                u.formatInt(row.shows) :
                                '&ndash;'
                        };
                    },
                    reverse: '1'
                },
                isAgencyViewOwnRep || {
                    key: 'clicks',
                    title: iget2('b-showclients-list', 'klikov', 'кликов'),
                    transformData: function(row) {
                        return {
                            block: 'b-list-numeric',
                            content: isNumber(row.clicks) ? u.formatInt(row.clicks) : '&ndash;'
                        };
                    },
                    reverse: '1'
                },
                isAgencyViewOwnRep || {
                    key: 'ctr',
                    title: iget2('b-showclients-list', 'ctr', 'CTR'),
                    reverse: '1'
                },
                //TODO модификаторы numeric не отрабатывают!!!
                isAgencyViewOwnRep || ({
                    key: 'sum',
                    title: iget2('b-showclients-list', 'vsego-103', 'всего'),
                    transformData: function(row) {
                        return {
                            block: 'b-list-numeric',
                            content: u.formatPrice(row.sum || 0)
                        };
                    },
                    reverse: '1'
                }),
                isAgencyViewOwnRep || ({
                    key: 'total',
                    title: iget2('b-showclients-list', 'ostalos', 'осталось'),
                    transformData: function(row) {
                        return {
                            block: 'b-list-numeric',
                            content: u.formatPrice(row.total || 0)
                        };
                    },
                    reverse: '1'
                }),
                {
                    key: 'ya_counters',
                    title: iget2('b-showclients-list', 'schyotchiki-metriki', 'счётчики Метрики'),
                    transformData: function(row) {
                        return !row.isChild && {
                            block: 'link',
                            mix: [{
                                block: 'b-showclients-list',
                                elem: 'row-actions-item'
                            }],
                            attrs: {
                                target: '_blank'
                            },
                            //@heliarian в ya_counters приходит строка "0"
                            url: u.getUrl(
                                hasLoginRights('agency_control') && !+row.ya_counters ?
                                'yaAddCounter' :
                                'yaShowUserCounters', {
                                    ulogin: row.login
                                }),
                            content: u.formatInt(row.ya_counters)
                        };
                    },
                    reverse: '1'
                },
                (!pageParams.readonly || isAgencySearch) && {
                    key: 'row_actions',
                    transformData: function(row) {
                        var res = [{
                                block: 'b-showclients-list',
                                elem: 'row-actions-item',
                                content: {
                                    block: 'link',
                                    url: u.getUrl(
                                        'modifyUser',
                                        u._.extend(
                                            {
                                                ulogin: row.login,
                                                rcmd: hasLoginRights('manager_control') ?
                                                    'showManagerMyClients' :
                                                    'showClients'
                                            },
                                            data.uid != data.UID ? { rulogin: ulogin } : {}
                                        )
                                    ),
                                    content: iget2('b-showclients-list', 'redaktirovat', 'редактировать')
                                }
                            }],
                            userDesc = row.description,
                            jsParamsForDesc = {
                                id: row.login,
                                idField: 'ulogin',
                                index: row._rowIndex
                            };

                        if (isAgencySearch) {
                            return {
                                block: 'b-showclients-list',
                                elem: 'row-actions',
                                content: res
                            };
                        }

                        userDesc && (jsParamsForDesc.text = userDesc);

                        hasLoginRights('agency_control') && !hasLoginRights('is_agency_main') && !u.consts('isMy') &&
                            res.push({
                                block: 'b-showclients-list',
                                elem: 'row-actions-item',
                                content: {
                                    block: 'link',
                                    mix: [{
                                        block: 'b-showclients-list',
                                        elem: 'confirm-link',
                                        js: {
                                            type: 'moveClientToMain',
                                            login: row.login,
                                            ulogin: ulogin
                                        }
                                    }],
                                    url: u.getUrl(
                                        'moveClientToMain',
                                        u._.extend(
                                            {
                                                ulogin: row.login,
                                                rcmd: 'showClients'
                                            },
                                            data.uid != data.UID ? { rulogin: ulogin } : {}
                                        )
                                    ),
                                    content: iget2('b-showclients-list', 'snyat-predstavitelya', 'снять представителя')
                                }
                            });

                        if (hasLoginRights('super_control', 'manager_control', 'agency_control')) {
                            var isArch = row.statusArch == 'No',
                                // даем архивировать клиентов с остатками ниже определенного порога (DIRECT-59417)
                                type = isArch && +row['total'] <
                                    u.currencies.getConst(row.currency, 'MAX_CLIENT_ARCHIVE') ?
                                        'archiveUser' :
                                        row.statusArch == 'Yes' && 'unArchiveUser';

                            type && res.push({
                                block: 'b-showclients-list',
                                elem: 'row-actions-item',
                                content: {
                                    block: 'link',
                                    mix: [{
                                        block: 'b-showclients-list',
                                        elem: 'confirm-link',
                                        js: {
                                            type: type
                                        }
                                    }],
                                    url: u.getUrl(
                                        type,
                                        u._.extend(
                                            {
                                                client_login: row.login,
                                                rcmd: form.cmd,
                                                agency_client_list: 1,
                                                cl_cnt: data[isArch ? 'no_arch_users_exists' : 'arch_users_exists'] - 1
                                            },
                                            ulogin ? { ulogin: ulogin } : {}
                                        )
                                    ),
                                    content: isArch ?
                                        iget2('b-showclients-list', 'arhivirovat', 'архивировать') :
                                        iget2('b-showclients-list', 'razarhivirovat', 'разархивировать')
                                }
                            });
                        }

                        if (hasLoginRights('super_control')) {
                            var agencyBind = row.agency_bind,
                                url = agencyBind ?
                                u.getUrl('removeAgencyClientRelation', {
                                    ulogin: ulogin,
                                    client_login: row.login
                                }) :
                                u.getUrl('addAgencyClientRelation', {
                                    ulogin: ulogin,
                                    client_login: row.login,
                                    do_check: 1,
                                    revert_campaigns: 1
                                });

                            res.push({
                                block: 'b-showclients-list',
                                elem: 'row-actions-item',
                                content: {
                                    block: 'link',
                                    mix: [{
                                        block: 'b-showclients-list',
                                        elem: 'row-actions-item'
                                    }],
                                    url: url,
                                    content: agencyBind ?
                                        iget2('b-showclients-list', 'zavershit-obsluzhivanie', 'завершить обслуживание') :
                                        iget2('b-showclients-list', 'vernut-klienta', 'вернуть клиента')
                                }
                            });
                        }

                        res.push({
                            block: 'b-showclients-list',
                            elem: 'row-actions-item',
                            content: {
                                block: 'button',
                                mods: {
                                    pseudo: 'yes',
                                    theme: (offlineSearchLength && ~searchText(userDesc)) ? 'orange' : 'normal',
                                    size: 'xs'
                                },
                                mix: [{
                                    block: 'b-showclients-list',
                                    elem: 'desc',
                                    elemMods: userDesc ? '' : {
                                        empty: 'yes'
                                    },
                                    js: jsParamsForDesc
                                }],
                                content: iget2('b-showclients-list', 'primechaniya', 'примечания')
                            }
                        });

                        return {
                            block: 'b-showclients-list',
                            elem: 'row-actions',
                            content: res
                        };
                    }
                }
            ],
            tableMixes = {
                row: function(row) {

                    var elemMods = {};

                    //TODO переименуй!!!!!
                    row.isChild ?
                        (elemMods.type = 'child') :
                        (elemMods.parent = 'yes') && !row.freedom && !isAgencySearch && (elemMods.disabled = 'yes');

                    return [
                        {
                            block: 'b-style-table',
                            elem: 'row'
                        },
                        {
                            block: 'b-showclients-list',
                            elem: 'row',
                            elemMods: elemMods
                        }
                    ];
                },
                headerRow: [{
                    block: 'b-style-table',
                    elem: 'head'
                }, {
                    block: 'b-showclients-list',
                    elem: 'head'
                }],
                cell: function(key) {
                    return [
                        {
                            block: 'b-style-table',
                            elem: 'cell'
                        },
                        {
                            block: 'b-showclients-list',
                            elem: 'cell',
                            elemMods: key === 'reps-toggle' ?
                                { type: 'reps-toggle' } :
                                key === 'login' ? { type: 'nowrap' } : ''
                        },
                        key === 'ya_counters' && {
                            block: 'b-showclients-list',
                            elem: 'ya-counters'
                        },
                        key === 'row_actions' && {
                            block: 'b-showclients-list',
                            elem: 'row-actions-item'
                        },
                        key === 'ctr' && {
                            block: 'b-list-numeric'
                        }
                    ];
                },
                headerCell: function(key) {
                    var isNumeric = [
                        'campcount', 'shows', 'clicks', 'ctr', 'sum', 'sum_units', 'total', 'total_units', 'currency',
                        'account_score'
                    ];

                    return [
                        {
                            block: 'b-style-table',
                            elem: 'cell'
                        },
                        {
                            block: 'b-showclients-list',
                            elem: 'cell',
                            type: key == 'account_score' ? 'nowrap' : ''
                        },
                        key === 'ya_counters' && {
                            block: 'b-showclients-list',
                            elem: 'ya-counters'
                        },
                        ~isNumeric.indexOf(key) && {
                            block: 'b-list-numeric'
                        }
                    ];
                },
                group: [{
                    block: 'b-showclients-list',
                    elem: 'group',
                    elemMods: {
                        'hide-reps': 'yes'
                    }
                }]
            },
            descriptionPopup = {
                cmd: 'ajaxSaveUserDescription',
                agency_client_list: 1
            },
            listParams = {
                search: !isAgencySearch,
                massAction: !isAgencySearch,
                textEmpty: iget2('b-showclients-list', 'net-klientov-udovletvoryayushchih-usloviyam', 'Нет клиентов, удовлетворяющих условиям поиска'),
                descriptionPopup: descriptionPopup,
                isPaginationEnabled: pageParams.isPaginationEnabled,
                isEmptyOfflineSearch: pageParams.isPaginationEnabled && offlineSearchLength && !(rows || []).length
            };

        ulogin && !hasLoginRights('agency_control') && (listParams.descriptionPopup.agency_login = ulogin);

        if (repsToggle) {
            rows.forEach(function(row) {
                if ((row.client_reps || []).length) {
                    row.groupData = row.client_reps = row.client_reps.reduce(function(clientReps, currentRep) {
                        if (currentRep) {
                            currentRep.isChild = 1;
                            clientReps.push(currentRep);
                        }

                        return clientReps;
                    }, []);
                }
            });
        }

        return applyNext({
            listParams: listParams,
            columns: columns,
            rows: rows,
            tableMixes: tableMixes
        });
    }),

    content()(function() {
        return [
            (this.pageParams || {}).isAgencySearch || {
                block: 'check-button',
                mods: {
                    size: 's',
                    theme: 'pseudo',
                    checked: this.pageParams.showExtendedInfo ? 'yes' : ''
                },
                mix: [{
                    block: 'b-showclients-list',
                    elem: 'toggle',
                    elemMods: {
                        'margin-top': this.pageParams.needSearch ? 'yes' : ''
                    }
                }],
                content: iget2('b-showclients-list', 'metrika', 'метрика')
            },
            applyNext()
        ];
    })
);
