block('b-showclients-list').mod('type', 'manager-agents')(

    def()(function() {
        var data = this.data,
            rows = data.ag_list,
            form = data.FORM,
            hltWrap = function(text) {
                return {
                    block: 'b-showclients-list',
                    elem: 'hlt',
                    content: u.escapeHTML(text)
                };
            },
            columns = [
                {
                    key: 'login',
                    title: iget2('b-showclients-list', 'login', 'Логин'),
                    transformData: function(row) {
                        var res = [{
                            block: 'link',
                            url: u.getUrl('showClients', {
                                ulogin: row.login
                            }),
                            content: hltWrap(row.login)
                        }];

                        row.not_resident == 'Yes' && res.push({
                            block: 'b-showclients-list',
                            elem: 'not-resident',
                            attrs: {
                                title: iget2('b-showclients-list', 'nerezident', 'Нерезидент')
                            },
                            content: '(' + iget2('b-showclients-list', 'nr', 'нр') + ')'
                        });

                        return u.spacer(res);
                    }
                },
                {
                    key: 'clientid',
                    title: iget2('b-showclients-list', 'clientid', 'ClientID'),
                    transformData: function(row) {
                        return {
                            block: 'link',
                            target: 'blank',
                            url: u.formatUrl({
                                host: u.consts('balance_admin'),
                                path: 'invoices.xml',
                                query: {
                                    client_id: row.clientid
                                }
                            }),
                            content: hltWrap(row.clientid)
                        };
                    }
                },
                {
                    key: 'agency_name',
                    title: iget2('b-showclients-list', 'nazvanie', 'Название'),
                    transformData: function(row) {
                        return hltWrap(row.agency_name);
                    }

                },
                data.show_account_score && {
                    key: 'account_score',
                    title: iget2('b-showclients-list', 'kachestvo-akkaunta', 'Качество аккаунта'),
                    transformData: function(row) {
                        return {
                            block: 'b-list-numeric',
                            content: row.account_score ? u.formatShowsOrMoney(row.account_score, 'money') : '&mdash;'
                        };
                    }
                },
                {
                    key: 'phone',
                    title: iget2('b-showclients-list', 'telefon', 'Телефон'),
                    transformData: function(row) {
                        return hltWrap(row.phone);
                    }
                },
                {
                    key: 'email',
                    title: iget2('b-showclients-list', 'email', 'email'),
                    transformData: function(row) {
                        return row.email ?
                            ({
                                block: 'link',
                                url: 'mailto:' + row.email,
                                content: hltWrap(row.email)
                            }) :
                            '';
                    }
                },
                {
                    key: 'createtime',
                    title: iget2('b-showclients-list', 'sozdan', 'создан'),
                    transformData: function(row) {
                        return row.createtime_text;
                    }
                },
                //TODO модификаторы numeric не отрабатывают!!!
                {
                    key: 'sum',
                    title: iget2('b-showclients-list', 'vsego-103', 'всего'),
                    transformData: function(row) {
                        return {
                            block: 'b-list-numeric',
                            content: u.formatPrice(row.sum)
                        };
                    },
                    reverse: '1'
                },
                {
                    key: 'total',
                    title: iget2('b-showclients-list', 'ostalos', 'осталось'),
                    transformData: function(row) {
                        return {
                            block: 'b-list-numeric',
                            content: u.formatPrice(row.total)
                        };
                    },
                    reverse: '1'
                },
                {
                    key: 'currency',
                    title: iget2('b-showclients-list', 'valyuta-104', 'валюта'),
                    transformData: function(row) {
                        return {
                            block: 'b-list-numeric',
                            content: row.currency && u.currencies.getName(row.currency)
                        };
                    },
                    reverse: '1'
                },
                !this.pageParams.readonly && {
                    key: 'row_actions',
                    transformData: function(row) {
                        var res = [{
                                block: 'b-showclients-list',
                                elem: 'row-actions-item',
                                content: [
                                    {
                                        block: 'link',
                                        url: u.getUrl(
                                            'modifyUser', {
                                                ulogin: row.login,
                                                rcmd: 'showManagerMyClients',
                                                rulogin: form.ulogin
                                            }),
                                        content: iget2('b-showclients-list', 'redaktirovat', 'редактировать')
                                    },
                                    !!+row.geo_id || {
                                        block: 'icon',
                                        mix: [{
                                            block: 'b-showclients-list',
                                            elem: 'edit-warn'
                                        }],
                                        attrs: {
                                            title: iget2('b-showclients-list', 'ne-ukazano-pole-gorod', 'не указано поле город')
                                        },
                                        mods: {
                                            'size-16': 'alert'
                                        }
                                    }
                                ]
                            }],
                            userDesc = row.description,
                            jsParamsForDesc = {
                                id: row.login,
                                idField: 'ulogin',
                                index: row._rowIndex
                            };

                        userDesc && (jsParamsForDesc.text = userDesc);

                        if (hasLoginRights('super_control', 'manager_control', 'support_control', 'agency_control')) {
                            var isArch = row.statusArch == 'No',
                                type = isArch ? 'archiveUser' : 'unArchiveUser';

                            res.push({
                                block: 'b-showclients-list',
                                elem: 'row-actions-item',
                                content: {
                                    block: 'link',
                                    mix: [{
                                        block: 'b-showclients-list',
                                        elem: 'confirm-link',
                                        js: {
                                            type: type
                                        }
                                    }],
                                    url: u.getUrl(
                                        type,
                                        u._.extend(
                                            {
                                                client_login: row.login,
                                                rcmd: form.cmd,
                                                cl_cnt: data[isArch ? 'no_arch_users_exists' : 'arch_users_exists'] - 1
                                            },
                                            form.ulogin ? { ulogin: form.ulogin } : {}
                                        )
                                    ),
                                    content: isArch ? iget2('b-showclients-list', 'arhivirovat', 'архивировать') : iget2('b-showclients-list', 'razarhivirovat', 'разархивировать')
                                }
                            });
                        }

                        hasLoginRights('super_control') && res.push({
                            block: 'b-showclients-list',
                            elem: 'row-actions-item',
                            content: {
                                block: 'link',
                                url: u.getUrl('addAgencyClientRelation', {
                                    ulogin: row.login
                                }),
                                content: iget2('b-showclients-list', 'dobavit-klienta', 'добавить клиента')
                            }
                        });

                        res.push({
                            block: 'b-showclients-list',
                            elem: 'row-actions-item',
                            content: {
                                block: 'button',
                                mods: {
                                    pseudo: 'yes',
                                    theme: 'normal',
                                    size: 'xs'
                                },
                                mix: [{
                                    block: 'b-showclients-list',
                                    elem: 'desc',
                                    elemMods: userDesc ? '' : {
                                        empty: 'yes'
                                    },
                                    js: jsParamsForDesc
                                }],
                                content: iget2('b-showclients-list', 'primechaniya', 'примечания')
                            }
                        });

                        return {
                            block: 'b-showclients-list',
                            elem: 'row-actions',
                            content: res
                        };
                    }
                }

            ],
            tableMixes = {
                row: function(row) {
                    return [
                        {
                            block: 'b-style-table',
                            elem: 'row'
                        },
                        {
                            block: 'b-showclients-list',
                            elem: 'row',
                            elemMods: {
                                parent: 'yes'
                            }
                        }
                    ];
                },
                headerRow: [
                    {
                        block: 'b-style-table',
                        elem: 'head'
                    },
                    {
                        block: 'b-showclients-list',
                        elem: 'head'
                    }
                ],
                cell: function(key) {
                    return [
                        {
                            block: 'b-style-table',
                            elem: 'cell'
                        },
                        {
                            block: 'b-showclients-list',
                            elem: 'cell',
                            elemMods: key === 'agency_name' ? { type: 'nowrap' } : ''
                        }
                    ];
                },
                headerCell: function(key) {
                    var isNumeric = ['sum', 'sum_units', 'total', 'total_units', 'currency', 'account_score'];

                    return [
                        {
                            block: 'b-style-table',
                            elem: 'cell'
                        },
                        {
                            block: 'b-showclients-list',
                            elem: 'cell',
                            type: key == 'account_score' ? 'nowrap' : ''
                        },
                        ~isNumeric.indexOf(key) && {
                            block: 'b-list-numeric'
                        }
                    ];
                }
            },
            listParams = {
                search: true,
                textEmpty: iget2(
                    'b-showclients-list',
                    'net-rezultatov-udovletvoryayushchih-usloviyam',
                    'Нет результатов, удовлетворяющих условиям поиска'
                ),
                descriptionPopup: {
                    cmd: 'ajaxSaveUserDescription'
                }
            };

        return applyNext({
            listParams: listParams,
            columns: columns,
            rows: rows,
            tableMixes: tableMixes
        });
    }),

    content()(function() {
        return [
            applyNext(),
            this.listParams.showFootNote && {
                elem: 'footnote',
                content: {
                    elem: 'footnote-desc',
                    content: [
                        '-&nbsp;',
                        {
                            elem: 'footnote-sup',
                            content: '5'
                        },
                        ':&nbsp;' + iget2('b-showclients-list', 'agentstvo-imeet-sobstvennye-ploshchadki', 'агентство имеет собственные площадки')
                    ]
                }
            }
        ];
    })
);
