block('b-showclients-list').mod('type', 'manager-clients')(

    def()(function() {

        var data = this.data,
            rows = data.dc_list,
            form = data.FORM,
            showCampCounts = form.tab != 'arch',
            repsToggle = rows.some(function(client) {
                return client.client_reps.length;
            }),
            isAgencyViewOwnRep = this.pageParams.isAgencyViewOwnRep,
            hltWrap = function(text) {
                return {
                    block: 'b-showclients-list',
                    elem: 'hlt',
                    content: u.escapeHTML(text)
                };
            },
            columns = [
                isAgencyViewOwnRep || {
                    key: 'checkboxes',
                    title: {
                        block: 'checkbox',
                        checkboxAttrs: {
                            autocomplete: 'off'
                        },
                        mix: [{
                            block: 'b-checkboxes-group',
                            elem: 'item'
                        }]
                    },
                    sortDisable: true,
                    transformData: function(row) {
                        return !row.isChild && {
                            block: 'checkbox',
                            checkboxAttrs: {
                                autocomplete: 'off'
                            },
                            mix: [{
                                block: 'b-checkboxes-group',
                                elem: 'item'
                            }]
                        };
                    }
                },
                repsToggle && {
                    key: 'reps-toggle',
                    transformData: function(row) {
                        if (row.client_reps && row.client_reps.length) {
                            return {
                                block: 'b-showclients-list',
                                elem: 'reps-toggle'
                            };
                        }
                    },
                    sortDisable: true
                },
                {
                    key: 'login',
                    title: iget2('b-showclients-list', 'login', 'Логин'),
                    transformData: function(row) {
                        var res = [{
                            block: 'link',
                            url: u.getUrl('showCamps', {
                                ulogin: row.login
                            }),
                            content: hltWrap(row.login)
                        }];

                        (row.not_resident == 'Yes') && res.push({
                            block: 'b-showclients-list',
                            elem: 'not-resident',
                            attrs: {
                                title: iget2('b-showclients-list', 'nerezident', 'Нерезидент')
                            },
                            content: '(' + iget2('b-showclients-list', 'nr', 'нр') + ')'
                        });

                        (row.is_SuperRightsToSSC || row.is_super_subclient) && res.push({
                            block: 'b-showclients-list',
                            elem: 'note',
                            content: row.is_SuperRightsToSSC ? '2' : row.is_super_subclient && '1'
                        });

                        return u.spacer(res);
                    }
                },
                {
                    key: 'clientid',
                    title: iget2('b-showclients-list', 'clientid', 'ClientID'),
                    transformData: function(row) {
                        return {
                            block: 'link',
                            target: 'blank',
                            url: u.formatUrl({
                                host: u.consts('balance_admin'),
                                path: 'invoices.xml',
                                query: {
                                    client_id: row.clientid
                                }
                            }),
                            content: hltWrap(row.clientid)
                        };
                    }

                },
                {
                    key: 'FIO',
                    title: iget2('b-showclients-list', 'nazvanie', 'Название'),
                    transformData: function(row) {
                        return hltWrap(row.FIO);
                    }
                },
                data.show_account_score && {
                    key: 'account_score',
                    title: iget2('b-showclients-list', 'kachestvo-akkaunta', 'Качество аккаунта'),
                    transformData: function(row) {
                        return {
                            block: 'b-list-numeric',
                            content: row.account_score ? u.formatShowsOrMoney(row.account_score, 'money') : '&mdash;'
                        };
                    }
                },
                {
                    key: 'phone',
                    title: iget2('b-showclients-list', 'telefon', 'Телефон'),
                    transformData: function(row) {
                        return hltWrap(row.phone);
                    }
                },
                {
                    key: 'email',
                    title: iget2('b-showclients-list', 'email', 'email'),
                    transformData: function(row) {
                        return row.email ?
                            ({
                                block: 'link',
                                url: 'mailto:' + row.email,
                                content: hltWrap(row.email)
                            }) :
                            '';
                    }
                },
                isAgencyViewOwnRep || {
                    key: 'campcount',
                    title: iget2('b-showclients-list', 'kampaniy-102', 'кампаний'),
                    transformData: function(row) {
                        return {
                            block: 'b-list-numeric',
                            content: row.campcount
                        };
                    },
                    reverse: '1'
                },
                showCampCounts && {
                    key: 'campcount_active',
                    title: {
                        block: 'b-showclients-list',
                        elem: 'icon-title',
                        title: iget2('b-showclients-list', 'kolichestvo-aktivnyh-kampaniy', 'количество активных кампаний'),
                        elemMods: {
                            type: 'green'
                        }
                    },
                    reverse: '1'
                },
                showCampCounts && {
                    key: 'campcount_stoped',
                    title: {
                        block: 'b-showclients-list',
                        elem: 'icon-title',
                        title: iget2(
                            'b-showclients-list',
                            'kolichestvo-kampaniy-na-kotoryh',
                            'количество кампаний на которых есть деньги, но они ОСТАНОВЛЕНЫ'
                        ),
                        elemMods: {
                            type: 'red'
                        }
                    },
                    reverse: '1'
                },
                showCampCounts && {
                    key: 'campcount_nosum',
                    title: {
                        block: 'b-showclients-list',
                        elem: 'icon-title',
                        title: iget2('b-showclients-list', 'kolichestvo-kampaniy-na-kotoryh-105', 'количество кампаний, на которых кончились деньги'),
                        elemMods: {
                            type: 'blue'
                        }
                    },
                    reverse: '1'
                },
                isAgencyViewOwnRep || {
                    key: 'shows',
                    title: iget2('b-showclients-list', 'pokazov', 'показов'),
                    transformData: function(row) {
                        return {
                            block: 'b-list-numeric',
                            content: u.formatInt(row.shows)
                        };
                    },
                    reverse: '1'
                },
                isAgencyViewOwnRep || {
                    key: 'clicks',
                    title: iget2('b-showclients-list', 'klikov', 'кликов'),
                    transformData: function(row) {
                        return {
                            block: 'b-list-numeric',
                            content: u.formatInt(row.clicks)
                        };
                    },
                    reverse: '1'
                },
                isAgencyViewOwnRep || {
                    key: 'ctr',
                    title: iget2('b-showclients-list', 'ctr', 'CTR'),
                    transformData: function(row) {
                        return {
                            block: 'b-list-numeric',
                            content: u.formatShowsOrMoney(row.ctr, 'money')
                        };
                    },
                    reverse: '1'
                },
                //TODO модификаторы numeric не отрабатывают!!!
                isAgencyViewOwnRep || ({
                    key: 'sum',
                    title: iget2('b-showclients-list', 'vsego-103', 'всего'),
                    transformData: function(row) {
                        return {
                            block: 'b-list-numeric',
                            content: u.formatPrice(row.sum)
                        };
                    },
                    reverse: '1'
                }),
                isAgencyViewOwnRep || ({
                    key: 'total',
                    title: iget2('b-showclients-list', 'ostalos', 'осталось'),
                    transformData: function(row) {
                        return {
                            block: 'b-list-numeric',
                            content: u.formatPrice(row.total)
                        };
                    },
                    reverse: '1'
                }),
                {
                    key: 'currency',
                    title: iget2('b-showclients-list', 'valyuta-104', 'валюта'),
                    transformData: function(row) {
                        return {
                            block: 'b-list-numeric',
                            content: row.currency && u.currencies.getName(row.currency)
                        };
                    },
                    reverse: '1'
                },
                !this.pageParams.readonly && {
                    key: 'row_actions',
                    transformData: function(row) {
                        var res = [{
                                block: 'b-showclients-list',
                                elem: 'row-actions-item',
                                content: [
                                    {
                                        block: 'link',
                                        url: u.getUrl('modifyUser', {
                                            ulogin: row.login,
                                            rcmd: 'showManagerMyClients',
                                            rulogin: form.ulogin
                                        }),
                                        content: iget2('b-showclients-list', 'redaktirovat', 'редактировать')
                                    },
                                    !!+row.geo_id || {
                                        block: 'icon',
                                        mix: [{
                                            block: 'b-showclients-list',
                                            elem: 'edit-warn'
                                        }],
                                        attrs: {
                                            title: iget2('b-showclients-list', 'ne-ukazano-pole-gorod', 'не указано поле город')
                                        },
                                        mods: {
                                            'size-16': 'alert'
                                        }
                                    }
                                ]
                            }],
                            userDesc = row.description,
                            jsParamsForDesc = {
                                id: row.login,
                                idField: 'ulogin',
                                index: row._rowIndex
                            };

                        userDesc && (jsParamsForDesc.text = userDesc);

                        if (hasLoginRights('super_control', 'manager_control', 'agency_control')) {
                            var isArch = row.statusArch == 'No',
                                // даем архивировать клиентов с остатками ниже определенного порога (DIRECT-59417)
                                type = isArch && +row['total'] <
                                    u.currencies.getConst(row.currency, 'MAX_CLIENT_ARCHIVE') ?
                                        'archiveUser' :
                                        row.statusArch == 'Yes' && 'unArchiveUser';

                            type && res.push({
                                block: 'b-showclients-list',
                                elem: 'row-actions-item',
                                content: {
                                    block: 'link',
                                    mix: [{
                                        block: 'b-showclients-list',
                                        elem: 'confirm-link',
                                        js: {
                                            type: type
                                        }
                                    }],
                                    url: u.getUrl(
                                        type,
                                        u._.extend(
                                            {
                                                client_login: row.login,
                                                rcmd: form.cmd,
                                                cl_cnt: data[isArch ? 'no_arch_users_exists' : 'arch_users_exists'] - 1
                                            },
                                            form.ulogin ? { ulogin: form.ulogin } : {}
                                        )
                                    ),
                                    content: isArch ? iget2('b-showclients-list', 'arhivirovat', 'архивировать') : iget2('b-showclients-list', 'razarhivirovat', 'разархивировать')
                                }
                            });
                        }

                        res.push({
                            block: 'b-showclients-list',
                            elem: 'row-actions-item',
                            elemMods: {
                                theme: 'red'
                            },
                            content: {
                                block: 'link',
                                mix: [{
                                    block: 'b-showclients-list',
                                    elem: 'confirm-link',
                                    js: {
                                        type: 'unServicingCamp',
                                        login: row.login
                                    }
                                }],
                                url: u.getUrl('unServicingCamp', {
                                    login: row.login,
                                    cid: '0',
                                    all_camps: '1',
                                    retref: '1'
                                }),
                                content: iget2('b-showclients-list', 'snyat-s-obsluzhivaniya', 'снять с обслуживания')
                            }
                        });

                        res.push({
                            block: 'b-showclients-list',
                            elem: 'row-actions-item',
                            content: {
                                block: 'button',
                                mods: {
                                    pseudo: 'yes',
                                    theme: 'normal',
                                    size: 'xs'
                                },
                                mix: [{
                                    block: 'b-showclients-list',
                                    elem: 'desc',
                                    elemMods: userDesc ? '' : {
                                        empty: 'yes'
                                    },
                                    js: jsParamsForDesc
                                }],
                                content: iget2('b-showclients-list', 'primechaniya', 'примечания')
                            }
                        });

                        hasLoginRights('is_internal_user') && res.push({
                            block: 'b-showclients-list',
                            elem: 'row-actions-item',
                            content: {
                                block: 'link',
                                url: u.formatUrl({
                                    protocol: 'https',
                                    host: 'crm.yandex-team.ru',
                                    path: 'client.aspx',
                                    query: {
                                        id: row.clientid
                                    }
                                }),
                                content: iget2('b-showclients-list', 'crm', 'CRM')
                            }
                        });

                        return {
                            block: 'b-showclients-list',
                            elem: 'row-actions',
                            content: res
                        };
                    }
                }
            ],
            tableMixes = {
                row: function(row) {
                    var elemMods = {};

                    //TODO переименуй!!!!!
                    row.isChild ? (elemMods.type = 'child') : (elemMods.parent = 'yes');

                    return [
                        {
                            block: 'b-style-table',
                            elem: 'row'
                        },
                        {
                            block: 'b-showclients-list',
                            elem: 'row',
                            elemMods: elemMods
                        }
                    ];
                },
                headerRow: [
                    {
                        block: 'b-style-table',
                        elem: 'head'
                    },
                    {
                        block: 'b-showclients-list',
                        elem: 'head'
                    }
                ],
                cell: function(key) {
                    return [
                        {
                            block: 'b-style-table',
                            elem: 'cell'
                        },
                        {
                            block: 'b-showclients-list',
                            elem: 'cell',
                            elemMods: key === 'reps-toggle' ?
                                { type: 'reps-toggle' } :
                                key === 'login' ?
                                    { type: 'nowrap' } :
                                    ''
                        },
                        key === 'row_actions' && {
                            block: 'b-showclients-list',
                            elem: 'row-actions-item'
                        }
                    ];
                },
                headerCell: function(key) {
                    var isNumeric = [
                        'campcount', 'shows', 'clicks', 'ctr', 'sum', 'sum_units', 'total', 'total_units', 'currency',
                        'account_score'
                    ];

                    return [
                        {
                            block: 'b-style-table',
                            elem: 'cell'
                        },
                        {
                            block: 'b-showclients-list',
                            elem: 'cell',
                            type: key == 'account_score' ? 'nowrap' : ''
                        },
                        ~isNumeric.indexOf(key) && {
                            block: 'b-list-numeric'
                        }
                    ];
                },
                group: [{
                    block: 'b-showclients-list',
                    elem: 'group',
                    elemMods: {
                        'hide-reps': 'yes'
                    }
                }]
            },
            listParams = {
                search: true,
                massAction: true,
                textEmpty: iget2('b-showclients-list', 'net-klientov-udovletvoryayushchih-usloviyam', 'Нет клиентов, удовлетворяющих условиям поиска'),
                descriptionPopup: {
                    cmd: 'ajaxSaveUserDescription'
                }
            };

        if (repsToggle) {
            rows.forEach(function(row) {
                if ((row.client_reps || []).length) {
                    row.groupData = row.client_reps = row.client_reps.reduce(function(clientReps, currentRep) {
                        if (currentRep) {
                            currentRep.isChild = 1;
                            clientReps.push(currentRep);
                        }

                        return clientReps;
                    }, []);
                }
            });
        }

        return applyNext({
            listParams: listParams,
            columns: columns,
            rows: rows,
            tableMixes: tableMixes
        });
    }),

    content()(function() {
        return applyNext();
    })
);
