block('b-showclients-list').mod('type', 'manager-teamleader')(

    def()(function() {
        var data = this.data,
            rows = data.managers_list,
            managersIndexCell = rows.some(function(teamleader) {
                return (teamleader.managers_list || []).length;
            }),
            columns = [
                managersIndexCell && {
                    key: 'manager-index',
                    transformData: function(row) {
                        return row.managerIndex ?
                            ({
                                block: 'b-showclients-list',
                                elem: 'manager-index',
                                content: row.managerIndex
                            }) :
                            '';
                    }
                },
                {
                    key: 'login',
                    title: iget2('b-showclients-list', 'login', 'Логин'),
                    transformData: function(row) {
                        return {
                            block: 'link',
                            url: u.getUrl('showManagerMyClients', {
                                ulogin: row.login
                            }),
                            content: u.escapeHTML(row.login)
                        };
                    }
                },
                {
                    key: 'FIO',
                    title: iget2('b-showclients-list', 'nazvanie', 'Название')
                },
                data.show_account_score && {
                    key: 'account_score',
                    title: iget2('b-showclients-list', 'kachestvo-akkaunta', 'Качество аккаунта'),
                    transformData: function(row) {
                        return {
                            block: 'b-list-numeric',
                            content: row.account_score ? u.formatShowsOrMoney(row.account_score, 'money') : '&mdash;'
                        };
                    }
                },
                {
                    key: 'phone',
                    title: iget2('b-showclients-list', 'telefon', 'Телефон')
                },
                {
                    key: 'email',
                    title: iget2('b-showclients-list', 'e-mail', 'E-mail'),
                    transformData: function(row) {
                        return row.email ?
                            ({
                                block: 'link',
                                url: 'mailto:' + row.email,
                                content: row.email
                            }) :
                            '';
                    }
                },
                {
                    key: 'reports',
                    transformData: function(row) {
                        return {
                            block: 'button',
                            mods: {
                                pseudo: 'yes',
                                theme: 'normal'
                            },
                            mix: [{
                                block: 'b-report-links',
                                elem: 'toggle',
                                js: {
                                    login: row.login
                                }
                            }],
                            content: iget2('b-showclients-list', 'otchety', 'отчеты')
                        };
                    }
                },
                !this.pageParams.readonly && {
                    key: 'row_actions',
                    transformData: function(row) {
                        var res = [{
                            block: 'b-showclients-list',
                            elem: 'row-actions-item',
                            content: {
                                block: 'link',
                                url: u.getUrl(
                                    'modifyUser', {
                                        ulogin: row.login,
                                        rcmd: 'showManagerMyClients',
                                        rulogin: data.FORM.ulogin
                                    }),
                                content: iget2('b-showclients-list', 'redaktirovat', 'редактировать')
                            }
                        }];

                        if ((row.is_teamleader || row.managerIndex) &&
                            (hasLoginRights('is_superteamleader') && u.consts('isMy')) ||
                                hasLoginRights('super_control')) {

                            res.push({
                                block: 'b-showclients-list',
                                elem: 'row-actions-item',
                                content: {
                                    block: 'link',
                                    mix: [{
                                        block: 'b-showclients-list',
                                        elem: 'confirm-link',
                                        js: {
                                            type: row.managerIndex ? 'deleteManager' : 'deleteTeamleader'
                                        }
                                    }],
                                    url: u.getUrl(
                                        'deleteUser', {
                                            ulogin: row.login,
                                            rcmd: 'showManagerMyClients',
                                            role: row.managerIndex ? 'manager' : 'teamleader'
                                        }),
                                    content: iget2('b-showclients-list', 'udalit', 'удалить')
                                }
                            });
                        }

                        return {
                            block: 'b-showclients-list',
                            elem: 'row-actions',
                            content: res
                        };
                    }
                }
            ],
            tableMixes = {
                row: function(row) {
                    return [
                        {
                            block: 'b-style-table',
                            elem: 'row'
                        },
                        {
                            block: 'b-showclients-list',
                            elem: 'row'
                        }
                    ];
                },
                headerRow: [
                    {
                        block: 'b-style-table',
                        elem: 'head'
                    },
                    {
                        block: 'b-showclients-list',
                        elem: 'head'
                    }
                ],
                cell: function(key, row) {
                    return [
                        {
                            block: 'b-style-table',
                            elem: 'cell'
                        },
                        {
                            block: 'b-showclients-list',
                            elem: 'cell'
                        },

                        key == 'row_actions' && {
                            block: 'b-showclients-list',
                            elem: 'row-actions-item'
                        },
                        key == 'FIO' && !!row.is_teamleader && {
                            block: 'b-showclients-list',
                            elem: 'fio',
                            elemMods: {
                                teamleader: 'yes'
                            }
                        }
                    ];
                },
                headerCell: function(key) {
                    return [
                        {
                            block: 'b-style-table',
                            elem: 'cell'
                        },
                        {
                            block: 'b-showclients-list',
                            elem: 'cell',
                            type: key == 'account_score' ? 'nowrap' : ''
                        }
                    ];
                }
            };

        managersIndexCell && rows.forEach(function(row) {
            if ((row.managers_list || []).length) {
                row.managers_list.forEach(function(rep, index) {
                    rep.managerIndex = index + 1;
                });

                row.groupData = row.managers_list;
            }
        });

        return applyNext({
            columns: columns,
            rows: rows,
            tableMixes: tableMixes
        });
    }),

    content()(function() {
        return applyNext();
    })
);
