BEM.DOM.decl({ block: 'b-showclients-list', baseBlock: 'b-data-list' }, {

    onSetMod: {

        js: function() {
            var dataForSearch = [],
                bSearchList = this.findBlockOutside('b-search-on-list'),
                bSearchListType = bSearchList ? bSearchList.getMod('type') : '',
                metrikaBtn = this.findBlockOn('toggle', 'check-button');

            metrikaBtn && metrikaBtn.on('change', this._metricaToggle, this);

            this._iUserOptions = BEM.blocks['i-user-options'];
            this._tableRows = this.elem('row', 'parent', 'yes');
            this._description = this.elem('desc');
            this._group = this.elem('group');
            this._tableParams = this.findBlockInside('b-data-table').params.rows || [];

            if (bSearchListType == 'online') {
                this._tableParams.forEach(function(item, i) {
                    dataForSearch[i] = {
                        searchIndex: item.searchIndex,
                        desc: item.desc || '',
                        domElem: this._tableRows.eq(i),
                        repsSearchIndex: item.repsSearchIndex || ''
                    }
                }, this);

                this.initSearch(dataForSearch, 'clients');
            }

            bSearchListType == 'offline' && bSearchList.on('offlineSearch', this._offlineSearch, this);

            this.initRecountTableWidths().initDescriptions()
                .findBlockInside('b-mass-actions') && this.initMassActions();
        }

    },

    onElemSetMod: {

        group: {

            'hide-reps': {
                '': function(elem) {
                    this.findElem(elem, 'row-actions-item').attr('rowspan', elem[0].childElementCount);
                },

                yes: function(elem) {
                    this.findElem(elem, 'row-actions-item').attr('rowspan', '0');
                }
            }
        }

    },

    _iUserOptions: null,

    _tableRows: null,

    _description: null,

    _group: null,

    _tableParams: null,

    /**
     * Возвращает login из js-параметров конкретного элемента 'row' блока 'b-data-table'
     * @private
     * @param {Number} index
     */
    _getRowLogin: function(index) {
        return this._tableParams[index].login;
    },

    /**
     * Обработчик изменений в группе чекбоксов
     * @private
     * @param {jQuery.Event} [e]
     * @param {Object} [data] Объект с индексами выбранных чекбоксов
     */
    _onCheckboxesChange: function(e, data) {
        this._getMassActions().updateActions(
            data.indexes.map(function(index) {

                return this._getRowLogin(+index);
            }, this)
        );
    },

    /**
     * Переключатель представителей в таблице
     * @private
     * @param {jQuery.Event} [e]
     */
    _repsToggle: function(e) {
        var toggle = $(e.data.domElem),
            groupSelector = this.buildSelector('group'),
            group = this.findElem(toggle.parents(groupSelector), 'group');

        this.toggleMod(group, 'hide-reps', '', 'yes');
    },

    /**
     * Переключает столбец метрики в таблице
     * @private
     */
    _metricaToggle: function() {
        var hidden = this.getMod('metrika') == 'hidden',
            yaCounter = this.elem('ya-counters').eq(0);

        this.toggleMod('metrika', 'hidden');
        this._iUserOptions.set('show_extended_client_info', hidden);
    },

/* Поиск */

    /**
     * Обработчик события начала поиска
     * @private
     */
    _onSearchStart: function() {
        this.setMod(this._group, 'hidden', 'yes');
    },

    /**
     * Обработчик события окончания поиска
     * Прячем группы без кампаний и пересчитываем Всего/Итого
     * @private
     * @param {jQuery.Event} [e]
     * @param {Object} [data]
     *  @param {Object} data.iterator итератор поиска
     */
    _onSearchFinish: function(e, data) {
        this.__base.apply(this, arguments);

        var visibleLen = data.iterator.visible.length;

        this
            .setMod(this.elem('table'), 'visibility', visibleLen ? '' : 'hidden')
            .setMod(this.elem('result-empty'), 'visibility', visibleLen ? 'hidden' : '');
    },

    /**
     * Подсветка совпавшей подстроки
     * @param {Object} data
     *  @param {Object} data.item найденный элемент
     *  @param {Object} data.iterator итератор поиска
     */
    highlight: function(data) {
        this.__base.apply(this, arguments);

        var iterator = data.iterator,
            item = data.item,
            queryText = iterator.query.text,
            repsMatched = queryText.length && ~item.repsSearchIndex.indexOf(queryText);

        this.setMod(item.domElem, 'reps-hlted', repsMatched ? 'yes' : '');
    },

/* END Поиск */

/* Конфирмы для row_actions */

    _getConfirm: function() {
        !this._confirm && (this._confirm = BEM.blocks['b-confirm']);

        return this._confirm;
    },

    _getConfirmMessage: function(params) {
        var message;

        switch (params.type) {
            case 'archiveUser':
                message = iget2('b-showclients-list', 'vy-deystvitelno-hotite-arhivirovat', 'Вы действительно хотите архивировать этого клиента?');
                break;
            case 'unArchiveUser':
                message = iget2('b-showclients-list', 'vy-deystvitelno-hotite-razarhivirovat', 'Вы действительно хотите разархивировать этого клиента?');
                break;
            case 'deleteTeamleader':
                message = iget2('b-showclients-list', 'vy-deystvitelno-hotite-udalit', 'Вы действительно хотите удалить этого тимлидера?');
                break;
            case 'deleteManager':
                message = iget2('b-showclients-list', 'vy-deystvitelno-hotite-udalit-101', 'Вы действительно хотите удалить этого менеджера?');
                break;
            case 'unServicingCamp':
                message = iget2('b-showclients-list', 'vy-deystvitelno-hotite-snyat', 'Вы действительно хотите снять с обслуживания клиента {foo}?', {
                    foo: params.login
                });
                break;
            case 'moveClientToMain':
                message = iget2(
                    'b-showclients-list',
                    'vy-deystvitelno-hotite-prekratit',
                    'Вы действительно хотите прекратить обслуживание клиента {foo} представителем {bar}?',
                    {
                        foo: params.login,
                        bar: params.ulogin
                    }
                );
                break;
            default:
                message = null;
                break;
        }

        return message;
    },

    _actionsConfirm: function(e) {
        var domElem = e.data.domElem,
            params = this.elemParams(domElem) || {},
            type = params.type;

        if (!type) return;

        this._getConfirm().open({
            limited: true,
            message: this._getConfirmMessage(params),
            onYes: function() {
                window.location = domElem.attr('href');
            }
        }, this);

        e.preventDefault();
    },

/*  END Конфирмы для row_actions */

    _offlineSearch: function(e, data) {
        BEM.create({ block: 'i-request', mods: { type: 'form' } })
            .submit(data, { url: '/registered/main.pl', type: 'get' });
    }

}, {

    live: function() {
        this
            .liveBindTo('confirm-link', 'click', function(e) {
                this._actionsConfirm(e);
            })
            .liveBindTo('reps-toggle', 'click', function(e) {
                this._repsToggle(e);
            })
            .__base.apply(this, arguments);

        return false;
    }

});
