block('b-shows-frequency-control')(
    def()(function() {
        this.defaultModelState = {
            periodName: 'days',
            periodValue: '',
            showsValue: ''
        };

        // задаем значения по умолчанию для полей
        this.ctx.showsValue = this.ctx.showsValue || this.defaultModelState.showsValue;
        this.ctx.periodName = this.ctx.periodName || this.defaultModelState.periodName;
        this.ctx.periodValue = this.ctx.periodValue || this.defaultModelState.periodValue;

        return applyNext();
    }),

    js()(function() {

        return {
            modelName: 'b-shows-frequency-control',
            modelData: {
                showsValue: this.ctx.showsValue,
                periodValue: this.ctx.periodValue,
                periodName: this.ctx.periodName
            },
            defaultModelState: this.defaultModelState
        }
    }),

    content()(function() {
        var periodNameOptions = [{
                elem: 'option',
                attrs: { value: 'days' },
                content: iget2('b-shows-frequency-control', 'dney', 'дней')
            },
            {
                elem: 'option',
                attrs: { value: 'showsPeriod' },
                content: iget2('b-shows-frequency-control', 'period-razmeshcheniya', 'период размещения')
            }],
            currentPeriodName = this.ctx.periodName;

        periodNameOptions.forEach(function(option) {
            option && (option.attrs.value == currentPeriodName) && (option.attrs.selected = 'selected');
        }, this);

        return [
            iget2('b-shows-frequency-control', 'showsvalue-1000-pokazov-za', '{showsValue} показов за {periodValue} {periodName}', {
                showsValue: {
                    block: 'input',
                    mods: {
                        size: 's',
                        theme: 'normal'
                    },
                    mix: [
                        {
                            block: 'b-shows-frequency-control',
                            elem: 'shows-value'
                        },
                        {
                            block: 'b-shows-frequency-control',
                            elem: 'model-field',
                            elemMods: {
                                name: 'showsValue'
                            },
                            js: {
                                name: 'showsValue',
                                type: 'input'
                            }
                        }
                    ],
                    content: {
                        elem: 'control'
                    },
                    value: this.ctx.showsValue
                },

                periodValue: {
                    block: 'input',
                    mods: {
                        size: 's',
                        theme: 'normal'
                    },
                    mix: [
                        {
                            block: 'b-shows-frequency-control',
                            elem: 'period-value',
                            elemMods: {
                                hidden: this.ctx.periodName === 'showsPeriod' ? 'yes' : ''
                            }
                        },
                        {
                            block: 'b-shows-frequency-control',
                            elem: 'model-field',
                            elemMods: {
                                name: 'periodValue'
                            },
                            js: [
                                {
                                    name: 'periodValue',
                                    type: 'input'
                                },
                                {
                                    name: 'periodValueHiddenMod',
                                    type: 'mod',
                                    modName: 'hidden',
                                    block: 'b-shows-frequency-control',
                                    elem: 'period-value'
                                }
                            ]
                        }
                    ],
                    content: {
                        elem: 'control'
                    },
                    value: this.ctx.periodValue
                },

                periodName: {
                    block: 'select',
                    mods: {
                        size: 's',
                        theme: 'normal',
                        disabled: this.ctx.disablePeriodSelect ? 'yes' : ''
                    },
                    mix: [
                        {
                            block: 'b-shows-frequency-control',
                            elem: 'period-name'
                        },
                        {
                            block: 'b-shows-frequency-control',
                            elem: 'model-field',
                            js: {
                                name: 'periodName',
                                type: 'select'
                            }
                        }
                    ],
                    content: [
                        {
                            block: 'button',
                            mix: {
                                block: 'b-shows-frequency-control',
                                elem: 'period-name-button'
                            }
                        },
                        {
                            elem: 'control',
                            content: periodNameOptions
                        }
                    ]
                },

                context: 'showsValue - 1000; periodValue - 10; periodName - дней'
            }),
            {
                elem: 'errors'
            }
        ];
    })
);
