BEM.DOM.decl({ name: 'b-shows-frequency-control', baseBlock: 'i-glue' }, {
    onSetMod: {
        js: function() {
            this.__base.apply(this, arguments);

            this._showsValueInput = this.findBlockInside('shows-value', 'input');

            this._subscriptionManager = BEM.create('i-subscription-manager');

            this._setInitialErrorsState();

            this._bindModelEvents();
        },

        focused: {
            yes: function() {
                this._showsValueInput.setMod('focused', 'yes');
            }
        }
    },

    /**
     * Валидирует значения контрола
     * @returns {Boolean}
     */
    validate: function() {

        return !!this.model.validate().valid;
    },

    /**
     * Устанавливает значения контролов в дефолтное состояние
     * @returns {Boolean}
     */
    reset: function() {
        this.model.update(this.params.defaultModelState);

        this._setInitialErrorsState();

        this._updateErrorFields();
    },

    /**
     * Возвращает выбранные значения контролов установки ставки
     * @returns {{showsValue: Number, periodName: ('days'|'showsPeriod'), periodValue: Number|undefined}}
     */
    getData: function() {
        var modelData = this.model.toJSON(),
            result = u._.pick(modelData, ['showsValue', 'periodName']);

        if (modelData.periodName !== 'showsPeriod') {
            result.periodValue = modelData.periodValue;
        }

        return result;
    },

    /**
     * Удаляет блок и подписки на события
     */
    destruct: function() {
        this._subscriptionManager.dispose();
        this.model.destruct();
        this._subscriptionManager.destruct();

        return this.__base.apply(this, arguments);
    },

    /**
     * Устанавливает изначальное состояние объекта с информацией об ошибках, используемый для подсветки ошибочных полей
     */
    _setInitialErrorsState: function() {
        this._errors = Object.keys(this.model.toJSON()).reduce(function(result, fieldName) {
            result[fieldName] = null;

            return result;
        }, {});
    },

    /**
     * Подписываемся на изменения полей модели ставки
     * и на её валидацию
     * @private
     */
    _bindModelEvents: function() {
        this._subscriptionManager.wrap(this.model)
            .on('periodName', 'change', function() {
                if (this.model.get('periodName') === 'showsPeriod') {
                    this.model.set('periodValue', '');
                    this.model.validate('periodValue');
                }
            }, this)
            .on('change', function(event, data) {
                this.model.validate(data.field);
            }, this)
            .on('validated', this._onValidated, this);
    },

    /**
     * Обработчик валидации модели контрола задания частоты показа
     * @param {Event} e
     * @param {Object} validation
     * @private
     */
    _onValidated: function(e, validation) {
        var errorsData = validation.errorsData || {};

        // если валидируется поле
        if (validation.field) {
            this._errors[validation.field] = validation.valid ? null : validation.errors
        } else {
            Object.keys(this._errors).forEach(function(fieldName) {

                this._errors[fieldName] = errorsData[fieldName] || null;
            }, this);
        }

        this._updateErrorFields();
    },

    /**
     * Посвечивает или снимает подсветку _error_yes с поля в зависимости от состояния
     * @param {String} field
     * @param {Boolean} [state=true]
     */
    _highlightErrorField: function(field, state) {
        var input = this._getControlInput(field);

        input && input.toggleMod('error', 'yes', typeof state == 'boolean' ? state : true);
    },

    /**
     * Возвращает блок поля ввода связанный с полем модели
     * @param {String} field
     * @returns {BEM.DOM<input>}
     * @private
     */
    _getControlInput: function(field) {
        var control = this.elem('model-field', 'name', field);

        return this.findBlockOn(control, 'input');
    },

    /**
     * Обновляет ошибки валидации
     * @private
     */
    _updateErrorFields: function() {
        var errors = [],
            errorsData = this._errors;

        Object.keys(errorsData).forEach(function(errorField) {
            var isFieldWithError = !!errorsData[errorField];

            this._highlightErrorField(errorField, isFieldWithError);

            isFieldWithError && errors.push({
                block: 'b-shows-frequency-control',
                elem: 'error',
                content: errorsData[errorField][0].text
            });
        }, this);

        BEM.DOM.update(this.elem('errors'), BEMHTML.apply(errors));
    }
});
