(function() {
    var maxShowsValue = u.consts('MAX_RF'),
        minShowsValue = 1,
        maxPeriodValue = u.consts('MAX_RF_RESET'),
        minPeriodValue = 1;

    BEM.MODEL.decl('b-shows-frequency-control', {
        showsValue: {
            type: 'blank-number2',
            precision: 0,
            validation: {
                rules: {
                    required: {
                        text: iget2('b-shows-frequency-control', 'ukazhite-znachenie-chastoty-pokazov', 'Укажите значение частоты показов')
                    },
                    gte: {
                        value: maxShowsValue,
                        text: iget2('b-shows-frequency-control', 'chastota-pokazov-dolzhna-byt', 'Частота показов должна быть не больше {maxShowsValue}', {
                            maxShowsValue: maxShowsValue,
                            context: 'maxShowsValue - 1000'
                        })
                    },
                    lte: {
                        value: minShowsValue,
                        text: iget2('b-shows-frequency-control', 'chastota-pokazov-dolzhna-byt-ne-menee', 'Частота показов должна быть не меньше {minShowsValue}', {
                            minShowsValue: minShowsValue,
                            context: 'minShowsValue - 0'
                        })
                    }
                }
            }
        },

        periodValue: {
            type: 'blank-number2',
            precision: 0,
            validation: {
                rules: {
                    required: {
                        text: iget2('b-shows-frequency-control', 'ukazhite-kolichestvo-dney', 'Укажите количество дней')
                    },
                    gte: {
                        value: maxPeriodValue,
                        text: iget2('b-shows-frequency-control', 'kolichestvo-dney-dolzhno-byt', 'Количество дней должно быть не больше {maxPeriodValue}', {
                            maxPeriodValue: maxPeriodValue,
                            context: 'maxPeriodValue - 30'
                        })
                    },
                    lte: {
                        value: minPeriodValue,
                        text: iget2(
                            'b-shows-frequency-control',
                            'kolichestvo-dney-dolzhno-byt-ne-menee',
                            'Количество дней должно быть не меньше {minPeriodValue}',
                            {
                                minPeriodValue: minPeriodValue,
                                context: 'minPeriodValue - 0'
                            }
                        )
                    }
                },
                needToValidate: function() {

                    return this.get('periodName') !== 'showsPeriod';
                }
            }
        },

        periodName: {
            type: 'enum',
            enum: ['days', 'showsPeriod']
        },

        periodValueHiddenMod: {
            type: 'string',
            dependsFrom: 'periodName',
            calculate: function() {

                return this.get('periodName') === 'showsPeriod' ? 'yes' : '';
            }
        }
    });
})();
