BEM.DOM.decl({ block: 'b-sidebar-dna' }, {

    onSetMod: {
        js: function() {
            var dna = window.dna;

            if (!dna) {
                throw new Error('An error has occurred in loading DNA dependencies');
            }

            this.setInitialSidebarPosition(this.params.expanded);
            this.bindToWin('scroll', this.fixPosition.bind(this));

            this._renderDna(dna);

            this._addResizeWatcher();
        }
    },

    setInitialSidebarPosition: function(expanded) {
        // если куки нет (dna еще не выехал)
        if (expanded === undefined) {
            // пробуем взять состояние из local storage
            var isSidebarCollapse;
            try {
                isSidebarCollapse = u.store.get('dna').isSidebarCollapse;
            } catch (e) {
                isSidebarCollapse = false;
            }
            expanded = !isSidebarCollapse;
        }

        this._onToggleSidebar(expanded);
        this.fixPosition();
    },

    _addResizeWatcher: function() {
        var warningsBlock = this.findBlockOutside('b-page').findBlockInside('b-page__warnings');

        if (warningsBlock) {
            var watcher = BEM.blocks['resize-watcher'].getInstance({
                owner: warningsBlock.domElem,
                ignoreWidth: true,
                timeout: 50
            });

            watcher.on('change', function(e, data) {
                this.fixPosition();
            }, this);
        }
    },

    fixPosition: function() {
        var topStyle,
            top = this.domElem.get(0).getBoundingClientRect().top;

        if (top <= 0) {
            topStyle = 0;
        } else {
            topStyle = top;
        }

        this.elem('content').css({
            top: topStyle + 'px',
            transform: 'translateX(' + -window.pageXOffset + 'px)'
        });
    },

    _renderDna: function(dna) {
        var dnaComp = this._getDnaComponent(dna),
            domElem = this.elem('content').get(0);

        BEM.DOM.blocks['b-state-dna'].awaitReady().then(function() {
            dna.reactDOMRender(dnaComp, domElem);

            this.delMod('skeleton');
        }.bind(this));
    },

    _getDnaComponent: function(dna) {
        return dna.reactCreateElement(dna.components.SidebarWrapper, {
            onToggleSidebar: this._onToggleSidebar.bind(this),
            onChangeMenuVisibility: this._onChangeMenuVisibility.bind(this),
            isSidebarOptimizeEnable: this.params.isSidebarOptimizeEnable
        }, null);
    },

    _onToggleSidebar: function(isExpanded) {
        if (isExpanded) {
            this.setMod('expanded', 'yes');
        } else {
            this.delMod('expanded');
        }

        var floaterContent = this.findBlockOutside('b-page').findBlockInside('b-floater__content');
        if (floaterContent) {
            if (isExpanded) {
                floaterContent.setMod('sb-expanded', 'yes');
                floaterContent.delMod('sb-collapsed');
            } else {
                floaterContent.delMod('sb-expanded');
                floaterContent.setMod('sb-collapsed', 'yes');
            }
        }
    },

    _onChangeMenuVisibility: function(isVisible) {
        if (isVisible) {
            this.setMod(this.elem('content'), 'paranja', 'yes');
        } else {
            this.delMod(this.elem('content'), 'paranja');
        }
    }
});
