BEM.DOM.decl({ block: 'b-simple-text-filter', implements: 'i-handle-filter' }, {

    onSetMod: {
        js: function() {
            this._hashMap = this.params.hashMap || {};
            this._filterByKey = this.params.filterByKey;

            this._input = this.findBlockOn('input', 'input');
        }
    },

    /**
     * Инициализирует фильтр
     */
    init: function() {
        this._input.setMod('focused', 'yes');
    },

    /**
     * Сбрасывает фильтр
     */
    reset: function() {
        this._input.val('');
    },

    /**
     * Проверяет попадает ли под выбранный фильтр значение из хэша соответствующее ключу
     * @param {String} key значение уникального ключа в хэше с данными для фильтрации
     * @returns {Boolean}
     */
    filter: function(key) {
        var text = this._hashMap[key],
            searchText;

        if (text) {
            searchText = this._input.val().toLowerCase().trim();

            // пустая строка ввода - не фильтруем
            if (!searchText) return true;

            // исключаем, если не содержит введенный текст или ключ хэша при включенном поиске по нему
            return (text + (this._filterByKey ? key : '')).toLowerCase().indexOf(searchText) > -1;
        }

        return false;
    }

}, {

    live: function() {
        this.liveInitOnBlockInsideEvent('change', 'input', function() {
            this.trigger('change');
        });
    }

});
