BEM.DOM.decl({
    block: 'b-sitelinks-selector',
    modName: 'for',
    modVal: 'dynamic-banner'
}, {

    /**
     * В динамических группах ссылка формируется по условиям нацеливания,
     * поэтому сайтлинки считаются ей не равной
     * @override {b-sitelinks-selector}
     */
    _checkEqualToBannerHref: function(href, model) {
        return false;
    },

    /**
     * {@override b-sitelinks-selector_mode_multi}
     * @returns {m-banner-siltelink[]}
     * @private
     */
    _getAllSitelinksModels: function() {
        var allSitelinkModels = [];

        this.params.adgroupsIds.forEach(function(adgroupId) {
            allSitelinkModels = allSitelinkModels.concat(
                BEM.MODEL.getOrCreate({ name: 'dm-dynamic-group', id: adgroupId }).getBanners().map(function(banner) {
                    return banner.get('sitelinks');
                }));
        }, this);

        return allSitelinkModels;
    },

    /**
     * Для баннеров из групп с фидами домен всегда валиден, потому что его нет
     * @override {b-sitelinks-selector}
     */
    _checkDomain: function(index, hrefDomain, model) {
        if (model.getParentModel().get('data_source') == 'feed') {
            return true
        } else {
            return this.__base.apply(this, arguments);
        }
    }
});
