BEM.DOM.decl({ name: 'b-sitelinks-selector', modName: 'mode', modVal: 'banner' }, {
    onSetMod: {
        js: function() {
            this.__base();

            this._checkAllHrefs();
        }
    },

    /**
     * Установить отображаемый баннер
     * @param {Object} modelParams Параметры модели текущего баннера
     * @param {String} prevId Идентификатор предыдущего баннера
     * @returns {BEM}
     */
    setBanner: function(modelParams, prevId) {
        if (modelParams.id === 'undefined') return;

        this._prevModelId = prevId;
        this.setMod(this.elem('copy'), 'visible', prevId ? 'yes' : 'no');

        if (this.bannerSitelinksModel)
            this._bindToBanner();

        this._disableValidation = true;
        this.model.clear();
        this.bannerModel = BEM.MODEL.getOne(modelParams);
        this.bannerSitelinksModel = this.bannerModel.get('sitelinks');
        this.model.update(this.bannerSitelinksModel.toJSON());
        this.bannerSitelinksModel.fix();
        this._bindToBanner(true);
        this._disableValidation = false;

        this._checkAllHrefs();
        this._validateSitelinks();

        this._setBannerPreview(modelParams, this.bannerModel.provideData());

        this.setMod('for-banner-type', this.bannerModel.get('banner_type') == 'mobile' ? 'mobile' : '');

        return this;
    },

    /**
     * Создает превью и связывает его с текущим баннером
     * @param {Object} modelParams - параметры DM баннера
     * @param {String} modelParams.id - идентификатор модели баннера
     * @param {String} modelParams.parentId - идентификатор модели группы
     * @param {Object} bannerData - данные баннера
     * @private
     */
    _setBannerPreview: function(modelParams, bannerData) {
        var previewElem = BEM.DOM.replace(this.findElem('preview'), BEMHTML.apply({
            block: 'b-banner-preview2',
            mods: {
                type: modelParams.name == 'dm-dynamic-banner' ? 'dynamic' : 'text',
                view: 'sitelinks'
            },
            mix: {
                block: 'b-sitelinks-selector',
                elem: 'preview'
            },
            data: bannerData,
            modelsParams: {
                dmsIds: {
                    bannerId: modelParams.id,
                    groupId: modelParams.parentId
                }
            }
        }));

        this.preview = this.findBlockOn(previewElem, 'b-banner-preview2');
    },

    /**
     * Установить/снять обработчики событий на баннере
     * @param {Boolean} isBind флаг привязать/отвязать события
     * @private
     * @returns {BEM}
     */
    _bindToBanner: function(isBind) {
        this._forEachSitelink(function(i) {
            this.bannerSitelinksModel[isBind ? 'on' : 'un'](
                'title' + i + ' href' + i + ' description' + i, 'change', this._onBannerFieldChange, this);
        });

        !isBind && (this.bannerSitelinksModel = null);

        return this;
    },

    /**
     * Срабатывает на изменении поля модели баннера
     * @param {Event} e
     * @param {Object} data
     * @private
     * @returns {BEM}
     */
    _onBannerFieldChange: function(e, data) {
        this.model.set(data.field, this.bannerSitelinksModel.get(data.field));

        return this;
    },

    /**
     * Срабатывает на изменении поля модели сайтлинков
     * @param {Event} e
     * @param {Object} data
     * @param {String} data.field
     * @param {String} data.value
     * @returns {BEM}
     * @private
     */
    _onModelFieldChange: function(e, data) {
        if (this.bannerSitelinksModel) this.bannerSitelinksModel.set(data.field, data.value);

        this.__base(e, data);

        return this;
    },

    /**
     * Скрывает/показывает описания к сайтлинкам
     * @param {Boolean} condition
     * @private
     */
    _toggleDescriptions: function(condition) {

        this.__base(condition);

        this.preview &&
            this.preview.setMod(
                'view',
                this.getMod('description') == 'visible' ?
                    'present-target-sitelinks' :
                    'present-sitelinks'
            );
    },

    /**
     * Вызывается в b-outboard-control перед показом
     * @param {Object} params
     * @returns {BEM}
     */
    prepareToShow: function(params) {
        this.setBanner(params.modelParams, params.prevBid);

        return this.__base(params);
    },

    /**
     * Вызывается в b-outboard-control после нажатия accept-button
     * @returns {BEM}
     */
    provideData: function() {
        if (!this.bannerSitelinksModel) return this;

        this.bannerSitelinksModel.update(this.model.toJSON()).fix();
        this._bindToBanner(false);

        return this;
    },

    /**

    /**
     * Вызывается в b-outboard-control после нажатия decline-button
     * @returns {BEM}
     */
    declineChange: function() {
        this.bannerSitelinksModel.rollback();

        return this;
    }
});
