BEM.DOM.decl({ name: 'b-sitelinks-selector', modName: 'mode', modVal: 'multi' }, {

    onSetMod: {
        js: function() {
            this.__base();

            var allSitelinkModels = this._getAllSitelinksModels();

            this._fieldsList = this._getFields();

            this._fillCommonDataDebounce = $.debounce(this._fillCommonData, 10);

            allSitelinkModels.forEach(function(model) {
                model.on('fix', this._fillCommonDataDebounce, this);
            }, this);

            this._forEachSitelink(function(i) {
                this._fieldsList.forEach(function(name) {
                    if (name !== 'turbolanding') {
                        this.model.on(
                            'common_' + name + i, 'change',
                            { name: name, index: i },
                            this._onCommonFlagChange,
                            this
                        );

                        this._getControl(name, i).on('focus', { index: i, name: name }, this._onInputFocus, this);
                    }

                }, this);
            });

            this
                ._fillCommonData()
                ._updateCounters()
                ._checkDescriptionVisibility();

            this.findBlockOutside('popup').on('show', function() {
                this
                    ._fillCommonData()
                    ._checkAllHrefs()
                    ._checkDescriptionVisibility();
            }, this);
        }
    },

    /**
     * Показывает описание к сайтлинкам если они есть
     * @private
     */
    _checkDescriptionVisibility: function() {
        var sitelinksWithDescription = false;

        this._forEachSitelink(function(i) {
            sitelinksWithDescription = sitelinksWithDescription ||
                !!this.model.get('common_description' + i) ||
                !!this.model.get('description' + i);
        });

        this._toggleDescriptions(sitelinksWithDescription);
    },

    /**
     *
     * @returns {Array}
     * @private
     */
    _getAllSitelinksModels: function() {
        var allSitelinkModels = [];

        this.params.adgroupsIds.forEach(function(adgroupId) {
            allSitelinkModels = allSitelinkModels.concat(
                BEM.MODEL.getOrCreate({ name: 'm-group', id: adgroupId }).getBanners().map(function(banner) {
                    return banner.get('sitelinks');
                }));
        }, this);

        return allSitelinkModels;
    },

    /**
     * Заполняет модель группового редактирования сайтлинков данными
     * @returns {BEM}
     */
    _fillCommonData: function() {
        var data = {};

        this._getAllSitelinksModels().forEach(function(m, index) {
            if (index) {
                this._forEachSitelink(function(i) {
                    this._fieldsList.forEach(function(item) {
                        var commonName = 'common_' + item;

                        if (data[commonName + i] || data[item + i] != m.get(item + i)) {
                            data[commonName + i] = true;
                            data[item + i] = '';
                        } else {
                            data[commonName + i] = false;
                        }
                    }, this);
                });
            } else {
                this._forEachSitelink(function(i) {
                    this._fieldsList.reduce(function(result, field) {
                        field = field + i;
                        data[field] = m.get(field);

                        return result;
                    }, data);
                });
            }
        }, this);

        this.model.update(data);

        return this;
    },

    /**
     * Сравнивает два урла между собой
     * @param {Number} index1
     * @param {Number} index2
     * @returns {Boolean}
     */
    _isLinksEqual: function(index1, index2) {
        return !this.model.get('common_href' + index1) && !this.model.get('common_href' + index2) &&
            this.__base(index1, index2);
    },

    /**
     *
     * @param {Number} index1
     * @param {Number} index2
     * @returns {Boolean}
     * @private
     */
    _isTitleEqual: function(index1, index2) {
        return !this.model.get('common_title' + index1) && !this.model.get('common_title' + index2) &&
            this.__base(index1, index2);
    },

    /**
     * Возвращает длину заголовка с заданным индексом
     * @param {Number} i
     * @returns {Number}
     * @private
     */
    _getTitleLength: function(i) {
        return this.model.get('common_title' + i) ? 0 : this.model.get('title' + i).length;
    },

    /**
     * Возвращает длину урла с заданным индексом
     * @param {Number} i
     * @returns {Number}
     * @private
     */
    _getHrefLength: function(i) {
        return this.model.get('common_title' + i) ? 0 : this.model.get('href' + i).length;
    },

    /**
     * Возвращает данные для группового редактирования сайтлинков
     * @returns {Object}
     */
    getJSON: function() {
        var data = this.model.toJSON();

        this._forEachSitelink(function(i) {
            this._fieldsList.forEach(function(item) {
                if (data['common_' + item + i]) delete data[item + i];
                delete data['common_' + item + i];
            }, this);
        });

        return data;
    },

    /**
     * Изменилось значение флага "установлено общее значение для ссылки/урла"
     * @param {Object} e
     * @param {Object} e.data
     * @param {'title'|'href'} e.data.name - имя/урл сайтлинка
     * @param {Number} e.data.index - номер сайтлинка
     * @param {Object} data
     * @returns {BEM}
     * @private
     */
    _onCommonFlagChange: function(e, data) {
        var input = this._getControl(e.data.name, e.data.index);

        input.setMod(input.elem('hint-manual'), 'visibility', data.value ? 'visible' : '');

        return this._validateSitelinks();
    },

    /**
     * Объект различий сайтлинков
     */
    _differentLinks: {},

    /**
     * Заполняет _differentLinks по неидентичности сайтлинков
     * @private
     */
    _updateDifferentLinks: function() {
        var firstBannerLinks = {};

        this._getAllSitelinksModels().forEach(function(m, index) {
            if (index) {
                this._forEachSitelink(function(i) {
                    this._differentLinks[i] || (this._differentLinks[i] = {});

                    ['title', 'href', 'description'].forEach(function(name) {
                        this._differentLinks[i][name] = firstBannerLinks[i][name] != m.get(name + i);
                    }, this);
                });
            } else {
                this._forEachSitelink(function(i) {
                    firstBannerLinks[i] = {
                        title: m.get('title' + i),
                        href: m.get('href' + i),
                        description: m.get('description' + i)
                    };
                });
            }
        }, this);

        return this;
    },

    /**
     * @param {String} name
     * @param {Number} index
     * @returns {Boolean}
     * @private
     */
    _isDifferentLink: function(name, index) {
        return this.model.get('common_' + name + index);
    },

    /**
     * Инпут для ввода урла/названия сайтлинка получил фокус
     * @param {Object} e
     * @param {Object} e.data
     * @param {'title'|'href'} e.data.name - имя/урл сайтлинка
     * @param {Number} e.data.index - номер сайтлинка
     * @returns {BEM}
     * @private
     */
    _onInputFocus: function(e) {
        var name = e.data.name,
            index = e.data.index,
            input = this._getControl(name, index);

        this.model.set('common_' + name + index, false);
        input.delMod(input.elem('hint-manual'), 'visibility');

        return this;
    },

    /**
     * Инпут для ввода урла/названия сайтлинка потерял фокус
     * @param {Object} e
     * @param {Object} e.data
     * @param {'title'|'href'} e.data.name - имя/урл сайтлинка
     * @param {Number} e.data.index - номер сайтлинка
     * @returns {BEM}
     * @private
     */
    _onInputBlur: function(e) {
        var name = e.data.name,
            index = e.data.index,
            input = this._getControl(name, index),
            isDifferentLink = this._isDifferentLink(name, index);

        this.__base(e);

        input.setMod(input.elem('hint-manual'), 'visibility', (!input.val() && isDifferentLink) ? 'visible' : '');

        return this;
    },

    /**
     * Срабатывает на изменении поля модели сайтлинков
     * @param {Object} e
     * @param {Object} e.data
     * @param {'title'|'href'} e.data.name - имя/урл сайтлинка
     * @param {String} e.data.index - номер сайтлинка
     * @param {Object} data
     * @private
     */
    _onModelFieldChange: function(e, data) {
        var name = e.data.name,
            index = e.data.index;

        this.model.set('common_' + name + index, false);

        this.__base(e, data);

        return this;
    }
});
