block('b-sitelinks-selector').mod('turbolandings', 'yes')(

    elem('sitelink').replace()(function() {
        var ctx = this.ctx,
            index = ctx.index,
            sitelinks = ctx.sitelinks,
            clientId = ctx.clientId,
            isMulti = ctx.isMulti;

        return [
            {
                elem: 'sitelinks-title-row',
                index: index,
                sitelinks: sitelinks,
                isMulti: isMulti
            },
            {
                elem: 'sitelinks-href-row',
                index: index,
                sitelinks: sitelinks,
                isMulti: isMulti
            },
            {
                elem: 'sitelinks-turbolanding',
                index: index,
                sitelinks: sitelinks,
                clientId: clientId
            },
            {
                elem: 'sitelinks-description-row',
                index: index,
                sitelinks: sitelinks,
                isMulti: isMulti
            },
            {
                elem: 'sitelinks-error-row',
                index: index
            }
        ]
    }),

    elem('sitelinks-turbolanding').replace()(function() {
        var ctx = this.ctx,
            index = ctx.index,
            sitelinks = ctx.sitelinks,
            clientId = ctx.clientId;

        return {
            block: 'b-layout-table',
            elem: 'row',
            content: [
                {
                    block: 'b-layout-table',
                    elem: 'cell',
                    elemMods: { type: 'number' },
                    mix: [{
                        block: 'b-sitelinks-selector',
                        elem: 'cell'
                    }]
                },
                {
                    block: 'b-layout-table',
                    elem: 'cell',
                    elemMods: { type: 'label' },
                    mix: [{
                        block: 'b-sitelinks-selector',
                        elem: 'cell'
                    }],
                    content: {
                        block: 'b-form-label',
                        content: iget2('b-sitelinks-selector', 'turbolanding-title', 'Турбо-страница:')
                    }
                },
                {
                    block: 'b-layout-table',
                    elem: 'cell',
                    elemMods: { type: 'content' },
                    mix: [{
                        block: 'b-sitelinks-selector',
                        elem: 'cell'
                    }],
                    content: {
                        block: 'b-turbo-landings-selector',
                        mix: {
                            block: 'b-sitelinks-selector',
                            elem: 'turbolanding',
                            elemMods: {
                                index: index
                            }
                        },
                        clientId: clientId,
                        value: u._.get(sitelinks[index], 'turbolanding')
                    }
                }
            ]
        };
    })

);
