BEM.DOM.decl({ name: 'b-sitelinks-selector', modName: 'turbolandings', modVal: 'yes' }, {

    onSetMod: {
        js: function() {
            this.__base();

            this._forEachSitelink(function(i) {
                i = i.toString();

                this.model
                    .get('turbolanding' + i)
                    .on('id', 'change', { index: i, name: 'turbolanding' }, this._onModelFieldChange, this);

                this._turbolandings[i] = this
                    .findBlockOn(this.elem('turbolanding', 'index', i), 'b-turbo-landings-selector')
                    .on('change', { index: i, name: 'turbolanding' }, this._onTurboLandingChange, this)
            });
        }
    },

    /**
     * Возвращает массив полей
     * @return {Array<String>}
     * @private
     */
    _getFields: function() {
        return ['title', 'href', 'url_protocol', 'description', 'turbolanding'];
    },

    /**
     * Проверка, что в ссылке хотя бы что-то заполнено
     * @private
     */
    _isEmpty: function(index) {
        var isTurbolandingEmpty = !this.model.get('turbolanding' + index).provideData();

        return isTurbolandingEmpty && this.__base(index);
    },

    /**
     * Обработчик изменения контрола выбора лендинга
     * @param {Event} e - событие
     * @param {Object} data - данные из контрола
     * @private
     */
    _onTurboLandingChange: function(e, data) {
        var name = e.data.name,
            index = e.data.index;

        if (data && data.id) {
            this.model.set(name + index, data);
        } else {
            this.model.get(name + index).clear();
        }

        this._onModelFieldChange(e, data);
    },

    /**
     * Проверка на правильность заполнения полей
     * @param {Number} index - индекс ссылки
     * @return {Boolean}
     * @private
     */
    _isEmptyFieldsError: function(index) {
        var isHrefEmpty = this.model.isEmpty('href' + index),
            isTurbolandingEmpty = !this.model.get('turbolanding' + index).provideData(),
            isDesktopLandingEmpty = !this._hasDesktopLanding(index);

        //обрабатываем ситуации:
        //стандартную и
        //выбранный турболендинг и пустой href
        return this.__base.apply(this, arguments) || (!isTurbolandingEmpty && isHrefEmpty && isDesktopLandingEmpty);
    },

    /**
     * Проверяет на совпадение турбо-страницы сайтлинка с турбо-страницей баннера
     * @param {String} turbolanding
     * @param {MODEL} model
     * @returns {Boolean}
     * @private
     */
    _checkEqualToBannerTurbolanding: function(turbolanding, model) {
        // приводим к числу, т.к. с сервера приходит '0' для пустого значения
        var sitelinkTurbolandingId = +turbolanding.get('id'),
            bannerTurbolandingId = +model.get('turbolanding').get('id');

        return !!sitelinkTurbolandingId && !!bannerTurbolandingId && (sitelinkTurbolandingId === bannerTurbolandingId);
    }
});
