block('b-sitelinks-selector')(

    js()(function() {
        return {
            hrefMaxLength: this.ctx.hrefMaxLength || u.consts('MAX_URL_LENGTH'),
            domainsExclusionsRegExp: u.consts('VALID_SITELINKS_DOMAINS'),
            modelParams: {
                id: this.ctx.modelId,
                name: this.ctx.modelName || 'm-banner-sitelinks'
            }
        };
    }),

    content()(function() {
        return [
            {
                elem: 'layout',
                content: [
                    this.ctx.fullInfo && [
                        {
                            elem: 'header'
                        },
                        {
                            elem: 'preview',
                            yandexDomain: this.ctx.yandexDomain
                        }
                    ],
                    {
                        elem: 'content',
                        content: [
                            {
                                elem: 'descriptions-toggler',
                                content: [
                                    iget2('b-sitelinks-selector', 'dobavte-opisaniya-k-bystrym', 'Добавьте описания к быстрым ссылкам'),
                                    ' ',
                                    {
                                        block: 'link',
                                        mix: [{
                                            block: 'b-sitelinks-selector',
                                            elem: 'toggler-link',
                                            elemMods: { description: 'visible' }
                                        }],
                                        mods: {
                                            pseudo: 'yes'
                                        },
                                        content: iget2('b-sitelinks-selector', 'skryt', 'скрыть')
                                    },
                                    {
                                        block: 'link',
                                        mix: [{
                                            block: 'b-sitelinks-selector',
                                            elem: 'toggler-link',
                                            elemMods: { description: 'hidden' }
                                        }],
                                        mods: {
                                            pseudo: 'yes'
                                        },
                                        content: iget2('b-sitelinks-selector', 'pokazat', 'показать')
                                    },
                                    {
                                        block: 'b-help-link',
                                        mods: {
                                            type: 'modal'
                                        },
                                        mix: [{
                                            block: 'b-sitelinks-selector',
                                            elem: 'help-link'
                                        }],
                                        stretched: true,
                                        url: u.getHelpUrl('navigational-query')
                                    }
                                ]
                            },
                            {
                                elem: 'additional-hint',
                                content: [
                                    iget2('b-sitelinks-selector', '8-bystryh-v-novom', 'В новом интерфейсе вы можете добавить до 8 быстрых ссылок. Обратите внимание! Пересохранение быстрых ссылок в старом интерфейсе удалит дополнительные быстрые ссылки, которые были заведены в новом интерфейсе.'),
                                ]
                            },
                            {
                                elem: 'errors'
                            },
                            {
                                elem: 'rules',
                                sitelinksMaxLength: u.consts('SITELINKS_MAX_LENGTH'),
                                oneSitelinkMaxLength: u.consts('ONE_SITELINK_MAX_LENGTH')
                            },
                            {
                                elem: 'sitelinks',
                                clientId: this.ctx.clientId
                            }
                        ]
                    }
                ]
            }
        ];
    }),

    elem('header').content()(function() {
        return [
            iget2('b-sitelinks-selector', 'bystrye-ssylki', 'Быстрые ссылки'),
            {
                block: 'b-help-link',
                mods: {
                    type: 'modal'
                },
                url: u.getHelpUrl('quick-links')
            }
        ];
    }),

    elem('sitelinks').content()(function() {
        var ctx = this.ctx,
            sitelinksElems = [],
            banner = this.banner,
            sitelinks = banner && banner.sitelinks || [],
            isMulti = this.mods.mode === 'multi';

        for (var index = 0; index < u.consts('SITELINKS_NUMBER'); index++) {

            sitelinksElems = sitelinksElems.concat({
                block: 'b-sitelinks-selector',
                mods: this.mods,
                elem: 'sitelink',
                index: index,
                sitelinks: sitelinks,
                clientId: ctx.clientId,
                isMulti: isMulti
            });

        }

        sitelinksElems.push({
            elem: 'row',
            content: [
                {
                    elem: 'cell',
                    mix: [{
                        block: 'b-sitelinks-selector',
                        elem: 'actions'
                    }],
                    colspan: 4,
                    content: [
                        {
                            block: 'link',
                            mods: {
                                pseudo: 'yes'
                            },
                            mix: [{
                                block: 'b-sitelinks-selector',
                                elem: 'copy'
                            }],
                            content: iget2('b-sitelinks-selector', 'skopirovat-iz-predydushchego-obyavleniya', 'Скопировать из предыдущего объявления')
                        },
                        {
                            block: 'link',
                            mods: {
                                pseudo: 'yes'
                            },
                            mix: [{
                                block: 'b-sitelinks-selector',
                                elem: 'clear'
                            }],
                            content: iget2('b-sitelinks-selector', 'ochistit-vse', 'Очистить все')
                        }
                    ]
                }
            ]
        });

        return {
            block: 'b-layout-table',
            mods: {
                layout: 'form'
            },
            mix: [{
                block: 'b-sitelinks-selector',
                elem: 'table'
            }],
            content: sitelinksElems
        };
    }),

    elem('sitelink').replace()(function() {
        var index = this.ctx.index,
            sitelinks = this.ctx.sitelinks,
            isMulti = this.ctx.isMulti;

        return [
            {
                block: 'b-sitelinks-selector',
                elem: 'sitelinks-title-row',
                index: index,
                sitelinks: sitelinks,
                isMulti: isMulti
            },
            {
                block: 'b-sitelinks-selector',
                elem: 'sitelinks-href-row',
                index: index,
                sitelinks: sitelinks,
                isMulti: isMulti
            },
            {
                block: 'b-sitelinks-selector',
                elem: 'sitelinks-description-row',
                index: index,
                sitelinks: sitelinks,
                isMulti: isMulti
            },
            {
                block: 'b-sitelinks-selector',
                elem: 'sitelinks-error-row',
                index: index
            }
        ]
    }),

    elem('sitelinks-title-row').replace()(function() {
        var index = this.ctx.index,
            sitelinks = this.ctx.sitelinks,
            isMulti = this.ctx.isMulti;

        return {
            block: 'b-layout-table',
            elem: 'row',
            content: [
                {
                    block: 'b-layout-table',
                    elem: 'cell',
                    elemMods: { type: 'number' },
                    mix: [{
                        block: 'b-sitelinks-selector',
                        elem: 'cell'
                    }],
                    content: '№' + (1 + index)
                },
                {
                    block: 'b-layout-table',
                    elem: 'cell',
                    elemMods: { type: 'label' },
                    mix: [{
                        block: 'b-sitelinks-selector',
                        elem: 'cell'
                    }],
                    content: {
                        block: 'b-form-label',
                        attrs: {
                            for: 'sitelinks-title-' + index
                        },
                        content: iget2('b-sitelinks-selector', 'tekst', 'Текст:')
                    }
                },
                {
                    block: 'b-layout-table',
                    elem: 'cell',
                    elemMods: { type: 'content' },
                    mix: [{
                        block: 'b-sitelinks-selector',
                        elem: 'cell'
                    }],
                    content: {
                        block: 'input',
                        mix: [{
                            block: 'b-sitelinks-selector',
                            elem: 'title',
                            elemMods: {
                                index: index
                            }
                        }],
                        name: 'sitelinks-title-' + index,
                        value: sitelinks[index] && sitelinks[index].title,
                        content: [
                            isMulti && {
                                elem: 'hint-manual',
                                content: iget2('b-sitelinks-selector', 'v-vybrannyh-obyavleniyah-raznye', 'В выбранных объявлениях разные тексты')
                            },
                            {
                                elem: 'control',
                                attrs: {
                                    tabindex: 1
                                }
                            }
                        ]
                    }
                },
                {
                    block: 'b-layout-table',
                    elem: 'cell',
                    mix: [{
                        block: 'b-sitelinks-selector',
                        elem: 'cell'
                    }],
                    content: [
                        {
                            block: 'b-sitelinks-selector',
                            elem: 'title-counter',
                            elemMods: {
                                index: index
                            },
                            content: ''
                        },
                        {
                            block: 'b-sitelinks-selector',
                            elem: 'title-counter-separator',
                            content: '/'
                        },
                        {
                            block: 'b-sitelinks-selector',
                            elem: 'title-total-counter',
                            elemMods: {
                                index: index
                            },
                            content: ''
                        }
                    ]
                }
            ]
        };
    }),

    elem('sitelinks-href-row').replace()(function() {
        var index = this.ctx.index,
            sitelinks = this.ctx.sitelinks,
            isMulti = this.ctx.isMulti;

        return {
            block: 'b-layout-table',
            elem: 'row',
            content: [
                {
                    block: 'b-layout-table',
                    elem: 'cell',
                    elemMods: { type: 'number' },
                    mix: [{
                        block: 'b-sitelinks-selector',
                        elem: 'cell'
                    }]
                },
                {
                    block: 'b-layout-table',
                    elem: 'cell',
                    elemMods: { type: 'label' },
                    mix: [{
                        block: 'b-sitelinks-selector',
                        elem: 'cell',
                        elemMods: {
                            type: 'link'
                        }
                    }],
                    content: {
                        block: 'b-form-label',
                        attrs: {
                            for: 'sitelinks-href-' + index
                        },
                        content: iget2('b-sitelinks-selector', 'ssylka', 'Ссылка:')
                    }
                },
                {
                    block: 'b-layout-table',
                    elem: 'cell',
                    elemMods: { type: 'content' },
                    mix: [{
                        block: 'b-sitelinks-selector',
                        elem: 'cell'
                    }],
                    content: [
                        {
                            block: this.block,
                            elem: 'sitelink-url',
                            content: [
                                {
                                    block: 'select',
                                    name: 'sitelinks-url_protocol' + index,
                                    mix: [
                                        {
                                            block: 'b-sitelinks-selector',
                                            elem: 'url-protocol',
                                            elemMods: {
                                                index: index
                                            }
                                        }
                                    ],
                                    content: [
                                        {
                                            block: 'button',
                                            content: 'https://'
                                        },
                                        {
                                            elem: 'control',
                                            content: ['https://', 'http://'].map(function(protocol) {
                                                return {
                                                    elem: 'option',
                                                    attrs: {
                                                        value: protocol
                                                    },
                                                    content: protocol
                                                };
                                            })
                                        }
                                    ]
                                },
                                {
                                    block: 'input',
                                    mods: {
                                        size: 'xs',
                                        type: 'textarea'
                                    },
                                    mix: [
                                        {
                                            block: 'b-sitelinks-selector',
                                            elem: 'href',
                                            elemMods: {
                                                index: index
                                            }
                                        }
                                    ],
                                    name: 'sitelinks-href' + index,
                                    value: sitelinks[index] && sitelinks[index].value,
                                    content: [
                                        isMulti && {
                                            elem: 'hint-manual',
                                            content: iget2('b-sitelinks-selector', 'v-vybrannyh-obyavleniyah-raznye-107', 'В выбранных объявлениях разные ссылки')
                                        },
                                        {
                                            elem: 'control',
                                            attrs: {
                                                rows: 2,
                                                tabindex: 1
                                            }
                                        }
                                    ]
                                }
                            ]
                        }
                    ]
                },
                {
                    block: 'b-layout-table',
                    elem: 'cell',
                    mix: [{
                        block: 'b-sitelinks-selector',
                        elem: 'cell',
                        elemMods: {
                            type: 'link'
                        }
                    }],
                    content: {
                        block: 'b-sitelinks-selector',
                        elem: 'href-counter',
                        elemMods: {
                            index: index
                        },
                        content: ''
                    }
                }
            ]
        };
    }),

    elem('sitelinks-description-row').replace()(function() {
        var index = this.ctx.index,
            sitelinks = this.ctx.sitelinks;

        return {
            block: 'b-layout-table',
            elem: 'row',
            mix: [{
                block: 'b-sitelinks-selector',
                elem: 'description-row'
            }],
            content: [
                {
                    block: 'b-layout-table',
                    elem: 'cell',
                    elemMods: { type: 'number' },
                    mix: [{
                        block: 'b-sitelinks-selector',
                        elem: 'cell'
                    }]
                },
                {
                    block: 'b-layout-table',
                    elem: 'cell',
                    elemMods: { type: 'label' },
                    mix: [{
                        block: 'b-sitelinks-selector',
                        elem: 'cell'
                    }],
                    content: {
                        block: 'b-form-label',
                        attrs: {
                            for: 'sitelinks-description-' + index
                        },
                        content: iget2('b-sitelinks-selector', 'opisanie', 'Описание:')
                    }
                },
                {
                    block: 'b-layout-table',
                    elem: 'cell',
                    elemMods: { type: 'content' },
                    mix: [{
                        block: 'b-sitelinks-selector',
                        elem: 'cell'
                    }],
                    content: {
                        block: 'input',
                        mix: [
                            {
                                block: 'b-sitelinks-selector',
                                elem: 'description',
                                elemMods: {
                                    index: index
                                }
                            }
                        ],
                        name: 'sitelinks-description-' + index,
                        value: sitelinks[index] && sitelinks[index].description,
                        content: [
                            this.ctx.isMulti && {
                                elem: 'hint-manual',
                                content: iget2('b-sitelinks-selector', 'v-vybrannyh-obyavleniyah-raznye', 'В выбранных объявлениях разные тексты')
                            },
                            {
                                elem: 'control',
                                attrs: {
                                    tabindex: 1
                                }
                            }
                        ]
                    }
                },
                {
                    block: 'b-layout-table',
                    elem: 'cell',
                    mix: [{
                        block: 'b-sitelinks-selector',
                        elem: 'cell'
                    }],
                    content: [
                        {
                            block: 'b-sitelinks-selector',
                            elem: 'description-counter',
                            elemMods: {
                                index: index
                            },
                            content: ''
                        }
                    ]
                }
            ]
        };
    }),

    elem('sitelinks-error-row').replace()(function() {
        var index = this.ctx.index;

        return {
            block: 'b-layout-table',
            elem: 'row',
            mix: [{
                block: 'b-sitelinks-selector',
                elem: 'error-row',
                elemMods: {
                    index: index
                }
            }],
            content: [
                {
                    block: 'b-layout-table',
                    elem: 'cell',
                    elemMods: { type: 'number' },
                    mix: [{
                        block: 'b-sitelinks-selector',
                        elem: 'cell'
                    }]
                },
                {
                    block: 'b-layout-table',
                    elem: 'cell',
                    elemMods: { type: 'label' },
                    mix: [{
                        block: 'b-sitelinks-selector',
                        elem: 'cell'
                    }]
                },
                {
                    block: 'b-layout-table',
                    elem: 'cell',
                    elemMods: { type: 'content' },
                    mix: [
                        {
                            block: 'b-sitelinks-selector',
                            elem: 'cell'
                        },
                        {
                            block: 'b-sitelinks-selector',
                            elem: 'error-cell'
                        }
                    ],
                    colspan: 2,
                    content: {
                        block: 'b-sitelinks-selector',
                        elem: 'error',
                        elemMods: {
                            index: index
                        },
                        content: {
                            elem: 'href-error'
                        }
                    }
                },
                {
                    block: 'b-layout-table',
                    elem: 'cell',
                    mix: [{
                        block: 'b-sitelinks-selector',
                        elem: 'cell'
                    }]
                }
            ]
        };
    }),

    elem('title').tag()('h3'),

    elem('title-counter').tag()('span'),

    elem('title-total-counter').tag()('span'),

    elem('title-counter-separator').tag()('span'),

    elem('buttons').content()(function() {
        return [
            {
                block: 'button',
                mods: { disabled: 'yes', theme: 'action' },
                mix: [
                    {
                        block: 'popup',
                        elem: 'accept-button'
                    },
                    {
                        block: 'b-outboard-controls',
                        elem: 'accept-button'
                    },
                    {
                        block: 'b-sitelinks-selector',
                        elem: 'accept-button'
                    }
                ],
                content: iget2('b-sitelinks-selector', 'sohranit', 'Сохранить')
            },
            {
                block: 'button',
                mix: [
                    {
                        block: 'popup',
                        elem: 'decline-button'
                    },
                    {
                        block: 'b-outboard-controls',
                        elem: 'decline-button'
                    },
                    {
                        block: 'b-sitelinks-selector',
                        elem: 'decline-button'
                    }
                ],
                content: iget2('b-sitelinks-selector', 'otmena', 'Отмена')
            }
        ];
    }),

    elem('error').content()(function() {
        return [
            {
                block: 'icon',
                mods: { 'size-13': 'alert' },
                mix: [{
                    block: 'b-sitelinks-selector',
                    elem: 'error-icon'
                }]
            },
            this.ctx.content
        ];
    }),

    elem('errors').content()(function() {
        return [
            {
                block: 'b-sitelinks-selector',
                elem: 'error',
                elemMods: { type: 'equal-titles' },
                content: iget2('b-sitelinks-selector', 'teksty-ssylok-dolzhny-byt', 'Тексты ссылок должны быть разными.')
            },
            {
                block: 'b-sitelinks-selector',
                elem: 'error',
                elemMods: { type: 'equal-turbolandings' },
                content: iget2('b-sitelinks-selector', 'equal-turbolandings', 'Турбо-страницы для быстрых ссылок не должны совпадать.')
            },
            {
                block: 'b-sitelinks-selector',
                elem: 'error',
                elemMods: { type: 'length' },
                content: iget2(
                    'b-sitelinks-selector',
                    'prevyshena-dopustimaya-dlina-teksta',
                    'Превышена допустимая длина текста одной быстрой ссылки в 30 символов.'
                )
            },
            {
                block: 'b-sitelinks-selector',
                elem: 'error',
                elemMods: { type: 'total-length' },
                content: iget2(
                    'b-sitelinks-selector',
                    'prevyshena-dopustimaya-dlina-tekstov',
                    'Превышена допустимая длина текстов ссылок в 66 символов.'
                )
            },
            {
                block: 'b-sitelinks-selector',
                elem: 'error',
                elemMods: { type: 'description-length' },
                content: iget2(
                    'b-sitelinks-selector',
                    'prevyshena-dopustimaya-dlina-opisaniya',
                    'Превышена допустимая длина описания одной быстрой ссылки в 60 символов.'
                )
            },
            {
                block: 'b-sitelinks-selector',
                elem: 'error',
                elemMods: { type: 'equal-descriptions' },
                content: iget2('b-sitelinks-selector', 'opisaniya-bystryh-ssylok-dolzhny', 'Описания быстрых ссылок должны быть разными.')
            }
        ];
    }),

    elem('rules').content()(function() {
        var rules = [
            iget2('b-sitelinks-selector', 'mozhno-sohranit-odnu-dve', 'Можно сохранить одну, две, три или четыре быстрые ссылки.'),
            iget2('b-sitelinks-selector', 'maksimalnaya-dlina-teksta-odnoy', 'Максимальная длина текста одной ссылки: {foo} символов.', {
                foo: u.consts('ONE_SITELINK_MAX_LENGTH')
            }),
            iget2('b-sitelinks-selector', 'summarnaya-dlina-teksta-ssylok', 'Суммарная длина текста ссылок: {foo} символов', {
                foo: u.consts('SITELINKS_MAX_LENGTH')
            }),
            iget2(
                'b-sitelinks-selector',
                'ssylki-mogut-vesti-na',
                'Ссылки могут вести на разные страницы основного сайта, страницы товара/услуги на Яндекс.Маркете, социальных сетях.'
            ),
            iget2('b-sitelinks-selector', 'teksty-ssylok-dolzhny-byt-106', 'Тексты ссылок должны быть разными'),
            {
                elem: 'rule',
                elemMods: { bullet: 'no' },
                content: {
                    block: 'b-help-link',
                    url: u.getHelpUrl('quick-links'),
                    text: iget2('b-sitelinks-selector', 'podrobnee', 'Подробнее')
                }
            }
        ];

        return rules.map(function(rule) {
            return typeof rule == 'object' ? rule : {
                elem: 'rule',
                content: rule
            };
        });
    })
);
