block('b-sms-authentication')(

    js()(function() {
        return {
            retpath: this.ctx.retpath
        };
    }),

    content()(function() {
        return [
            {
                elem: 'title',
                content: iget2('b-sms-authentication', 'api-access', 'Получение доступа к API')
            },
            {
                block: 'spin2',
                mix: [
                    { block: 'b-sms-authentication', elem: 'spinner' }
                ],
                mods: {
                    size: 's',
                    progress: 'yes'
                }
            },
            {
                elem: 'send-sms-form'
            },
            {
                elem: 'validate-code-form'
            },
            {
                elem: 'errors-wrapper',
                content: [
                    {
                        block: 'icon',
                        mods: {
                            'size-16': 'alert'
                        },
                        mix: [
                            { block: 'b-sms-authentication', elem: 'error-icon' }
                        ]
                    },
                    {
                        elem: 'errors'
                    }
                ]
            }
        ];
    }),

    elem('send-sms-form').content()(function() {
        return [
            {
                elem: 'sms-phone'
            },
            {
                elem: 'disclaimer',
                content: iget2('b-sms-authentication', 'daily-tries', 'Не более 5 попыток в день')
            },
            {
                block: 'button2',
                mix: [
                    { block: 'b-sms-authentication', elem: 'send-sms-button' }
                ],
                mods: {
                    size: 'n',
                    theme: 'action'
                },
                text: iget2('b-sms-authentication', 'send-sms', 'Отправить СМС')
            }
        ]
    }),

    elem('validate-code-form').content()(function() {
        return [
            {
                elem: 'code-input-title',
                content: [
                    {
                        elem: 'code-input-label',
                        content: iget2('b-sms-authentication', 'input-code', 'Введите код из СМС. {timer}', {
                            timer: {
                                elem: 'code-input-timer'
                            }
                        })
                    },
                    {
                        elem: 'timer-expired',
                        content: [
                            iget2('b-sms-authentication', 'code-expired', 'Время действия кода истекло.'),
                            {
                                block: 'link',
                                mix: [
                                    { block: 'b-sms-authentication', elem: 'resend-sms-link' }
                                ],
                                mods: {
                                    pseudo: 'yes',
                                    theme: 'normal'
                                },
                                text: iget2('b-sms-authentication', 'send-again', 'Отправить ещё раз')
                            }
                        ]
                    }
                ]
            },
            {
                elem: 'check-code',
                content: [
                    {
                        block: 'input',
                        mods: {
                            size: 'n',
                            theme: 'normal',
                            clear: 'yes'
                        },
                        mix: [
                            { block: 'b-sms-authentication', elem: 'code-input' }
                        ],
                        content: { elem: 'control' }
                    },
                    {
                        block: 'button2',
                        mix: [
                            { block: 'b-sms-authentication', elem: 'validate-code-button' }
                        ],
                        mods: {
                            size: 'n',
                            theme: 'action'
                        },
                        text: iget2('b-sms-authentication', 'validate-code', 'Проверить')
                    }
                ]
            }
        ]
    }),

    elem('code-input-timer').tag()('span'),
    elem('errors').tag()('span'),
    elem('phone-number').tag()('span'),
    elem('code-input-label').tag()('span'),
    elem('timer-expired').tag()('span'),
    elem('timer')(
        tag()('span'),

        content()(function() {
            return iget2('b-sms-authentication', 'time-left', 'У вас осталось {time}', {
                time: this.ctx.timeString
            });
        })
    )
);
