BEM.DOM.decl('b-sms-authentication', {
    onSetMod: {
        js: function() {
            this._subscriptionManager = BEM.create('i-subscription-manager');

            this._sendSmsButton = this.findBlockOn('send-sms-button', 'button2');
            this._validateCodeButton = this.findBlockOn('validate-code-button', 'button2');

            this._subscriptionManager.on(this._sendSmsButton, 'click', this.sendSms, this);
            this._subscriptionManager.on(this.findBlockOn('resend-sms-link', 'link'), 'click', this.sendSms, this);
            this._subscriptionManager.on(this._validateCodeButton, 'click', this.validateCode, this);

            BEM.blocks['i-web-api-request'].smsAuth.getPhoneForSms()
                .then(function(response) {
                    if (!response.success) {
                        this.delMod('mode');
                        this.showError(iget2('b-sms-authentication', 'something-broke', 'Что-то пошло не так! Попробуйте ещё раз позднее'));
                    } else if (!response.result.smsPhoneId) {
                        this.delMod('mode');
                        this.showError(iget2('b-sms-authentication', 'null-phone', 'Номер телефона не найден. Укажите номер телефона в Яндекс.Паспорте'));
                    } else {
                        this.phoneId = response.result.smsPhoneId;

                        BEM.DOM.update(this.elem('sms-phone'), iget2('b-sms-authentication', 'sms-phone', 'Временный код будет отправлен по номеру телефона {phone}', {
                            phone: BEMHTML.apply({
                                block: 'b-sms-authentication',
                                elem: 'phone-number',
                                content: response.result.smsPhone
                            })
                        }));

                        this.setMod('mode', 'send-sms');
                    }
                }.bind(this))
                .catch(function() {
                    this.delMod('mode');
                    this.showError(iget2('b-sms-authentication', 'something-broke', 'Что-то пошло не так! Попробуйте ещё раз позднее'));
                }.bind(this));
        }
    },

    destruct: function() {
        this._subscriptionManager.dispose();
        this._subscriptionManager.destruct();

        this.__base.apply(this, arguments);
    },

    sendSms: function() {
        var response;

        this.hideError();
        this.delMod('timer-expired');
        BEM.DOM.update(this.elem('code-input-timer'), '');
        this._sendSmsButton.setMod('progress', 'yes');

        BEM.blocks['i-web-api-request'].smsAuth.sendSms(this.phoneId)
            .then(function() {
                this.triesLeft = 3;

                this.startTimer();
                this.setMod('mode', 'validate-code');
                this._sendSmsButton.delMod('progress');
            }.bind(this))
            .catch(function(err) {
                response = err && err.obj && err.obj.validation_result || {};

                this._sendSmsButton.delMod('progress');
                this.onError(response.errors);
            }.bind(this))
    },

    validateCode: function() {
        var response;

        this.hideError();

        this._validateCodeButton.setMod('progress', 'yes');

        this.triesLeft -= 1;
        if (!this.triesLeft) {
            this.setMod('timer-expired', 'yes');
        }

        BEM.blocks['i-web-api-request'].smsAuth.checkPassword(this.findBlockOn('code-input', 'input').val())
            .then(function() {
                window.location = this.params.retpath;
            }.bind(this))
            .catch(function(err) {
                response = err && err.obj && err.obj.validation_result || {};

                this._validateCodeButton.delMod('progress');

                this.onError(response.errors)
            }.bind(this));
    },

    startTimer: function() {
        var seconds = 180, // 3 минуты
            startTime = new Date().getTime();

        this.endTime = startTime + seconds * 1000;

        if (this.timer) {
            clearTimeout(this.timer);
        }

        this.iterateTimer();
    },

    iterateTimer: function() {
        var seconds = (this.endTime - new Date().getTime()) / 1000,
            leftMinutes = Math.floor(seconds / 60),
            leftSeconds = Math.floor(seconds - leftMinutes * 60),
            leftSecondsFormatted = (leftSeconds + 100).toString().slice(1),
            timeString;

        if (seconds <= 0) {
            this.setMod('timer-expired', 'yes');
            return;
        }

        if (leftMinutes) {
            timeString = iget2('b-sms-authentication', 'minutes-and-seconds-left', '{min} мин. {sec} сек.', {
                min: leftMinutes,
                sec: leftSecondsFormatted
            });
        } else {
            timeString = iget2('b-sms-authentication', 'seconds-left', '{sec} сек.', {
                sec: leftSecondsFormatted
            });
        }

        BEM.DOM.update(this.elem('code-input-timer'), BEMHTML.apply({
            block: 'b-sms-authentication',
            elem: 'timer',
            timeString: timeString
        }));

        this.timer = setTimeout(this.iterateTimer.bind(this), 1000);
    },

    onError: function(errors) {
        var errorText = errors[0] && errors[0].text;

        this.showError(errorText);
    },

    showError: function(errorText) {
        this.elem('errors').text(errorText);
        this.setMod(this.elem('errors-wrapper'), 'visible', 'yes');
    },

    hideError: function() {
        this.delMod(this.elem('errors-wrapper'), 'visible');
    }
});
