block('b-sms-notification')(
    def()(function() {
        var options = this.ctx.options,
            minValues = ['00', '15', '30', '45'],
            sms_flags = options.sms_flags || {},
            smsTime = (options.sms_time && options.sms_time.split(':')) || {},
            sms_hour_from = options.sms_hour_from !== undefined ? options.sms_hour_from : smsTime[0],
            sms_hour_to = options.sms_hour_to !== undefined ? options.sms_hour_to : smsTime[2],

            data = {
                active_orders_money_out_sms: sms_flags.active_orders_money_out_sms,
                notify_order_money_in_sms: sms_flags.notify_order_money_in_sms,
                moderate_result_sms: sms_flags.moderate_result_sms,
                notify_metrica_control_sms: sms_flags.notify_metrica_control_sms,
                camp_finished_sms: sms_flags.camp_finished_sms,
                sms_time_hour_from: sms_hour_from !== undefined ? sms_hour_from : '09',
                sms_time_min_from: minValues[options.sms_min_from] || smsTime[1],
                sms_time_hour_to: sms_hour_to !== undefined ? sms_hour_to : '21',
                sms_time_min_to: minValues[options.sms_min_to] || smsTime[3],
                paused_by_day_budget_sms: sms_flags.paused_by_day_budget_sms
            };

        return applyNext({
            modelData: data
        });
    }),

    addJs()(function() {
        var options = this.ctx.options,
            jsParams = {
                phone: options.sms_phone,
                modelData: this.modelData,
                d: this.data
            };

        return jsParams;
    }),

    content()(function() {
        var options = this.ctx.options,
            data = this.data,
            login_rights = data.login_rights,
            phone = options.sms_phone,
            md = this.modelData;

        return {
            block: 'b-layout-form',
            mods: {
                inner: 'yes'
            },
            mixes: {
                row: [{
                    block: 'b-sms-notification',
                    elem: 'row'
                }],
                label: [{
                    block: 'b-sms-notification',
                    elem: 'label'
                }],
                control: [{
                    block: 'b-sms-notification',
                    elem: 'control'
                }],
                info: [{
                    block: 'b-sms-notification',
                    elem: 'info'
                }]
            },
            rows: [
                {
                    label: iget2('b-sms-notification', 'nomer-telefona', 'Номер телефона'),
                    control: [
                        phone ?
                            {
                                elem: 'sms-phone',
                                content: phone.replace(/(\d\d)(\d\d)$/, '-$1-$2')
                            } :
                            {
                                elem: 'sms-phone-empty',
                                content: iget2('b-sms-notification', 'ne-ukazan', 'не указан')
                            },
                        (hasLoginRights('is_any_client') || (login_rights.role == 'empty')) && [
                            {
                                block: 'b-link',
                                mix: [{
                                    block: 'b-sms-notification',
                                    elem: 'passport-phone'
                                }],
                                attrs: {
                                    target: '_blank'
                                },
                                url: u.formatUrl({
                                    path: '//' + data.passport_domain + '/profile/phones',
                                }),
                                content: '(' + (phone ? iget2('b-sms-notification', 'izmenit-nomer', 'изменить номер') : iget2('b-sms-notification', 'ukazat-nomer', 'указать номер')) + '&hellip;)'

                            },
                            {
                                block: 'b-sms-notification',
                                elem: 'warning',
                                content: this.ctx.passportPhoneWarning
                            }
                        ]
                    ]
                },
                {
                    label: iget2('b-sms-notification', 'uvedomleniya', 'Уведомления'),
                    control: applyCtx({
                        block: 'b-sms-notification',
                        elem: 'notifications',
                        options: options,
                        phone: phone
                    })
                },
                {
                    label: [
                        iget2('b-sms-notification', 'vremya-nbsp-otpravki', 'Время&nbsp;отправки'),
                        {
                            block: 'b-sms-notification',
                            elem: 'timezone-alarm',
                            content: iget2('b-sms-notification', 'utc-3-moskovskoe-vremya', '(UTC+3, московское время)')
                        }
                    ],
                    control: applyCtx({
                        block: 'b-worktime',
                        disabled: !phone,
                        hourFrom: md.sms_time_hour_from,
                        minFrom: md.sms_time_min_from,
                        hourTo: md.sms_time_hour_to,
                        minTo: md.sms_time_min_to
                    })
                }
            ]
        };
    }),

    elem('notifications').content()(function() {
        var phone = this.ctx.phone,
            options = this.ctx.options,
            campaign = options,
            smsFlags = options.sms_flags || {},
            isCampaign = !!options.isCampaign,
            noWallet = !isCampaign || options.wallet_cid == '0' || !options.wallet_cid,
            cashback_sms_notifications_enabled = u.consts('clientFeaturesAll') ? u.consts('clientFeaturesAll').includes('CASHBACK_SMS_NOTIFICATIONS_ENABLED') : false;

        return [
            noWallet && {
                block: 'checkbox',
                mods: {
                    disabled: !phone ? 'yes' : '',
                    checked: smsFlags.active_orders_money_out_sms ? 'yes' : ''
                },
                text: iget2('b-sms-notification', 'ostatok-sredstv', 'Остаток средств'),
                mix: [
                    {
                        block: this.block,
                        elem: 'wallet-items'
                    },
                    {
                        block: 'b-sms-notification',
                        elem: 'active-orders-money-out-sms'
                    },
                    {
                        block: 'b-sms-notification',
                        elem: 'model-field',
                        js: {
                            type: 'checkbox',
                            name: 'active_orders_money_out_sms'
                        }
                    }
                ]
            },
            isCampaign && {
                block: 'checkbox',
                mods: {
                    checked: smsFlags.camp_finished_sms ? 'yes' : '',
                    disabled: !phone || !campaign.is_finish_date_set ? 'yes' : ''
                },
                text: iget2('b-sms-notification', 'ob-okonchanii-kampanii', 'об окончании кампании'),
                mix: [
                    {
                        block: 'b-sms-notification',
                        elem: 'camp-finished-sms'
                    },
                    {
                        block: 'b-sms-notification',
                        elem: 'model-field',
                        js: {
                            type: 'checkbox',
                            name: 'camp_finished_sms'
                        }
                    }
                ]
            },
            isCampaign && {
                block: 'checkbox',
                mods: {
                    disabled: !phone ? 'yes' : '',
                    checked: smsFlags.moderate_result_sms ? 'yes' : ''
                },
                text: iget2('b-sms-notification', 'o-rezultatah-moderacii', 'о результатах модерации'),
                mix: [
                    {
                        block: 'b-sms-notification',
                        elem: 'moderate-result-sms'
                    },
                    {
                        block: 'b-sms-notification',
                        elem: 'model-field',
                        js: {
                            type: 'checkbox',
                            name: 'moderate_result_sms'
                        }
                    }

                ]
            },
            isCampaign && ['content_promotion', 'mobile_content', 'performance'].indexOf(campaign.mediaType) === -1 && {
                block: 'checkbox',
                mods: {
                    disabled: !phone || campaign.statusMetricaControl != 1 ? 'yes' : '',
                    checked: smsFlags.notify_metrica_control_sms ? 'yes' : ''
                },
                text: iget2('b-sms-notification', 'o-rezultatah-monitoringa-saytov', 'о результатах мониторинга сайтов'),
                mix: [
                    {
                        block: 'b-sms-notification',
                        elem: 'notify-metrica-control-sms'
                    },
                    {
                        block: 'b-sms-notification',
                        elem: 'model-field',
                        js: {
                            type: 'checkbox',
                            name: 'notify_metrica_control_sms'
                        }
                    }
                ]
            },

            noWallet && [
                {
                    block: 'checkbox',
                    text: iget2('b-sms-notification', 'postuplenie-sredstv', 'Поступление средств'),
                    mods: {
                        disabled: !phone ? 'yes' : '',
                        checked: smsFlags.notify_order_money_in_sms ? 'yes' : ''
                    },
                    mix: [
                        {
                            block: this.block,
                            elem: 'wallet-items'
                        },
                        {
                            block: 'b-sms-notification',
                            elem: 'notify-order-money-in-sms'
                        },
                        {
                            block: 'b-sms-notification',
                            elem: 'model-field',
                            js: {
                                type: 'checkbox',
                                name: 'notify_order_money_in_sms'
                            }
                        }
                    ]
                },
                {
                    block: 'checkbox',
                    text: iget2('b-sms-notification', 'ostanovka-po-dostizheniyu-dnevnogo', 'Остановка по достижению дневного бюджета'),
                    mods: {
                        disabled: !phone ? 'yes' : '',
                        checked: smsFlags.paused_by_day_budget_sms ? 'yes' : ''
                    },
                    mix: [
                        {
                            block: this.block,
                            elem: 'wallet-items'
                        },
                        {
                            block: 'b-sms-notification',
                            elem: 'paused-by-day-budget-sms'
                        },
                        {
                            block: 'b-sms-notification',
                            elem: 'model-field',
                            js: {
                                type: 'checkbox',
                                name: 'paused_by_day_budget_sms'
                            }
                        }
                    ]
                },
                cashback_sms_notifications_enabled && {
                    block: 'checkbox',
                    text: iget2('b-sms-notification', 'nachislenie-bonusov', 'Начисление бонусов'),
                    mods: {
                        disabled: !phone ? 'yes' : '',
                        checked: smsFlags.notify_cashback_in_sms ? 'yes' : ''
                    },
                    mix: [
                        {
                            block: this.block,
                            elem: 'wallet-items'
                        },
                        {
                            block: 'b-sms-notification',
                            elem: 'cashback-notification-sms'
                        },
                        {
                            block: 'b-sms-notification',
                            elem: 'model-field',
                            js: {
                                type: 'checkbox',
                                name: 'notify_cashback_in_sms'
                            }
                        }
                    ]
                }
            ]
        ];
    })
);
