(function() {
    BEM.MODEL.decl('b-sms-notification', {
        active_orders_money_out_sms: 'flag',
        active_orders_money_warning_sms: 'flag',
        notify_cashback_in_sms: 'flag',
        moderate_result_sms: 'flag',
        notify_metrica_control_sms: 'flag',
        notify_order_money_in_sms: 'flag',
        camp_finished_sms: 'flag',
        notify_metrica_control_sms_disabled: 'flag',
        sms_time_hour_from: 'string',
        sms_time_min_from: 'string',
        sms_time_hour_to: 'string',
        sms_time_min_to: 'string',
        paused_by_day_budget_sms: 'flag'
    });

    var timeMap = {
            hourFrom: 'sms_time_hour_from',
            minFrom: 'sms_time_min_from',
            hourTo: 'sms_time_hour_to',
            minTo: 'sms_time_min_to'
        },
        timeMapReverse = {
            sms_time_hour_from: 'hourFrom',
            sms_time_min_from: 'minFrom',
            sms_time_hour_to: 'hourTo',
            sms_time_min_to: 'minTo'
        };

    BEM.DOM.decl({ name: 'b-sms-notification', baseBlock: 'i-glue', implements: 'i-outboard-controls' }, {
        onSetMod: {
            js: function() {

                this.__base.apply(this, arguments);

                if (this.params.phone) {
                    this.model
                        .on(
                        'sms_time_hour_from sms_time_min_from sms_time_hour_to sms_time_min_to',
                        'change',
                        this.resetTime,
                        this);

                    this._notifyMetricaControlSms = this.findBlockInside('notify-metrica-control-sms', 'checkbox');
                    this._notifyMetricaControlSms && this.model.on('notify_metrica_control_sms_disabled', 'change',
                        function(e, data) {
                            this._notifyMetricaControlSms.setMod('disabled', data.value ? '' : 'yes');
                        }, this);

                    this.timeControl = this.findBlockInside('b-worktime');
                    this.timeControl && this.timeControl.on('change', function(e, data) {
                        this.model.set(timeMap[data.name], data.val, { source: this })
                    }, this);
                }
            }
        },

        /**
         * Обработчик изменения интервала в модели
         * @param {Event} e
         * @param {Object} data
         */
        resetTime: function(e, data) {
            if (data.source == this) return;

            this.timeControl.setTime(timeMapReverse[data.field], data.value);
        },

        //region i-outboar-controls implementation

        prepareToShow: function() {
            this.timeControl && this.timeControl.setAllTime(this.getTimeFromModel());
            this.model.fix();
            this.trigger('show');
        },

        provideData: function() {
            var data = this.model.fix().toJSON();

            Object.keys(data).forEach(function(name) {
                if (typeof data[name] == 'boolean') data[name] = +data[name];
            });

            return data;
        },

        declineChange: function() {
            this.model.rollback();
        },

        //endregion i-outboar-controls implementation

        /**
         * Получение интервала из модели
         * @returns {Object} интервал
         */
        getTimeFromModel: function() {
            var res = {};

            Object.keys(timeMap).forEach(function(name) {
                res[name] = this.model.get(timeMap[name])
            }, this);

            return res;
        },

        /**
         * Делает доступным/недоступным чекбокс смс об окончании кампании
         * Так же если недоступен снимает чекбокс
         * @param {Boolean} toggle true если доступен
         */
        toggleFinishDateSms: function(toggle) {
            var finishSmsCheckbox = this.findBlockOn('camp-finished-sms', 'checkbox');

            finishSmsCheckbox.setMod('disabled', toggle ? '' : 'yes');

            if (!toggle)
                finishSmsCheckbox.delMod('checked');
        },

        /**
         * Показывает предупреждение «Новый номер будет отображён после сохранения параметров кампании.»
         * DIRECT-51348
         * @private
         */
        _showWarning: function() {
            return this.setMod(this.elem('warning'), 'show', 'yes');
        }

    }, {

        live: function() {
            this.liveBindTo('passport-phone', 'pointerclick', function() {
                this._showWarning()
                    .trigger('click-passport-phone');
            });
        }

    });
})();
