//settings_sorted

block('b-sort-link').def()(function() {
    var data = this.data,
        ctx = this.ctx,
        form = data.FORM,
        cols = ctx.col instanceof Array ? ctx.col.join(',') : ctx.col,
        urlParams = {
            sort: 'sort',
            reverse: 'reverse',
            page: 'page'
        },
        params = '',
        filterParams = '',
        key,
        default_reverse = 0,
        anchor = '',
        attrs = '',
        defaultCol = ctx.options && ctx.options['defaultCol'] || this.defaultCol,
        isReset = ctx.mods && ctx.mods.type === 'reset';

    isReset && (urlParams['settings_sorted'] = 'settings_sorted');

    if (ctx.options) {
        ctx.options['url_param'] && (urlParams.sort += ctx.options['url_param']) &&
            (urlParams.reverse += ctx.options['url_param']);

        ctx.options['dont_remove_page_from_url'] && delete urlParams.page;

        ctx.options['default_reverse'] && (default_reverse = 1);

        if (ctx.options['anchor']) {
            anchor = '#' + ctx.options['anchor'];
            ctx.options['anchorset'] && (attrs = {
                name: ctx.options['anchor']
            });
        }
    }

    for (key in urlParams) {
        if (urlParams.hasOwnProperty(key)) {
            filterParams += urlParams[key] + '|';
        }
    }

    filterParams = new RegExp('^(' + filterParams + 'ncrnd|UID|INCLUDE_PATH|uid_url)$', 'i');

    for (key in form) {
        if (form.hasOwnProperty(key) && !filterParams.exec(key)) {
            params += encodeURIComponent(key) + '=' + encodeURIComponent(form[key] || '') + '&';
        }
    }

    var sort = form[urlParams.sort] || (defaultCol instanceof Array ? defaultCol.join(',') : defaultCol),
        draw_reverse = form[urlParams.reverse] ? +form[urlParams.reverse] : default_reverse,
        new_reverse = cols != sort ? default_reverse : (draw_reverse ? 0 : 1);

    return {
        block: 'link',
        mix: [{
            block: ctx.block,
            mods: ctx.mods || ''
        }].concat(ctx.mix || []),
        attrs: attrs,
        url: data.script + '?' + params + urlParams.sort + '=' + cols + '&' + urlParams.reverse + '=' +
            new_reverse + anchor,
        content: isReset ?
            '' : [
                {
                    block: 'b-sort-link',
                    elem: 'caption',
                    content: ctx.content
                },
                cols == sort && {
                    block: 'b-sort-link',
                    elem: 'arrow',
                    content: draw_reverse ? '&darr;' : '&uarr;'
                }
            ]
    };
});
