/**
 * Блок превью баннера на странице статистики
 * @params {Object} modelParams параметры модели группы, соответствующей данному превью
 * @params {String} modelParams.name
 * @params {String} modelParams.id
 * @params {Object} banner
 */
block('b-stat-banner')(

    def()(function() {
        if ((this.ctx.mods || {}).type === 'custom') return applyNext();

        var data = this.data,
            group = this.ctx.banner,
            banner = this.ctx.banner,
            campaign = data.campaign,
            plotLinkLabel = iget2('b-stat-banner', 'pokazat-grafik', 'Показать график'),
            campaignTags = campaign.tags,
            bannerTags = [];

        campaignTags.forEach(function(tag) {
            banner.tags && banner.tags[tag.id] && bannerTags.push(tag);
        });

        group.banners = [this.extend({}, banner)];
        group.adgroup_type = campaign.mediaType;

        banner.cid = this.ctx.cid;

        banner.isVCardEmpty = !+banner.with_phone;

        // на страницах статистики тип объявление приходит через real_banner_type,
        // а должен в ad_type как на всех остальных страницах где есть превью баннера
        if (!banner.ad_type) {
            banner.ad_type = banner.real_banner_type;
        }

        group = u['i-banners-group-data'].patch({
            count: 0,
            bannersGroup: group,
            campaignTags: campaignTags
        }, data);

        group.cid = banner.cid = this.ctx.cid;

        return applyNext({
            'ctx.group': group,
            'ctx.plotLink': banner.plot_link,
            'ctx.plotLinkLabel': plotLinkLabel,
            'ctx.campaignTags': campaignTags,
            'ctx.bannerTags': bannerTags
        });
    }),

    addJs()(function() {
        return {
            bid: this.ctx.banner.bid,
            modelParams: this.ctx.modelParams,
            cid: this.ctx.cid,
            tags: this.ctx.bannerTags
        };
    }),

    content()(function() {
        var ctx = this.ctx,
            banner = ctx.banner,
            //на страницах статистики все данные по группам приходят в объекте баннера
            group = ctx.group,
            groupName = banner.group_name,
            bid = banner.bid,
            data = this.data,
            tagUrlQuery = u.getUrlParams(),
            currentTagId = tagUrlQuery.tag,
            campaign = data.campaign,
            groupModelName = u.campaign.getGroupModelName(banner.adgroup_type);

        return [
            {
                block: 'i-model',
                modelParams: {
                    name: groupModelName,
                    id: group.adgroup_id,
                    data: u[groupModelName].transformData({
                        group: group,
                        campaign: campaign,
                        campaignTags: ctx.campaignTags
                    })
                }
            },
            {
                block: 'b-stat-banner',
                elem: 'banner-preview',
                content: [
                    {
                        elem: 'anchor',
                        id: bid
                    },
                    {
                        elem: 'banner-bid',
                        content: '№ M-' + bid + (banner.banner_type === 'mobile' ? ' (' + iget2('b-stat-banner', 'mobilnoe', 'мобильное') + ')' : '') + (groupName ? '&nbsp;&nbsp;' + iget2('b-stat-banner', 'gruppa', '(Группа:') + '&nbsp;' + '&laquo;' + groupName + '&raquo;)' : '')
                    },
                    {
                        elem: 'preview',
                        group: group,
                        banner: banner
                    },
                    {
                        block: 'b-group-tags',
                        mix: [{
                            block: 'b-stat-banner',
                            elem: 'banner-tags'
                        }],
                        modelParams: this.ctx.modelParams,
                        group: group,
                        ulogin: data.uid_url.key == 'ulogin' ? data.uid_url.value : '',
                        switcher: !!data.allow_edit_camp && campaign.archived != 'Yes' && {
                            block: 'b-group-tag-button',
                            content: iget2('b-stat-banner', 'metki', 'Метки')
                        },
                        tagUrl: u.formatUrl({
                            host: data.SCRIPT,
                            query: banner.tagUrlQuery
                        }),
                        campaignTags: ctx.campaignTags,
                        currentTagId: currentTagId
                    }
                ]
            },
            ctx.chartsManager && {
                elem: 'banner-charts-manager',
                chartsManager: ctx.chartsManager,
                cid: campaign.cid,
                bid: bid,
                client_currency: campaign.currency,
                target_all: this.data.target_all || 0,
                target_1: this.data.target_1 || 0,
                target_0: this.data.target_0 || 0,
                isCpmStat: this.data.isCpmStat
            }
        ];
    }),

    elem('banner-charts-manager').content()(function() {
        var ctx = this.ctx,
            showTrafficVolumeStatFields = u['traffic-volume'].showTrafficVolumeStatFields(this.data.mediaType),
            currency = ctx.client_currency,
            columns = u._.compact([
                'shows',        // Показы
                showTrafficVolumeStatFields && 'eshows',       // Взвешенные показы
                'clicks',       // Клики
                'ctr',          // ctr %
                showTrafficVolumeStatFields && 'ectr',         // ectr %
                'agoalnum',     // Конверсии
                'sum',          // Расход всего
                ctx.isCpmStat && 'avg_cpm',      // Ср. цена тысячи показов
                'av_sum',       // Ср. цена клика
                'adepth',       // Глубина (стр.)
                'aconv',        // Конверсия %
                'agoalcost',    // Цена цели
                'agoalroi',     // Рентабельность
                'agoalincome'   // Доход
            ]),
            selectedColumns = ['shows', showTrafficVolumeStatFields && 'eshows', 'clicks', 'ctr', showTrafficVolumeStatFields && 'ectr', 'agoalnum'],
            filters = {
                campaign: { eq: [ctx.cid] },
                banner: { eq: ctx.bid }
            };

        // https://st.yandex-team.ru/DIRECT-63513#1487774089000
        if (ctx.target_0 && !ctx.target_all && !ctx.target_1) {
            filters.targettype = { eq: 'search' };
        } else if (ctx.target_1 && !ctx.target_all && !ctx.target_0) {
            filters.targettype = { eq: 'context' };
        }

        return {
            block: 'b-charts-manager',
            mods: { 'save-user-options': 'yes' },
            js: {
                clientCurrency: currency,
                reportData: u._.extend({}, ctx.chartsManager, {
                    statType: 'mol',
                    filters: filters
                })
            },
            content: [
                { elem: 'switcher' },
                {
                    elem: 'filters',
                    view: ctx.chartsManager.view || undefined,
                    filtersMods: { place: 'detail' },
                    columns: u['b-charts-manager'].applyGroup(columns.map(function(column, index) {
                        return {
                            value: column,
                            selected: selectedColumns.indexOf(column) !== -1 ? 'yes' : '',
                            text: u['text-store'].get({ currency: u.currencies.getName(currency) }, 'chart', column)
                        };
                    }))
                },
                {
                    elem: 'export',
                    types: [
                        { text: 'PNG', MIME: 'image/png' },
                        { text: 'JPEG', MIME: 'image/jpeg' },
                        { text: 'SVG', MIME: 'image/svg+xml' }
                    ],
                    print: true
                },
                { elem: 'chart' }
            ]
        };
    }),

    elem('preview').content()(

        match(function() {
            return this.data.campaign.mediaType === 'mobile_content';
        })(function() {
            var banner = this.ctx.banner,
                //на страницах статистики все данные по группам приходят в объекте баннера
                group = this.ctx.banner;

            return banner.ad_type === 'image_ad' ?
                {
                    block: 'b-banner-preview2',
                    mods: {
                        type: 'text',
                        view: 'base-image',
                        readonly: 'yes'
                    },
                    data: u['b-banner-preview2_type_image'].fromServer({
                        banner: banner,
                        group: group
                    })
                } :
                {
                    block: 'b-banner-preview2',
                    mods: {
                        type: 'mobile-content',
                        view: 'mobile-content-campaign',
                        readonly: 'yes'
                    },
                    data: u['b-banner-preview2_type_mobile-content']
                        .fromServer({
                            banner: banner,
                            group: group,
                            mobileContent: banner.mobile_content,
                            campaign: this.data.campaign
                        }),
                    staticData: {
                        // отменяем показ предупреждений DIRECT-47818
                        flagsSettings: {
                            age: {
                                dontShow: true
                            },
                            other: {
                                dontShow: true
                            }
                        }
                    }
                };
        }),

        match(function() {
            return this.data.campaign.mediaType === 'dynamic';
        })(function() {
            var ctx = this.ctx,
                banner = ctx.banner,
                group = ctx.group,
                campaign = this.data.campaign;

            return {
                block: 'b-banner-preview2',
                mods: {
                    type: 'dynamic',
                    view: 'campaign',
                    readonly: 'yes'
                },
                data: u['b-banner-preview2_type_dynamic']
                    .fromServer({
                        banner: banner,
                        group: group,
                        campaign: campaign
                    }),
                staticData: {
                    // отменяем показ предупреждений DIRECT-47818
                    flagsSettings: {
                        age: {
                            dontShow: true
                        },
                        other: {
                            dontShow: true
                        }
                    }
                }
            };
        }),

        match(function() {
            return this.data.campaign.mediaType === 'performance';
        })(function() {
            var ctx = this.ctx,
                banner = ctx.banner,
                group = ctx.group,
                campaign = this.data.campaign;

            return {
                block: 'b-banner-preview2',
                mods: {
                    type: 'performance',
                    view: 'performance-campaign',
                    readonly: 'yes'
                },
                data: u['b-banner-preview2_type_performance']
                    .fromServer({
                        banner: banner,
                        group: group,
                        campaign: campaign
                    })
            };
        }),

        match(function() {
            return this.data.campaign.mediaType === 'text';
        })(function() {
            var ctx = this.ctx,
                banner = ctx.banner,
                group = ctx.group,
                campaign = this.data.campaign,
                organizations = this.data.organizations,
                organization = organizations && banner.permalink && organizations[banner.permalink],
                bannerAdType = banner.ad_type,
                isBannerImageAd = bannerAdType === 'image_ad',
                isBannerCpcVideo = bannerAdType === 'cpc_video';

            return isBannerImageAd || isBannerCpcVideo ?
                {
                    block: 'b-banner-preview2',
                    mods: {
                        type: 'text',
                        view: isBannerImageAd ? 'base-image' : 'creative',
                        readonly: 'yes'
                    },
                    data: u['b-banner-preview2_type_image'].fromServer({
                        banner: banner,
                        group: group
                    })
                } :
                {
                    block: 'b-banner-preview2',
                    mods: {
                        type: 'text',
                        view: 'campaign',
                        readonly: 'yes'
                    },
                    data: u['b-banner-preview2_type_text']
                        .fromServer({
                            banner: banner,
                            group: group,
                            campaign: campaign,
                            organization: organization
                        }),
                    staticData: {
                        // отменяем показ предупреждений DIRECT-47818
                        flagsSettings: {
                            age: {
                                dontShow: true
                            },
                            other: {
                                dontShow: true
                            }
                        }
                    },
                    js: {
                        hasOrganization: !!organization,
                        preferVcardOverPermalink: banner.prefer_vcard_over_permalink
                    }
                };
        }),

        match(function() {
            return this.data.campaign.mediaType === 'cpm_banner';
        })(function() {
            var ctx = this.ctx,
                banner = ctx.banner,
                group = ctx.group;

            return {
                block: 'b-banner-preview2',
                mods: {
                    type: 'cpm-banner',
                    view: 'creative',
                    readonly: 'yes'
                },
                data: u['b-banner-preview2_type_image'].fromServer({
                    banner: banner,
                    group: group
                })
            };
        }),

        match(function() {
            return this.data.campaign.mediaType === 'cpm_yndx_frontpage';
        })(function() {
            var ctx = this.ctx,
                banner = ctx.banner,
                group = ctx.group;

            return {
                block: 'b-banner-preview2',
                mods: {
                    type: 'cpm-yndx-frontpage',
                    view: 'creative',
                    readonly: 'yes'
                },
                data: u['b-banner-preview2_type_image'].fromServer({
                    banner: banner,
                    group: group
                })
            };
        }),

        match(function() {
            return this.data.campaign.mediaType === 'cpm_deals';
        })(function() {
            var ctx = this.ctx,
                banner = ctx.banner,
                group = ctx.group;

            return {
                block: 'b-banner-preview2',
                mods: {
                    type: 'cpm-deals',
                    view: 'creative',
                    readonly: 'yes'
                },
                data: u['b-banner-preview2_type_image'].fromServer({
                    banner: banner,
                    group: group
                })
            };
        }),

        match(function() {
            return this.data.campaign.mediaType === 'content_promotion';
        })(function() {
            var ctx = this.ctx,
                banner = ctx.banner,
                group = ctx.group,
                isCollection = group.content_promotion_content_type === 'collection';

            return {
                block: 'b-banner-preview2',
                mods: {
                    type: 'content-promotion',
                    view: isCollection ? 'content-promotion-collection' : 'content-promotion-video',
                    readonly: 'yes'
                },
                data: u['b-banner-preview2_type_content-promotion'].fromServer({
                    banner: banner,
                    group: group
                })
            };
        })
    )

);
