BEM.DOM.decl('b-stat-data-available-from', {

    onSetMod: {

        js: function() {
            this.link = this.findBlockInside('link', 'link');

            this.link.on('click', this._toggleWarning, this);
        }

    },

    _toggleWarning: function() {
        var popupContent = [],
            suffixes = u['b-statistic-filters-editor'].suffixes,
            availableFrom = this.params.availableFrom,
            dateTo = u.moment(this.params.dateTo),
            dateFrom = u.moment(this.params.dateFrom),
            warningTexts = this.__self.warningTexts,
            tableColumns = u._.uniq(
                u._.union(Object.keys(this.params.availableFrom), this.params.tableColumns).map(function(key) {
                    var splitedKey = key.split('_');

                    if (suffixes.indexOf(u._.last(splitedKey)) != -1) {
                        splitedKey.pop();
                    }

                    return splitedKey.join('_');
                })
            );

        // Сперва строим предупреждения по выбранным в таблице столбцам
        tableColumns.forEach(function(key) {
            // Если название столбца есть в данных о недоступной статистике
            // формируем предупреждение
            if (key == 'search_query_partly_incomplete') {
                popupContent.push(iget2(
                    'b-stat-data-available-from',
                    'statistika-po-poiskovym-zaprosam',
                    'Статистика по поисковым запросам с площадок рекламной сети доступна при выборе периода, начинающегося с 13 июня 2017 года'
                ));
            } else if (u.consts('relevanceMatchCategoriesStatWarnsEnabled') && key === 'targeting_category') {
                if (dateFrom.diff('2021-09-03', 'day') < 0) {
                    popupContent.push(iget2(
                        'b-stat-data-available-from',
                        'statistika-po-targeting-category-before-3',
                        'Статистика по «Категории таргетинга» временно недоступна для автотаргетинга.<br/>По остальным условиям показа статистика доступна с 3 сентября 2021.<br/>Для оценки работы категорий запросов автотаргетинга можно воспользоваться срезом «Тип условия показа» в отчете по поисковым запросам.<br/>Скоро мы все исправим'
                    ));
                } else {
                    popupContent.push(iget2(
                        'b-stat-data-available-from',
                        'statistika-po-targeting-category-after-3',
                        'Статистика по «Категории таргетинга» временно недоступна для автотаргетинга.<br/>Для оценки работы категорий запросов автотаргетинга можно воспользоваться срезом «Тип условия показа» в отчете по поисковым запросам.<br/>Скоро мы все исправим.'
                    ));
                }
            } else if (availableFrom[key] && typeof availableFrom[key] == 'string') {
                popupContent.push(
                    iget2('b-stat-data-available-from', 'statistika-po-text-dostupna', 'Статистика по {text} доступна с {date} года', {
                        text: warningTexts[key],
                        date: u.moment(availableFrom[key]).format('D MMMM YYYY')
                    })
                );
            } else if (availableFrom[key]) {
                popupContent.push(iget2(
                    'b-stat-data-available-from',
                    'statistika-po-text-dostupna-111',
                    'Статистика по {text} доступна за последние {date} дней',
                    {
                        text: warningTexts[key],

                        // iget при получении числа начинает вести себя странно
                        date: '' + availableFrom[key]
                    }
                ));
            }
        });

        // После формируем предупреждения не относящиеся к конкретным столбцам
        // Они должны идти последними
        Object.keys(availableFrom).forEach(function(key) {
            if (!~tableColumns.indexOf(key)) {
                popupContent.push(warningTexts[key]);
            }
        });

        this._getPopup().setContent(popupContent.join('<br/>')).toggle(this.link);
    },

    /**
     * Возвращает экземпляр попапа
     * @returns {BEM}
     */
    _getPopup: function() {
        return this._popup || (this._popup = BEM.blocks['b-shared-popup'].getInstance({
            adaptive: 'yes'
        }, {}, { content: [{ block: 'b-stat-data-available-from', elem: 'warns' }] }));
    }

}, {

    warningTexts: {

        fp_clicks_avg_pos: iget2('b-stat-data-available-from', 'sr-pozicii-klika', 'Ср. позиции клика'),

        fp_shows_avg_pos: iget2('b-stat-data-available-from', 'sr-pozicii-pokaza', 'Ср. позиции показа'),

        avg_x: iget2('b-stat-data-available-from', 'avg_x', 'Ср. объёму трафика'),

        device_type: iget2('b-stat-data-available-from', 'tipu-ustroystva', 'Типу устройства'),

        gender: iget2('b-stat-data-available-from', 'polu', 'Полу'),

        age: iget2('b-stat-data-available-from', 'vozrastu', 'Возрасту'),

        bounce_ratio: u.placePostClick(iget2('b-stat-data-available-from', 'otkazam', 'Отказам')),

        pv_bounce_ratio: u.placePostView(iget2('b-stat-data-available-from', 'otkazam', 'Отказам')),

        connection_type: iget2('b-stat-data-available-from', 'tipu-svyazi', 'Типу связи'),

        detailed_device_type: iget2('b-stat-data-available-from', 'tipu-operacionnoy-sistemy', 'Типу операционной системы'),

        search_query: iget2('b-stat-data-available-from', 'poiskovym-zaprosam', 'Поисковым запросам'),

        search_queries_contextcond_ext: iget2('b-stat-data-available-from', 'usloviyam-pokaza', 'Условиям показа'),

        ext_phrases_contextcond_ext: iget2('b-stat-data-available-from', 'dopolnitelnym-frazam', 'Дополнительным фразам'),

        retargeting_coef: iget2('b-stat-data-available-from', 'korrektirovkam-dlya-usloviy-podbora', 'корректировкам для условий подбора аудиторий'),

        bm_type: iget2('b-stat-data-available-from', 'srezu-tip-dopolnitelnoy-frazy', 'срезу Тип дополнительной фразы'),

        available_date: iget2('b-stat-data-available-from', 'dannye-v-otchete-dostupny', 'Данные в отчете доступны с 20 февраля 2014 года'),

        aprgoodmultigoal: u.placePostClick(iget2('b-stat-data-available-from', 'urovnu-vovlechennosti', 'Уровню вовлеченности')),

        pv_aprgoodmultigoal: u.placePostView(iget2('b-stat-data-available-from', 'urovnu-vovlechennosti', 'Уровню вовлеченности')),

        aprgoodmultigoal_cpa: u.placePostClick(iget2('b-stat-data-available-from', 'tsene-vovlechenia', 'Цене вовлечения')),

        pv_aprgoodmultigoal_cpa: u.placePostView(iget2('b-stat-data-available-from', 'tsene-vovlechenia', 'Цене вовлечения')),

        aprgoodmultigoal_conv_rate: u.placePostClick(iget2('b-stat-data-available-from', 'koefficientu-vovlechennosti', 'Коэффициенту вовлеченности')),

        pv_aprgoodmultigoal_conv_rate: u.placePostView(iget2('b-stat-data-available-from', 'koefficientu-vovlechennosti', 'Коэффициенту вовлеченности')),

        avg_bid: iget2('b-stat-data-available-from', 'sredney-stavke-za-click', 'Ср. ставке за клик'),

        inventory_type: iget2('b-stat-data-available-from', 'inventory-type', 'Типу инвентаря'),

        turbo_page_type: iget2('b-stat-data-available-from', 'turbo-page-type-2', 'Турбо-версии площадки'),

        targeting_category: iget2('b-stat-data-available-from', 'semantic-correspondence-type', 'Категории таргетинга'),
        prisma_income_grade: iget2('b-stat-data-available-from', 'prisma-income-grade', 'Уровень платежеспособности'),

        viewable_impressions_mrc: iget2('b-stat-data-available-from', 'viewable-impressions-mrc', 'Видимые показы, стандарт MRC'),
        nonviewable_impressions_mrc: iget2('b-stat-data-available-from', 'nonviewable-impressions-mrc', 'Невидимые показы, стандарт MRC'),
        undetermined_impressions_mrc: iget2('b-stat-data-available-from', 'undetermined-impressions-mrc', 'Неустановленные показы, стандарт MRC'),
        measured_rate_mrc: iget2('b-stat-data-available-from', 'measured-rate-mrc', 'Доля измеряемых показов, стандарт MRC (%)'),
        viewable_rate_mrc: iget2('b-stat-data-available-from', 'viewable-rate-mrc', 'Доля видимых показов, стандарт MRC (%)')
    }

});
