block('b-stat-phrase-minus-words')(

    addJs()(function() {
        // DIRECT-59806: привести в порядок b-stat-phrase-minus-words
        var ctx = this.ctx,
            minusWords = ctx.phrase && !ctx.isRelevanceMatch ?
            u.phraseFormatter.getMinusWords(ctx.phrase) :
            ctx.minusWords;

        return {
            minusWords: (u.minusWords.stringToArray(minusWords) || []).map(function(minusWord) {
                return '-' + minusWord;
            })
        };
    }),

    content()(function() {
        var ctx = this.ctx,
            phrase = ctx.phrase || '',
            limit = ctx.limit,
            isRelevanceMatch = ctx.isRelevanceMatch,
            isRetargeting = ctx.isRetargeting,
            minusWords = isRelevanceMatch ? '' : u.minusWords.arrayToString(u.phraseFormatter.getMinusWords(phrase)),
            keyWords = isRelevanceMatch ? phrase : u.phraseFormatter.getKeyWords(phrase) || phrase,
            campWordsText = ctx.campaignMinusWords ? iget2('b-stat-phrase-minus-words', 'v-statistike-ne-otobrazhayutsya', 'В статистике не отображаются единые минус-фразы') : '',
            minusWordsParts = [],
            truncatedMinusWords = isRelevanceMatch ? phrase : (minusWords.length > limit ? keyWords : phrase)
                .replace(/\s+(-.*)$/, function(str, minusWords) {
                    minusWordsParts.push({
                        elem: 'minus-words',
                        elemMods: {
                            inline: 'yes'
                        },
                        minusWords: minusWords.trim().split(/\s+/)
                    });

                    return '';
                }),
            result = [],
            phraseElem = {
                elem: 'phrase',
                elemMods: { 'relevance-match': isRelevanceMatch ? 'yes' : '' },
                content: [truncatedMinusWords].concat(minusWordsParts)
            };

        if (campWordsText) {
            phraseElem.attrs = {
                title: campWordsText
            };
        }

        result.push(phraseElem);

        // ретаргетинг и интересы здесь не различаются - приходят в 1 списке
        // с ContextType == 2 и флагом is_retargeting == 1.
        // До https://st.yandex-team.ru/DIRECT-67121 у интересов приходила подпись
        // (Интерес), а у ретаргетинга (Условия подбора аудитории),
        // но в задаче убрали подпись у ретаргетинга.
        // См. https://st.yandex-team.ru/DIRECT-67121#1497878254000
        // В https://st.yandex-team.ru/DIRECT-67121#1497881762000 добавили флаг is_interest
        if (isRetargeting && !ctx.isInterest) {
            result.push({
                elem: 'phrase-type-description',
                content: ' (' + iget2('b-stat-phrase-minus-words', 'uslovie-podbora-auditorii', 'Условие подбора аудитории') + ')'
            });
        }

        if (minusWords.length > limit) {
            result.push({
                elem: 'switcher',
                elemMods: {
                    dots: 'yes'
                }
            });
        } else if (ctx.showHelp) {
            result.push({
                elem: 'help'
            });
        }

        return result;
    }),

    mod('only-minus-words', 'yes').content()(function() {
        var link = {
            block: 'link',
            js: true,
            mix: {
                block: 'b-stat-phrase-minus-words',
                elem: 'switcher'
            },
            mods: {
                pseudo: 'yes',
                'user-select': 'off'
            },
            content: iget2('b-stat-phrase-minus-words', 'posmotret', 'посмотреть')
        };

        if (!this.ctx.notice) return link;

        return {
            block: 'icon-text',
            mods: { theme: 'alert', size: 'ms' },
            mix: [{
                block: 'b-stat-phrase-minus-words',
                elem: 'minus-words-notice'
            }],
            text: [this.ctx.notice, '&nbsp;', link]
        };
    }),

    elem('switcher').content()(function() {
        return this.ctx.content || {
            block: 'b-icon',
            js: true,
            mods: {
                'size-16': 'threedots'
            }
        };
    }),

    elem('help').def()(function() {
        return {
            block: 'b-help-link',
            mods: {
                type: 'modal'
            },
            stretched: true,
            icon: 'question',
            url: u.getHelpUrl('related-keywords')
        };
    })
);
