block('b-stat-phrases-manager')(

    elem('phrase-item')(

        mix()(function() {
            return {
                block: 'i-glue',
                js: {
                    modelName: 'm-stat-phrase-bidable',
                    modelId: this.ctx.itemData.id
                }
            }
        }),

        content()(function() {
            var itemData = this.ctx.itemData,
                campInfo = itemData.campaign;

            return [
                {
                    block: 'input',
                    mods: { clear: 'no' },
                    mix: [
                        {
                            block: 'i-glue',
                            elem: 'model-field',
                            js: {
                                type: 'input',
                                name: 'phrase'
                            }
                        },
                        {
                            block: 'b-stat-phrases-manager',
                            elem: 'phrase',
                            js: {
                                modelId: itemData.id,
                                cid: itemData.cid
                            }
                        }
                    ],
                    value: itemData.phrase,
                    content: {
                        elem: 'control',
                        attrs: { autocomplete: 'off' }
                    }
                },
                {
                    block: 'b-stat-phrases-manager',
                    elem: 'price-wrap',
                    itemData: itemData
                },
                {
                    block: 'b-stat-phrases-manager',
                    elem: 'group-info',
                    group: itemData.groupInfo,
                    bidForSearchLink: itemData.bidForSearchLink
                },
                itemData.statType === 'mol' && {
                    block: 'b-stat-phrases-manager',
                    elem: 'camp-info',
                    content: [
                        {
                            block: 'link',
                            target: 'blank',
                            url: u.getUrl('showCamp', {
                                ulogin: u.consts('ulogin'),
                                cid: campInfo.cid
                            }),
                            content: u.hellipCut(campInfo.campName, 20),
                            title: campInfo.campName
                        },
                        {
                            block: 'b-stat-phrases-manager',
                            elem: 'camp-number',
                            content: campInfo.cid
                        }
                    ]
                },
                {
                    block: 'b-stat-phrases-manager',
                    elem: 'remove-phrase-wrap',
                    content: {
                        block: 'b-control-remove-button',
                        mods: { icon: 'basket' },
                        mix: [
                            { block: 'b-stat-phrases-manager', elem: 'control' },
                            { block: 'b-stat-phrases-manager', elem: 'remove-phrase' }
                        ],
                        data: {
                            phraseId: itemData.id,
                            cid: itemData.cid
                        }
                    }
                }
            ]
        })

    )

);
