block('b-stat-phrases-manager')(

    elem('price-wrap')(

        content()(function() {
            var itemData = this.ctx.itemData,
                hasPrice = typeof itemData.price === 'number' || typeof itemData.price === 'string',
                hasPriceContext = typeof itemData.price_context === 'number' ||
                    typeof itemData.price_context === 'string',
                type;

            if (hasPrice && hasPriceContext) {
                type = 'both';
            } else if (hasPrice) {
                type = 'search';
            } else if (hasPriceContext) {
                type = 'context';
            }

            if (!type) { return ''; }

            return [
                type == 'both' ?
                    {
                        block: 'b-edit-phrase-price-stat-popup',
                        mods: { justify: 'yes' },
                        mix: {
                            block: 'b-stat-phrases-manager',
                            elem: 'price'
                        },
                        js: {
                            currency: itemData.currency,
                            campaign: itemData.campaign,
                            autofocus: true
                        },
                        price: itemData.price,
                        price_context: itemData.price_context
                    } :
                    {
                        block: 'b-edit-phrase-price',
                        mods: {
                            type: 'mol',
                            'control-type': type,
                            'real-time': 'yes',
                            justify: 'yes'
                        },
                        mix: {
                            block: 'b-stat-phrases-manager',
                            elem: 'price'
                        },
                        campDMParams: {
                            name: u.campaign.getCampaignModelName(itemData.campaign.type),
                            id: itemData.campaign.cid
                        },
                        currency: itemData.currency,
                        price: type === 'search' ? itemData.price : itemData.price_context
                    },
                {
                    block: 'b-phrases-auction-popup',
                    mix: {
                        block: 'b-stat-phrases-manager',
                        elem: 'auction'
                    },
                    js: {
                        modelParams: itemData.modelParams,
                        currency: itemData.currency,
                        campaign: itemData.campaign
                    }
                }
            ];

        })
    )

);
