u.register({

    'b-stat-phrases-manager': {

        /**
         * Возвращает общее количество фраз которые не помещаются в группы
         * @param {Object} groups
         * @returns {Number}
         * @private
         */
        getOversizeCount: function(groups) {
            return u._.keys(groups).reduce(function(count, adgroupId) {
                return count + groups[adgroupId].phrases_exceeds_limit_qty;
            }, 0)
        },

        /**
         * Возвращает количество добавленных фраз в группах
         * @param {Object} groups
         * @returns {Number}
         * @private
         */
        getAddedPhraseCount: function(groups) {
            return u._.keys(groups).reduce(function(phrasesCount, adgroupId) {
                return phrasesCount += groups[adgroupId].phrases_added_qty || 0;
            }, 0);
        }

    }

});
