block('b-stat-strategy-changes-info')(
    match(function() {
        return !u.consts('isEditAvgCpmPeriodStrategyWithoutRestartEnabled') ||
            !this.data.campaign.strategy2.lastStrategyChange;
    }).replace()(''),

    content()(function() {
        var campaign = this.data.campaign,
            mediaType = campaign.mediaType;

        return [
            {
                elem: 'date',
                content: iget2('b-stat-strategy-changes-info', 'changes-info-text', 'Стратегия изменена {changeDate}:', {
                    changeDate: campaign.strategy2.lastStrategyChange
                })
            },
            {
                elem: 'value',
                content: u.strategy.getHint({
                    strategyData: campaign.strategy2,
                    currency: campaign.currency,
                    onlyNet: u.campaign.isCpm(mediaType),
                    onlySearch: u._.contains(['mcbanner', 'content_promotion'], mediaType),
                    isChangeManualStrategyName: Boolean(+this.data.has_change_name_bid_optimization),
                    contextLimit: campaign.ContextLimit,
                    enable_cpc_hold: campaign.enable_cpc_hold,
                    attributionModel: campaign.attribution_model,
                    needAttributionModel: u['attribution-model'].isNewPolicyEnabled(mediaType),
                    mediaType: mediaType
                }).map(function(hintPart) {
                    return {
                        block: 'b-stat-strategy-changes-info',
                        elem: 'value-item',
                        content: hintPart
                    };
                })
            },
            {
                block: 'link',
                target: '_blank',
                mods: {
                    theme: 'normal'
                },
                mix: {
                    block: 'b-stat-strategy-changes-info',
                    elem: 'link'
                },
                content: iget2('b-stat-strategy-changes-info', 'strategy-change-link', 'История изменений'),
                url: u.formatUrl({
                    path: '/dna/log/',
                    query: {
                        ulogin: u.consts('ulogin'),
                        cid: campaign.id,
                        'date-from': u.moment(campaign.strategy2.lastStrategyChange, 'DD.MM.YYYY').format('YYYY-MM-DD'),
                        'date-to': u.moment(campaign.strategy2.lastStrategyChange, 'DD.MM.YYYY').format('YYYY-MM-DD')
                    }
                })
            }
        ];
    })
);
