BEM.DOM.decl({
    block: 'b-stat-table-phrases-popup',
    modName: 'type',
    modVal: 'minus',
    implements: 'i-modal-popup-inner-block-interface'
}, {

    /**
     * Возвращает инстанс блока управляющего фразами
     * @returns {BEM}
     * @private
     */
    _getPhrasesManager: function() {
        return this._phrasesManager || (this._phrasesManager = this.findBlockInside('b-minus-phrases-manager'));
    },

    _save: function(requestParams) {
        return this._getPhrasesManager().save(requestParams).then(
            function(data) {
                this.trigger('phrases-excluded', data);
            }.bind(this),
            function(error) {
                if (error !== 'validationErrors' && error !== 'canceledByUser') {
                    this._showRequestError();
                }
            }.bind(this)
        );
    }

});
