BEM.DOM.decl({
    block: 'b-stat-table-phrases-popup',
    modName: 'type',
    modVal: 'plus',
    implements: 'i-modal-popup-inner-block-interface'
}, {

    onSetMod: {

        progress: {

            '': function() {
                this.__base.apply(this, arguments);

                this._checkSaveButton();
            }

        }

    },

    /**
     * Подписка на события
     * @returns {BEM}
     * @private
     */
    _initEvents: function() {
        this.__base.apply(this, arguments);

        this._subscriptionManager.wrap(this._getPhrasesManager())
            .on('prepare-stat-phrases-error', function() { this.trigger('prepare-stat-phrases-error'); }, this);

        return this;
    },

    /**
     * Выставляет/удаляет состояние disabled yes кнопке «Сохранить»
     * @private
     */
    _checkSaveButton: function() {
        this._getSaveButton().toggleMod('disabled', 'yes', this._getPhrasesManager().hasUnfinishedActions());
    },

    /**
     * Возвращает инстанс блока управляющего фразами
     * @returns {BEM}
     * @private
     */
    _getPhrasesManager: function() {
        return this._phrasesManager || (this._phrasesManager = this.findBlockInside('b-stat-phrases-manager'));
    },

    _save: function(requestParams) {
        return this._getPhrasesManager().save(requestParams)
            .then(function(sortGroups) {
                var hasBad = !u._.isEmpty(sortGroups.bad),
                    hasOversize = !u._.isEmpty(sortGroups.oversize),
                    hasGroupsLimit = !u._.isEmpty(sortGroups.groupsLimit);

                if (hasBad || hasOversize || hasGroupsLimit) {
                    if (hasBad) {
                        this._showBadPhrasesAlert(sortGroups);
                    } else if (hasOversize) {
                        this._onOversizeError(sortGroups);
                    } else if (hasGroupsLimit) {
                        this._onGroupsLimitError(sortGroups);
                    }
                } else {
                    this._showAddedPhrasesAlert(sortGroups);
                    this._onSaved();
                }
            }.bind(this))
            .fail(function(eventName) {
                if (eventName !== 'abort' && eventName !== 'validateErrors') {
                    this._showRequestError();
                }
            }.bind(this));
    },

    /**
     * Триггерит событие с добавленными фразами
     * @private
     */
    _onSaved: function() {
        this.trigger('phrases-added', {
            added: this._getPhrasesManager().findSourcePhrases()
        });
    },

    /**
     * Если фразы не помещаются в группу, даем возможность создать копию группы
     * @param {Object} sortGroups
     * @private
     */
    _onOversizeError: function(sortGroups) {
        this._showOversizeConfirm(sortGroups);
    },

    /**
     * Возвращает текст с количеством фраз не помещающихся в группы
     * @param {Number} totalCount
     * @param {Number} oversizeCount
     * @param {Array} [oversizeGroupIds]
     * @returns {String}
     * @private
     */
    _getHowManyText: function(totalCount, oversizeCount, oversizeGroupIds) {
        return iget2(
            'b-stat-table-phrases-popup',
            'iz-za-prevysheniya-limita',
            'Из-за превышения лимита по количеству фраз в {group} {phraseCount} из {totalCount}.',
            {
                group: u.pluralizeWord([
                    iget2('b-stat-table-phrases-popup', 'gruppu-s', 'группу {foo}', {
                        foo: oversizeGroupIds.join(', ')
                    }),
                    iget2('b-stat-table-phrases-popup', 'gruppy-s', 'группы {foo}', {
                        foo: oversizeGroupIds.join(', ')
                    }),
                    iget2('b-stat-table-phrases-popup', 'gruppy-s', 'группы {foo}', {
                        foo: oversizeGroupIds.join(', ')
                    })
                ], oversizeGroupIds.length),

                phraseCount: u.pluralizeWord([
                    iget2('b-stat-table-phrases-popup', 'ne-budet-dobavlena-s', 'не будет добавлена {foo}', {
                        foo: oversizeCount
                    }),
                    iget2('b-stat-table-phrases-popup', 'ne-budet-dobavleno-s', 'не будет добавлено {foo}', {
                        foo: oversizeCount
                    }),
                    iget2('b-stat-table-phrases-popup', 'ne-budet-dobavleno-s', 'не будет добавлено {foo}', {
                        foo: oversizeCount
                    })
                ], oversizeCount),

                totalCount: u.pluralizeWord([
                    iget2('b-stat-table-phrases-popup', 's-frazy', '{foo} фразы', {
                        foo: totalCount
                    }),
                    iget2('b-stat-table-phrases-popup', 's-fraz', '{foo} фраз', {
                        foo: totalCount
                    }),
                    iget2('b-stat-table-phrases-popup', 's-fraz', '{foo} фраз', {
                        foo: totalCount
                    })
                ], totalCount),

                context: 'group - группу; phraseCount - не будет добавлена Y фраз; totalCount - X фраз'
            }
        );

        // return iget('%{phraseCount#фраз} из %{phraseTotal#не помещаются} в %{group#родительские группы}.', {
        //     phraseCount: u.pluralize([
        //         iget('фраза'),
        //         iget('фразы'),
        //         iget('фраз')
        //     ], oversizeCount),
        //     phraseTotal: u.pluralizeWord([
        //         iget('%s не помещается', totalCount),
        //         iget('%s не помещаются', totalCount),
        //         iget('%s не помещаются', totalCount)
        //     ], oversizeCount),
        //     group: u.pluralizeWord([
        //         iget('родительскую группу'),
        //         iget('родительские группы'),
        //         iget('родительские группы')
        //     ], oversizeGroupsCount)
        // });
    },

    /**
     * Показывает конфирм для создания копии группы
     * @private
     */
    _showOversizeConfirm: function(sortGroups) {
        var oversizeCount = u['b-stat-phrases-manager'].getOversizeCount(sortGroups.oversize),
            totalCount = this._getPhrasesManager().getCurrentPhrasesCount(),
            oversizeGroupIds = Object.keys(sortGroups.oversize),
            text;

        text = [
            this._getAddedPhrasesText(sortGroups.good, 'oversize'),
            this._getHowManyText(totalCount, oversizeCount, oversizeGroupIds),
            iget2(
                'b-stat-table-phrases-popup',
                'chtoby-dobavit-phrase-frazy',
                'Чтобы добавить {phrase}, необходимо скопировать {group}.',
                {
                    group: u.pluralizeWord([
                        iget2('b-stat-table-phrases-popup', 'gruppu', 'группу'),
                        iget2('b-stat-table-phrases-popup', 'gruppy', 'группы'),
                        iget2('b-stat-table-phrases-popup', 'gruppy', 'группы')
                    ], oversizeGroupIds.length),

                    phrase: u.pluralizeWord([
                        iget2('b-stat-table-phrases-popup', 'frazu', 'фразу'),
                        iget2('b-stat-table-phrases-popup', 'vse-frazy', 'все фразы'),
                        iget2('b-stat-table-phrases-popup', 'vse-frazy', 'все фразы')
                    ], oversizeCount),

                    context: 'phrase - фразы; group - группы'
                }
            )
        ];

        this._hasOversizeConfirm = true;

        BEM.blocks['b-confirm'].open({
            message: BEMHTML.apply({
                block: 'b-stat-table-phrases-popup',
                elem: 'confirm-text',
                content: text.join('</br>')
            }),
            textYes: iget2('b-stat-table-phrases-popup', 'dobavit-vse-frazy-s', 'Добавить все фразы с копированием'),
            textNo: iget2('b-stat-table-phrases-popup', 'vernutsya', 'Вернуться'),
            fromPopup: this.findBlockOutside('popup'),
            onYes: function() {
                this._hasOversizeConfirm = false;
                this._save({ copy_group_if_oversized: 1 });
            },
            onNo: function() {
                this._hasOversizeConfirm = false;
            }
        }, this);

        return this;
    },

    /**
     * Возвращает текст ошибок во фразах которых нет на странице, но есть в группе(можно увидеть на странице кампании)
     * @returns {String}
     * @private
     */
    _getBadPhrasesText: function(badGroups) {
        return u._.keys(badGroups).reduce(function(errors, groupId) {
            badGroups[groupId].errors_by_phrases.forEach(function(error) {
                // currentPagePhrase - проставляется в методе _showServerErrors(b-stat-phrases-manager.js)
                if (!error.currentPagePhrase) {
                    errors.push([iget2('b-stat-table-phrases-popup', 'oshibka-v-klyuchevoy-fraze', 'Ошибка в ключевой фразе «{foo}».', {
                        foo: error.phrase
                    })].concat(error.errors).join(' '));
                }
            });

            return errors;
        }, []);
    },

    /**
     * Возвращает текст ошибок в группе
     * @returns {String}
     * @private
     */
    _getBadGroupsText: function(badGroups) {
        return u._.keys(badGroups).reduce(function(errors, groupId) {
            if (!u._.isEmpty(badGroups[groupId].errors)) {
                errors.push(badGroups[groupId].errors.join(' '));
            }

            return errors;
        }, []);
    },

    /**
     * Показывает ошибки некорректных фраз в группе
     * https://st.yandex-team.ru/DIRECT-61042#1489676138000
     * @returns {BEM}
     * @private
     */
    _showBadPhrasesAlert: function(sortGroups) {
        var badPhrasesText = this._getBadPhrasesText(sortGroups.bad),
            badGroupsText = this._getBadGroupsText(sortGroups.bad),
            message = [];

        if (!u._.isEmpty(sortGroups.good)) {
            message.push(this._getAddedPhrasesText(sortGroups.good, 'bad'));
        }

        if (badPhrasesText.length) {
            message = message.concat(badPhrasesText);
        }

        if (badGroupsText.length) {
            message = message.concat(badGroupsText);
        }

        if (message.length) {
            this._showAlert(message.join('</br>'));
        }

        return this;
    },

    /**
     * Показывает алерт с количеством добавленных фраз
     * @private
     * @returns {BEM}
     */
    _showAddedPhrasesAlert: function(sortGroups) {
        return this._showAlert(this._getAddedPhrasesText(sortGroups.good));
    },

    /**
     * Текст успешного добавления фраз
     * @returns {String}
     * @private
     */
    _getAddedPhrasesText: function(goodGroups, source) {
        var addedPhraseCount = u['b-stat-phrases-manager'].getAddedPhraseCount(goodGroups),
            addedPhraseText = iget2('b-stat-table-phrases-popup', 'dobavleno-unikalnyh-klyuchevyh-fraz', 'Добавлено уникальных ключевых фраз: {foo}.', {
                foo: addedPhraseCount
            });

        if (source === 'oversize') {
            return addedPhraseText;
        }

        var campaigns = this._getPhrasesManager().sortGroupsByCampaigns(goodGroups),
            hasCopied = u._.keys(campaigns).some(function(cid) {
                return !!campaigns[cid].copiedFrom;
            }),
            hasDuplicates = u._.keys(goodGroups).some(function(groupId) {
                return !u._.isEmpty(goodGroups[groupId].phrases_not_added_camp_duplicates);
            }),
            isAllDuplicates = u._.keys(goodGroups).every(function(groupId) {
                var group = goodGroups[groupId];

                return !u._.isEmpty(group.phrases_not_added_camp_duplicates) && u._.isEmpty(group.phrases);
            }),
            text = [addedPhraseText];

        if (isAllDuplicates) {
            return iget2('b-stat-table-phrases-popup', 'frazy-ne-byli-dobavleny', 'Фразы не были добавлены. Дубликаты фраз были пропущены.');
        }

        if (hasCopied) {
            text.push(iget2('b-stat-table-phrases-popup', 'novye-gruppy-otpravleny-na', 'Новые группы отправлены на модерацию.'));
        }

        if (hasDuplicates) {
            text.push(iget2('b-stat-table-phrases-popup', 'dublikaty-fraz-byli-propushcheny', 'Дубликаты фраз были пропущены.'));
        }

        if (source === 'bad') {
            text.push(iget2(
                'b-stat-table-phrases-popup',
                'ispravte-oshibki-chtoby-dobavit',
                'Исправьте ошибки, чтобы добавить остальные выбранные фразы.'
            ));
        }

        return text.join(' ');
    },

    /**
     * Если создать новую группу нет возможности
     * @param {Object} sortGroups
     * @private
     */
    _onGroupsLimitError: function(sortGroups) {
        this._showGroupsLimitConfirm(sortGroups);
    },

    /**
     * Показывает алерт, что невозможно добавить новые группы в кампанию
     * @param {Object} sortGroups
     * @returns {BEM}
     * @private
     */
    _showGroupsLimitConfirm: function(sortGroups) {
        var addedPhraseCount = u['b-stat-phrases-manager'].getAddedPhraseCount(sortGroups.good),
            oversizeCount = u['b-stat-phrases-manager'].getOversizeCount(sortGroups.groupsLimit),
            totalCount = this._getPhrasesManager().getCurrentPhrasesCount(),
            oversizeGroupIds = Object.keys(sortGroups.groupsLimit),
            campaigns = u._.keys(this._getPhrasesManager().sortGroupsByCampaigns(sortGroups.groupsLimit)),
            campaignsCount = campaigns.length,
            text = [];

        if (addedPhraseCount) {
            text.push(this._getAddedPhrasesText(sortGroups.good), '</br>');
        }

        text.push(
            this._getHowManyText(totalCount, oversizeCount, oversizeGroupIds),
            iget2(
                'b-stat-table-phrases-popup',
                'k-sozhaleniyu-sozdanie-novyh',
                'К сожалению, создание новых групп в {campaignsCount} невозможно. Вы можете сократить количество существующих групп или фраз, чтобы добавить новые записи.',
                {
                    campaignsCount: u.pluralizeWord([
                        iget2('b-stat-table-phrases-popup', 'kampanii-s', 'кампании {foo}', {
                            foo: campaigns.join(', ')
                        }),
                        iget2('b-stat-table-phrases-popup', 'kampaniyah-s', 'кампаниях {foo}', {
                            foo: campaigns.join(', ')
                        }),
                        iget2('b-stat-table-phrases-popup', 'kampaniyah-s', 'кампаниях {foo}', {
                            foo: campaigns.join(', ')
                        })
                    ], campaignsCount),

                    context: 'campaignsCount - кампаниях'
                }
            ));

        this._hasOversizeConfirm = true;

        BEM.blocks['b-confirm'].open({
            message: BEMHTML.apply({
                block: 'b-stat-table-phrases-popup',
                elem: 'confirm-text',
                content: text.join(' ')
            }),
            type: 'alert',
            fromPopup: this.findBlockOutside('popup'),
            onYes: function() {
                this._hasOversizeConfirm = false;
            }
        }, this);

        return this;
    },

    isChanged: function() {
        var deferred = $.Deferred();

        if (this._hasOversizeConfirm || this._getPhrasesManager().isChanged()) {
            this._hasOversizeConfirm = false;
            this._openCloseFormConfirm(deferred);
        } else {
            deferred.resolve(false);
        }

        return deferred.promise();
    },

    /**
     * Показывает конфирм, что изменения будут утеряны
     * @param {$.deferred} deferred
     * @private
     */
    _openCloseFormConfirm: function(deferred) {
        BEM.blocks['b-confirm'].open({
            message: iget2(
                'b-stat-table-phrases-popup',
                'v-forme-est-nesohranennye',
                'В форме есть несохраненные изменения. Если закрыть форму, они будут утеряны.'
            ),
            textYes: iget2('b-stat-table-phrases-popup', 'ok', 'ОК'),
            textNo: iget2('b-stat-table-phrases-popup', 'otmenit', 'Отменить'),
            fromPopup: this.findBlockOutside('popup'),
            onYes: function() {
                if (this._getPhrasesManager().findSourcePhrases().length) {
                    this._onSaved();
                }

                deferred.resolve(false);
            },
            onNo: function() {
                deferred.resolve(true);
            }
        }, this);
    }

}, {

    live: function() {
        this.liveInitOnBlockInsideEvent('unfinished-actions progress-end', 'b-stat-phrases-manager', function() {
            this._checkSaveButton();
        });

        return this.__base.apply(this, arguments);
    }

});
