BEM.DOM.decl({ block: 'b-stat-table-phrases-popup', implements: 'i-modal-popup-inner-block-interface' }, {

    onSetMod: {

        js: function() {
            this.setMod('progress', 'yes');
            this._initEvents();
        },

        progress: {

            yes: function() {
                this._getSpinner().setMod('progress', 'yes');

                this._getSaveButton().setMod('disabled', 'yes');
            },

            '': function() {
                this.trigger('repaint');

                this._getSaveButton().delMod('disabled');

                this._getSpinner().delMod('progress');
            }

        }

    },

    /**
     * Возвращает инстанс блока управляющего фразами
     * Переопределена в модификаторах
     * @returns {BEM}
     * @private
     */
    _getPhrasesManager: function() {},

    /**
     * Подписка на события
     * @returns {BEM}
     * @private
     */
    _initEvents: function() {
        this._subscriptionManager = BEM.create('i-subscription-manager');

        this._subscriptionManager.wrap(this._getPhrasesManager())
            .on('progress-start', function() { this.setMod('progress', 'yes') }, this)
            .on('progress-end', function() { this.delMod('progress') }, this);

        return this;
    },

    /**
     * Строит и кэширует блок spinner
     * @returns {BEM}
     */
    _getSpinner: function() {
        if (this._spinner) {
            return this._spinner;
        }

        return this._spinner = this.findBlockInside(
            BEM.DOM.append(
                this.elem('body'),
                BEMHTML.apply({
                    block: 'spin2',
                    mods: { size: 'l' },
                    mix: {
                        block: 'b-stat-table-phrases-popup',
                        elem: 'spin'
                    }
                })
            ),
            'spin2'
        );
    },

    /**
     * Возвращает инстанс кнопки «Сохранить»
     * @returns {BEM}
     * @private
     */
    _getSaveButton: function() {
        return this._saveButton || (this._saveButton = this.findBlockInside(this.elem('save'), 'button'));
    },

    /**
     * Обработчик клика по любой кнопке внутри блока
     * @param {jQuery.Event} e
     * @param {Object} data
     * @private
     */
    _onButtonClick: function(e, data) {
        this.elem('save').is(e.block.domElem) && this._save();
        this.elem('cancel').is(e.block.domElem) && this._onCancelClick(e, data);
    },

    /**
     * Отправляет фразы на сервер
     * @param {Object} requestParams
     * @private
     */
    _save: function(requestParams) {},

    /**
     * @returns {BEM}
     * @private
     */
    _showRequestError: function() {
        return this._showAlert([
            iget2(
                'b-stat-table-phrases-popup',
                'proizoshla-neizvestnaya-oshibka-poprobuyte',
                'Произошла неизвестная ошибка. Попробуйте перегрузить страницу или обратитесь к сервису позже.'
            ),
            iget2('b-stat-table-phrases-popup', 'izvinite-za-dostavlennoe-neudobstvo', 'Извините за доставленное неудобство.')
        ].join('</br>'));
    },

    /**
     * Показывает алерт
     * @param {String} message - сообщение
     * @returns {BEM}
     * @private
     */
    _showAlert: function(message) {
        BEM.blocks['b-confirm'].open({
            type: 'alert',
            message: BEMHTML.apply({
                block: 'b-stat-table-phrases-popup',
                elem: 'alert-text',
                content: message
            })
        });

        return this;
    },

    _onCancelClick: function() {
        this.trigger('cancel');
    },

    isChanged: function() {
        var deferred = $.Deferred();

        deferred.resolve(this._getPhrasesManager().isChanged());

        return deferred.promise();
    },

    destruct: function() {
        BEM.DOM.destruct(this.domElem, true); // чистим внутренности

        return this.__base.apply(this, arguments);
    }

}, {

    live: function() {
        this.liveInitOnBlockInsideEvent('click', 'button', function(e, data) {
            this._onButtonClick(e, data);
        });

        return false;
    }

});
