BEM.DOM.decl({ block: 'b-stat-table', elem: 'additional-controls', modName: 'type', modVal: 'platform' }, {

    onSetMod: {
        js: function() {
            this.__base.apply(this, arguments);

            u.graspSelf.call(this, {
                _link: 'link on expand-link',
                _icon: 'icon on expand-icon',
                _spin: 'spin on spin'
            });

            this._deferred = $.Deferred();

            this._link.on('click', this._toggleStatistics, this);
        },

        disabled: function(modName, modVal) {
            this._icon.setMod(modName, modVal);

        }
    },

    /**
     * Скрывает или показывает статистику по запросу
     * @private
     */
    _toggleStatistics: function() {
        var row = this.closestElem('row'),
            parent = this.getParent();

        this._icon.toggleMod('type', 'plus', 'minus');

        if (this._icon.hasMod('type', 'plus')) {
            parent.hideStatistics(row);
        } else if (this._deferred.state() === 'resolved') {
            parent.showStatistics(row);
        } else {
            this._toggleLoadingVisualisation();

            this._fetchStatistics()
                .always(this.changeThis(function() {
                    this._toggleLoadingVisualisation();
                }, this))
                .then(function(rows) {
                    parent.showStatistics(row, rows);
                });
        }
    },

    /**
     * Включает или выключает визуализацию загрузки статистики
     * @private
     */
    _toggleLoadingVisualisation: function() {
        this._link.toggleMod('disabled', 'yes');
        this._icon.toggleMod('type', 'minus');
        this._spin.toggleMod('progress', 'yes');
    },

    /**
     * Подтягивает статистику
     * @returns {$.Deferred}
     * @private
     */
    _fetchStatistics: function() {
        BEM
            .create('i-request_type_ajax', {
                url: u.getUrl('showCampStat', this.params.hrefParams),
                dataType: 'json',
                cache: false,
                callbackCtx: this,
                onError: function() { this._deferred.reject(); }
            })
            .get({}, this._resolveStatisticsResponse);

        return this._deferred.promise();
    },

    /**
     * Резолвит промис объектом строк с колонками [{ cols: [...], elemMods: {} }]
     * @param {Object[]} result объекты статистики
     * @private
     */
    _resolveStatisticsResponse: function(result) {
        var campStatCtx = this.getParent().getCampStatCtx(),
            showTrafficVolumeStatFields = u['traffic-volume'].showTrafficVolumeStatFields(this.params.mediaType);

        this._deferred.resolve($(BEMHTML.apply({
            block: 'b-stat-table',
            elem: 'rows',
            rows: result.map(function(item) {
                var fields = u._.compact([
                        'shows',
                        showTrafficVolumeStatFields && 'eshows',
                        'clicks',
                        'ctr',
                        showTrafficVolumeStatFields && 'ectr',
                        'sum',
                        this.params.isCpmStat && 'avg_cpm',
                        'av_sum'
                    ]),
                    formTargets = {
                        '': 'target_all',
                        _0: 'target_0',
                        _1: 'target_1'
                    },
                    keys = Object.keys(formTargets).filter(function(suf) {
                        return campStatCtx.form[formTargets[suf]];
                    }),
                    columns = [{
                        elemMods: { idented: 'yes' },
                        attrs: { colspan: keys.length + 1 + (this.params.isCpmStat ? 1 : 0) },
                        content: u.moment(new Date(item.stat_date)).format('DD.MM.YYYY, dd')
                    }];

                if (!campStatCtx.directya) {
                    fields.push('adepth', 'agoalnum', 'aconv', 'agoalcost', 'agoalroi', 'agoalincome');
                }

                fields.forEach(function(field) {
                    keys.forEach(function(suf) {
                        columns.push(this._formatCell(item, field, suf));
                    }, this);

                    // спец вставка ячейки для кнопки метрики (чтобы таблица была ровной)
                    field === 'av_sum' && columns.push({ content: '' });
                }, this);

                return {
                    cols: columns,
                    elemMods: {
                        fetched: 'yes',
                        holiday: item.holiday ? 'yes' : ''
                    }
                };
            }, this)
        })));
    },

    /**
     * Форматирует ячейку со значением статистики в зависимости от поля
     * @param {Object} item объект со статистикой
     * @param {String} field название поля
     * @param {String} suf суффикс площадки (всего - ''/поиск - _0/контекст - _1)
     * @returns {Object}
     * @private
     */
    _formatCell: function(item, field, suf) {
        switch (field) {
            // это поле форматируется как статистика для метрики
            case 'av_sum':
            case 'adepth':
            case 'agoalnum':
            case 'aconv':
            case 'agoalcost':
            case 'agoalroi':
            case 'agoalincome':
                return this._formatMetrikaCell(item, field, suf);
            default:
                return this._formatCommonCell(item, field, suf);
        }
    },

    /**
     * Форматирует ячейку со значением статистики общего вида
     * @param {Object} item объект со статистикой
     * @param {String} field название поля
     * @param {String} suf суффикс площадки (всего - ''/поиск - _0/контекст - _1)
     * @returns {Object}
     * @private
     */
    _formatCommonCell: function(item, field, suf) {
        var campStatCtx = this.params,
            allPrefix = 'all_',
            specPrefix = 'spec_',
            isFieldToFormat = /^(ctr|ectr|sum|avg_cpm|fp_shows_avg_pos|avg_x|fp_clicks_avg_pos)$/.test(field),
            prefix = '',
            value;

        campStatCtx.spec && (prefix = specPrefix);

        value = item[prefix + field + suf];

        if (campStatCtx.all && item[allPrefix + field + suf]) {
            (field == 'ctr' || field == 'ectr') ?
                (value = item[allPrefix + field + suf]) :
                (value += item[specPrefix + field + suf]);
        }

        if ((field == 'ctr' || field == 'ectr') && value > 100) {
            value = {
                block: 'b-help-link',
                mods: { type: 'modal' },
                url: u.getHelpUrl('min-search-price')
            };
        }

        value = value ?
            isFieldToFormat ? BEM.blocks['i-formater'].format(value) : value :
            isFieldToFormat ? '0.00' : '0';

        return {
            content: value
        };
    },

    /**
     * Форматирует ячейку статистики для метрики
     * @param {Object} item объект со статистикой
     * @param {String} field название поля
     * @param {String} suf суффикс площадки (всего - ''/поиск - _0/контекст - _1)
     * @returns {Object}
     * @private
     */
    _formatMetrikaCell: function(item, field, suf) {
        var campStatCtx = this.params,
            isFieldToFormat = !/^(tagoalnum|all_agoalnum|agoalnum)$/.test(field),
            prefix = '',
            value;

        campStatCtx.spec && (prefix = 'spec_');
        campStatCtx.all && (prefix = 'all_');

        value = item[prefix + field + suf];

        return {
            // исключение ячейки как статистики для метрики
            metrika: field !== 'av_sum',
            content: value !== null && typeof value !== 'undefined' && !isNaN(value) ?
                (isFieldToFormat ? BEM.blocks['i-formater'].format(value) : value) :
                '&ndash;'
        };
    }

}, {

    live: function() {
        // инициализация при клике на ссылку с иконкой свернуть/развернуть
        this.liveInitOnBlockInsideEvent('init', 'link');
    }

});
