BEM.DOM.decl({ block: 'b-stat-table', modName: 'type', modVal: 'geo' }, {

    /**
     * Обработчик события клика на +-
     * @param {Event} event событие клика
     */
    onExpanderClick: function(event) {
        var expander = event.data.domElem,
            isExpanded,
            row = expander.parents(this.buildSelector('row'));

        this.toggleMod(expander, 'expanded', 'yes');

        isExpanded = this.getMod(expander, 'expanded') === 'yes';

        // меняем плюс на минус и наоборот
        this.findBlockOn(expander, 'icon')
            .toggleMod('type', 'minus', 'plus', isExpanded);

        isExpanded ? this.expandTree(row) : this.collapseTree(row);
    },

    /**
     * Раскрывает подрегионы
     * @param {jQuery} root регион, чьи подрегионы нужно скрыть
     */
    expandTree: function(root) {
        var level = this.getMod(root, 'level'),
            // получаем всех прямых потомков дерева
            childs = root.nextUntil(
                this.buildSelector('row', 'level', level),
                this.buildSelector('row', 'level', +level + 1));

        this.setMod(root, 'expanded', 'yes');

        // для каждого из них
        childs.each(function(i, elem) {
            var child = $(elem);

            // делаем видимым
            this.setMod(child, 'visible', 'yes');

            // если у прямого потомка стоит развернутыый экспант, то
            // вызываем для него разворачивание дерева рекурсивно
            if (child.find(this.buildSelector('geo-expander', 'expanded', 'yes')).length)
                this.expandTree(child);
        }.bind(this));
    },

    /**
     * Скрывает подрегионы
     * @param {jQuery} root регион, чьи подрегионы нужно скрыть
     */
    collapseTree: function(root) {
        this.delMod(root, 'expanded');

        // Ищем все элементы от данного, до следующего с таким же значением модификатора level (не включая)
        // и им всем убираем мод visible
        this.setMod(root.nextUntil(this.buildSelector('row', 'level', this.getMod(root, 'level'))),
            'visible',
            '');
    }

}, {

    live: function() {
        this.liveBindTo('geo-expander', 'pointerclick', function(e) {
            e.preventDefault();
            this.onExpanderClick(e);
        });

        return this.__base.apply(this, arguments);
    }

});
