BEM.DOM.decl({ block: 'b-stat-table', modName: 'type', modVal: 'mol' }, {

    onSetMod: {
        js: function() {
            var floatingHeadRow = this.elem('head', 'floating', 'yes');

            // инициализируем первым имеющимся заголовком
            floatingHeadRow.length && this._initFloatingHeader(floatingHeadRow);

            if (this.getStatModel()) {
                this.getStatModel()
                    .initEvents();

                this._checkMassActionsCheckboxes();

                this.getStatModel()
                    .on('detailed-rows', 'change', function(e, data) {
                        switch (data.innerField) {
                            case 'ext_phrase_status':
                            case 'search_query_status':
                                this._onPhraseStatusChange(data);
                        }
                    }, this)
            }
        }
    },

    /**
     * Возвращает модель таблицы
     * @returns {Object}
     */
    getStatModel: function() {
        return this._statDataModel || (this._statDataModel = (this.findBlockOn('i-glue') || {}).model);
    },

    _contentTypeByStatus: {
        ext_phrase_status: 'contextcond-orig',
        search_query_status: 'search-query'
    },

    _phraseByStatus: {
        ext_phrase_status: 'phrase',
        search_query_status: 'search_query'
    },

    _checkboxByStatus: {
        ext_phrase_status: 'contextcond_ext_checkbox',
        search_query_status: 'search_query_checkbox'
    },

    _statusText: {
        added: iget2('b-stat-table', 'dobavleno', 'Добавлено')
    },

    resetCheckboxes: function() {
        this.getStatModel()
            .get('detailed-rows')
            .forEach(function(model) {
                model.set('contextcond_ext_checkbox', false);
                model.set('search_query_checkbox', false);
            });
    },

    /**
     * Обновляет в модели статус добавленных фраз
     * @param {Array} phrases
     */
    updatePhrasesStatus: function(phrases) {
        phrases.forEach(function(phrase) {
            this.getStatModel()
                .setStatusByIndex(phrase.srcType, phrase.normPhraseUnquoted, phrase.adgroupId, 'added');
        }, this);

        this.getStatModel()
            .get('detailed-rows')
            .forEach(function(model) {
                model.set('contextcond_ext_checkbox', false);
                model.set('search_query_checkbox', false);
            });

        this._checkMassActionsCheckboxes();
    },

    /**
     * Показывает/скрывает групповые чекбоксы в хедере
     * @private
     */
    _checkMassActionsCheckboxes: function() {
        var hasAvailableSearchQuery = this.getStatModel().hasPhrasesForAdding('search_query_status'),
            hasAvailableExtPhrase = this.getStatModel().hasPhrasesForAdding('ext_phrase_status');

        this.toggleMod('can-add-search-query', 'yes', hasAvailableSearchQuery);
        this.toggleMod('can-add-ext-phrase', 'yes', hasAvailableExtPhrase);

        if (this._floaterTable) {
            this._floaterTable.toggleMod('can-add-search-query', 'yes', hasAvailableSearchQuery);
            this._floaterTable.toggleMod('can-add-ext-phrase', 'yes', hasAvailableExtPhrase);
        }
    },

    /**
     * Строит новый контент для ячейки с текстом фразы
     * @param {String} type
     * @param {String} phrase
     * @returns {String}
     * @private
     */
    _getPhraseContentByStatus: function(type, phrase) {
        var tree = {
            ext_phrase_status: {
                block: 'b-statistic-phrase-minus-words',
                phrase: phrase,
                limit: 0
            },
            search_query_status: {
                block: 'b-mol-stat-data',
                elem: 'search-query-wrap',
                content: phrase
            }
        }[type];

        return BEMHTML.apply(tree);
    },

    /**
     * Удаляет чекбокс и меняет текст статуса в ячейках таблицы
     * @param {Object} data
     * @private
     */
    _onPhraseStatusChange: function(data) {
        var rowModel = data.model,
            rowElem = this.elem('row', 'detailed-row-id', rowModel.get('modelId')),
            statusElem = this.findElem(rowElem, 'row-col', 'content-type', u.beminize(data.innerField)),
            phraseElem = this.findElem(rowElem, 'row-col', 'content-type', this._contentTypeByStatus[data.innerField]),
            checkbox = this.findBlockInside(phraseElem, 'checkbox'),
            phrase = rowModel.get(this._phraseByStatus[data.innerField]);

        if (checkbox) {
            rowModel.set(this._checkboxByStatus[data.innerField], false);

            BEM.DOM.replace(checkbox.domElem, this._getPhraseContentByStatus(data.innerField, phrase));
        }

        BEM.DOM.update(statusElem, BEMHTML.apply({
            block: 'b-stat-table',
            elem: 'phrase-status',
            elemMods: {
                type: u.beminize(data.value)
            },
            content: this._statusText[data.value]
        }));
    },

    /**
     * Превращает строку-заголовок таблицы в плавающую (манипуляции с DOM)
     * @param {jQuery} headRow
     * @private
     */
    _initFloatingHeader: function(headRow) {
        var type = this.getMod('type');

        this._floater = $(BEMHTML.apply({
            block: 'b-floater',
            mods: {
                to: 'top',
                theme: 'white',
                anchor: 'yes',
                natural: 'yes',
                resizable: 'yes'
            },
            mix: [{ block: 'b-stat-table', elem: 'floater', elemMods: { type: 'mol' } }],
            content: {
                block: 'b-stat-table',
                mods: { type: 'mol' },
                content: {
                    elem: 'tbody',
                    elemMods: { type: 'floating-container' },
                    mix: type && [{ block: 'b-stat-table', elem: 'floating-body', elemMods: { type: type } }]
                }
            }
        })).bem('b-floater');

        this._floaterTable = this._floater.findBlockInside('b-stat-table');

        this._floater.setAnchor(headRow);

        BEM.DOM.append(
            this._floaterTable.elem('tbody', 'type', 'floating-container'),
            this.elem('fake-head').show()); // TODO DIRECT-55614

        BEM.blocks['i-resize'].getInstance().on('start end', function() {
            this._adjustColumnsWidth(headRow, this._floaterTable);
        }, this);

        BEM.blocks['resize-watcher'].getInstance({
            owner: this.findBlockOutside('b-mol-stat-data').domElem,
            ignoreHeight: true
        }).on('change', function() {
            this._adjustColumnsWidth(headRow, this._floaterTable);
            this._floater._setPos();
        }, this);

        this._adjustColumnsWidth(headRow, this._floaterTable);
    }

});
