BEM.DOM.decl({ block: 'b-stat-table', modName: 'type', modVal: 'platform' }, {

    /**
     * Прячет строки со статистикой, лежащие в одном и том же tbody, что и переданная строка таблицы
     * @param {jQuery} row опорная (основная) строка таблицы
     */
    hideStatistics: function(row) {
        this.setMod(this.closestElem(row, 'tbody'), 'statistics', 'hidden');
    },

    /**
     * Показывает строки со статистикой, лежащие в одном и том же tbody, что и переданная строка таблицы
     * @param {jQuery} row опорная (основная) строка таблицы
     * @param {jQuery} [insertingRows] строки со статисткой, которые надо добавить в tbody
     */
    showStatistics: function(row, insertingRows) {
        var tbody = this.closestElem(row, 'tbody');

        // если пришли строки со статистикой блок должен их добавить
        insertingRows && tbody.append(insertingRows);

        this.delMod(tbody, 'statistics');
    },

    getRowPageDomain: function(row) {
        var controls = this.findElem(row, 'additional-controls', 'type', 'platform'),
            pageDomain = this.elemParams(controls).hrefParams.pageDomain;

        return pageDomain;
    },

    /**
     * Переключает состояние блокировки строки и дополнительных контроллов (если они есть)
     * @param {jQuery} row опорная (основная) строка таблицы
     * @param {Object} data
     */
    toggleDisabled: function(row, data) {
        var controls = this.findElem(row, 'additional-controls', 'type', 'platform'),
            pageDomain = this.elemParams(controls).hrefParams.pageDomain,
            isDisabled = u._.values(data.checkedPages[pageDomain]).some(function(val) {
                return val === true;
            });

        if (controls.length) {
            this.toggleMod(controls, 'disabled', 'yes', isDisabled);
            this._updateBlacklist(row, data.checkedPages[pageDomain]);
        }

        this.toggleMod(row, 'disabled', 'yes', isDisabled);
    },

    /**
     * Обновляет элемент black-list
     * @param {jQuery} row
     * @param {Object} data
     * @private
     */
    _updateBlacklist: function(row, data) {
        var elem = this.findElem(row, 'black-list'),
            elemParams;

        if (!elem.length) return;

        elemParams = this.elemParams(elem);

        BEM.DOM.replace(elem, BEMHTML.apply({
            block: this.__self.getName(),
            elem: 'black-list',
            index: elemParams.index,
            pageName: elemParams.pageName,
            disabled: data.bannerDisabled,
            videoDisabled: data.videoDisabled
        }));
    },

    /**
     * Обработчик события click на ссылке
     * @param {Event} e
     * @private
     */
    _onBlackListClick: function(e) {
        var blackList = this.closestElem(e.block.domElem, 'black-list');

        if (!blackList.length) return;

        this.trigger('blackListEnable', u._.extend(this.elemParams(blackList), e.block.params));
    },

    /**
     * Делает не активными/активными элементы black-list-link
     * @param {Boolean} invoke
     */
    toggleDisabledBlackListLink: function(invoke) {
        this.findBlocksInside('black-list-link', 'link').forEach(function(link) {
            invoke ?
                link.setMod('disabled', 'yes') :
                link.delMod('disabled');
        });
    }

}, {
    live: function() {
        this.__base.apply(this, arguments);

        this.liveInitOnBlockInsideEvent('click', 'link', function(e, data) {
            this._onBlackListClick(e, data);
        });
    }
});
