block('b-stat-table')(

    tag()('table'),

    elem('tbody').tag()('tbody'),

    elem('head').tag()('tr'),

    elem('row').tag()('tr'),

    elem('total').tag()('tr'),

    elem('title').tag()('tr'),

    elem('footer').tag()('tr'),

    elem('head-col').tag()('td'),

    elem('row-col').tag()('td'),

    elem('title-col').tag()('td'),

    elem('footer-col').tag()('td'),

    elem('campaign-minus-word').tag()('span'),

    elem('head-separator').tag()('span')
);

block('b-stat-table').elem('tbody').elemMod('type', 'space').content()({
    elem: 'row'
});

/**
 * Элемент служит оберткой для блоков внутри закэшированной строки
 * При отрисовке закэшированной строки содержимое элемента будет развернуто в html и вставлено на место плейсхолдера
 */
block('b-stat-table').elem('blocks-wrap-within-cached-row').tag()('');

block('b-stat-table').elem('rows').replace()(function() {

    var rows = this.ctx.rows,
        self = this,
        rowsLength = this.ctx.rows.length,
        rowsElems = [],
        tmplCache = {},
        rowsIterator = 0,
        buildedRowOutput,

        /**
         * Формирует элемент строки блока таблицы.
         * При необходимости преобразует этот элемент в html строку
         *
         * @param {Object} row данные для формирование строки
         * @param {Boolean} asTemplate если true вернет html строку таблицы с плейсхолдерами для замены
         * @returns {Object|String}
         */
        buildRow = function(row, asTemplate) {
            var rowElem = row.elem || 'row',
                colElem = rowElem + '-col',
                list = row.cols,
                colsLength = list && list.length || 0,
                i = 0,
                nextCol,
                nextColIsMetrika,
                isTotalRow,
                elemMods,
                colElems = [],
                rowResult;

            for (i; i < colsLength; i++) {
                var col = list[i];
                nextCol = list[i + 1];

                nextColIsMetrika = nextCol && nextCol.metrika && !col.metrika;
                isTotalRow = (row.isTotalHead || row.isTotalTable);
                elemMods = {
                    'first-col': !row.firstCol && (row.firstCol = true) ? 'yes' : '',
                    metrika: col.metrika ? 'yes' : '',
                    'metrika-link': col.metrikaLink ? 'yes' : '',
                    'last-common-col': !isTotalRow && nextColIsMetrika ? 'yes' : '',
                    'last-summary-common-col': isTotalRow && nextColIsMetrika ? 'yes' : '',
                    'first-metrika-col': col.metrika && !row.firstMetrikaCol && (row.firstMetrikaCol = true) ?
                        'yes' :
                        '',
                    font: col.italic || '',
                    color: col.grey || ''
                };

                (col.elemMods || col.mods) && u._.extend(elemMods, col.elemMods || col.mods);

                colElems.push({
                    block: 'b-stat-table',
                    elem: colElem,
                    elemMods: elemMods,
                    attrs: col.attrs,
                    content: asTemplate ? '%CONTENT' + i + '%' : col.content
                });
            }

            rowResult = {
                block: 'b-stat-table',
                elem: rowElem,
                mix: row.mix,
                elemMods: u._.extend({
                    summary: row.summary ? 'yes' : '',
                    disabled: row.disabled ? 'yes' : '',
                    holiday: row.isHoliday ? 'yes' : ''
                }, row.elemMods || row.mods),

                js: row.js,

                content: colElems
            };

            // если нужна строка таблицы в виде html, изменяем поля контекста, шаблонизируем и получаем из буфера html
            asTemplate && (rowResult = self.reapply(rowResult));

            return rowResult;
        };

    /* jshint -W083 */
    // todo@dima117a: убрать этот хинт при выполнении DIRECT-51973

    for (rowsIterator; rowsIterator < rowsLength; rowsIterator++) {
        var row = rows[rowsIterator];

        //Если у row есть cacheKey то формируем html строку шаблона с плейсхолдерами, запоминаем ее
        //и в дальнейшем с помощью replace подставляем данные
        //такой подход дает существенный рост по производительности
        if (row.cacheKey) {
            tmplCache[row.cacheKey] = tmplCache[row.cacheKey] || buildRow(row, true);

            buildedRowOutput = tmplCache[row.cacheKey].replace(/%CONTENT(\d+)%/g, function(str, match) {
                var value = row.cols[match].content;

                if (value && value.elem === 'blocks-wrap-within-cached-row') {
                    value = self.reapply(value);
                }

                return value || '';
            });
        } else {
            buildedRowOutput = buildRow(row);
        }

        rowsElems.push(buildedRowOutput);
    }

    /* jshint +W083 */
    // todo@dima117a: убрать этот хинт при выполнении DIRECT-51973

    return rowsElems;
});
