block('b-stat-table')(

    addJs()(true),

    content()(function() {

        if (!this.ctx.content) {
            return '';
        }

        var tablesData = this.ctx.content,
            tablesDataLength = tablesData.length,
            allowFloatingHeader = !this.ctx.floatingExists && !this.data.uatraits.isMobile,
            tablesIterator = 0,
            innerTables = [],
            rowsDataLength,
            allowFloating,
            rowsIterator,
            colsIterator,
            colsLength,
            rowsData,
            table,
            cols,
            row,
            col;

        for (; tablesIterator < tablesDataLength; tablesIterator++) {
            table = tablesData[tablesIterator];
            rowsData = table.rows;
            rowsDataLength = rowsData && rowsData.length || 0;

            for (rowsIterator = 0; rowsIterator < rowsDataLength; rowsIterator++) {
                row = rowsData[rowsIterator];

                if (!row.cols) continue;

                // первый заголовок (не итоговый) помечаем как плавающий
                allowFloating = allowFloatingHeader && row.elem === 'head' && !row.isTotalHead;
                if (allowFloating) {
                    (row.elemMods || (row.elemMods = {})).floating = 'yes';

                    this.ctx.floatingExists = true;
                }

                cols = row.cols;
                colsLength = cols.length;

                for (colsIterator = 0; colsIterator < colsLength; colsIterator++) {
                    col = cols[colsIterator];
                    (!col || typeof col.content === 'undefined') && (col = {
                        content: col || ''
                    });

                    col.help && (col.content = {
                        block: 'b-stat-table',
                        elem: 'blocks-wrap-within-cached-row',
                        mix: {
                            block: 'b-stat-table',
                            elem: 'help-wrap'
                        },
                        content: [
                            col.content,
                            {
                                block: 'b-help-link',
                                mix: col.metrika && {
                                    block: 'b-stat-table',
                                    elem: 'metrika-help-link'
                                },
                                mods: { type: 'modal' },
                                url: u.getHelpUrl('statistics-metrika'),
                                title: col.help.title
                            }
                        ]
                    });

                    // elem: 'rows' в bemhtml, а контент col.content может быть и в bemtree
                    // поэтому нужен applyCtx
                    col.content = applyCtx(col.content);

                    // ячейки заголовка оборачиваем, чтобы
                    // впоследствии управлять шириной ячеек,
                    // не встречая багов DOM таблицы
                    ((row.elem === 'head' &&
                        (typeof col.content === 'string' || col.help && col.metrika)) || allowFloating) &&
                            (col.content = {
                                block: 'b-stat-table',
                                elem: 'head-col-wrap',
                                elemMods: this.data.sort === col.id && {
                                    sorted: 'yes'
                                },
                                content: col.content
                            });
                }
            }

            innerTables.push({
                elem: 'tbody',
                mix: table.tbodyMix,
                elemMods: table.tbodyMods,
                content: rowsData && {
                    block: 'b-stat-table',
                    elem: 'rows',
                    rows: rowsData
                }
            });
        }

        return innerTables;
    })
);

block('b-stat-table').elem('campaign-table-title')(
    content()(function() {
        var columns,
            selectedColumns,
            filters = {},
            data = this.data,
            currency = this.ctx.currency,
            showTrafficVolumeStatFields = u['traffic-volume'].showTrafficVolumeStatFields(data.mediaType),
            cid;

        if (this.ctx.chartsManager) {
            columns = u._.compact([
                'shows',        // Показы
                showTrafficVolumeStatFields && 'eshows',       // Взвешенные показы
                'clicks',       // Клики
                'ctr',          // ctr %
                showTrafficVolumeStatFields && 'ectr',         // ectr %
                'agoalnum',     // Конверсии
                'sum',          // Расход всего
                data.isCpmStat && 'avg_cpm',      // Ср. цена тысячи показов
                'av_sum',       // Ср. цена клика
                'adepth',       // Глубина (стр.)
                'aconv',        // Конверсия %
                'agoalcost',    // Цена цели
                'agoalroi',     // Рентабельность
                'agoalcrr',     // Доля рекламных расходов %
                'agoalincome'   // Доход
            ]);
            selectedColumns = ['shows', showTrafficVolumeStatFields && 'eshows', 'clicks', 'ctr',
                showTrafficVolumeStatFields && 'ectr', 'agoalnum'].filter(Boolean);
            cid = this.ctx.chartsManager.cid;

            if (cid) {
                // в статистике по выбранным кампаниям cid будет строкой, где кампании разделены через «, »
                filters.campaign = typeof cid === 'string' ?
                    { eq: cid.split(', ') } :
                    { eq: [cid] };
            }

            // https://st.yandex-team.ru/DIRECT-63513#1487774089000
            if (data.target_0 && !data.target_all && !data.target_1) {
                filters.targettype = { eq: 'search' };
            } else if (data.target_1 && !data.target_all && !data.target_0) {
                filters.targettype = { eq: 'context' };
            }

            if (data.goal_id) {
                filters.goal_id = { eq: data.goal_id }
            }

            return {
                block: 'b-charts-manager',
                mods: { 'save-user-options': 'yes' },
                mix: {
                    block: 'b-stat-table',
                    elem: 'charts-manager'
                },
                js: {
                    clientCurrency: currency,
                    reportData: u._.extend({}, this.ctx.chartsManager, {
                        statType: 'mol',
                        filters: filters
                    })
                },
                content: [
                    this.ctx.caption && {
                        block: 'b-stat-table',
                        elem: 'caption',
                        elemMods: { type: 'chart' },
                        content: this.ctx.caption
                    },
                    { elem: 'switcher' },
                    {
                        elem: 'filters',
                        filtersMods: { place: 'detail' },
                        view: data.USER_OPTIONS.stat_chart_view || undefined,
                        columns: u['b-charts-manager'].applyGroup(columns.map(function(column, index) {
                            return {
                                value: column,
                                selected: selectedColumns.indexOf(column) !== -1 ? 'yes' : '',
                                text: u['text-store'].get({ currency: u.currencies.getName(currency) }, 'chart', column)
                            };
                        }))
                    },
                    {
                        elem: 'export',
                        print: true,
                        types: [
                            { text: 'PNG', MIME: 'image/png' },
                            { text: 'JPEG', MIME: 'image/jpeg' },
                            { text: 'SVG', MIME: 'image/svg+xml' }
                        ]
                    },
                    { elem: 'chart' }
                ]
            };
        } else {
            return {
                elem: 'caption',
                content: this.ctx.caption
            };
        }
    })
);
