/**
 * Статистика по всем кампаниям
 */
BEM.DOM.decl('b-stat-table', {

    onSetMod: {
        js: function() {
            // плавающий заголовок получается перешаблонизацией куска b-stat-table, и повторным вызовом js_inited
            var floatingHeadRow = this.elem('head', 'floating', 'yes'),
                floatingHeadRowCount = floatingHeadRow.length;

            floatingHeadRowCount && this._initFloatingHeader(floatingHeadRow.eq(0));
        }
    },

    /**
     * Уничтожает блок
     * @returns {BEM.DOM}
     */
    destruct: function() {
        return this.__base.apply(this, arguments);
    },

    /**
     * Возвращает параметры блока, выступающие в роли контекстных данных campStatCtx, переданных в b-campaign-stat-data
     * @returns {Object}
     */
    getCampStatCtx: function() {
        return this.params;
    },

    /**
     * Превращает строку-заголовок таблицы в плавающую (манипуляции с DOM)
     * @param {jQuery} headRow
     * @private
     */
    _initFloatingHeader: function(headRow) {
        var floater = $(BEMHTML.apply({
                block: 'b-stat-table',
                elem: 'floater',
                type: this.getMod('type')
            })).bem('b-floater'),
            innerTable = floater.findBlockInside('b-stat-table'),
            bannerPreviewRows;

        floater.setAnchor(headRow);

        BEM.DOM.append(
            innerTable.elem('tbody', 'type', 'floating-container'),
            headRow.clone(true));

        BEM.blocks['i-resize'].getInstance().on('start end', function() {
            this._adjustColumnsWidth(headRow, innerTable);
        }, this);

        this._adjustColumnsWidth(headRow, innerTable);

        bannerPreviewRows = this.elem('title', 'banner-preview', 'yes');

        bannerPreviewRows.length &&
            this._initFloatingBannerInfo(floater, innerTable, bannerPreviewRows);
    },

    /**
     * Инициализация контейнера с информацией о баннере
     * @param {BEM} floater
     * @param {BEM} innerTable
     * @param {jQuery} bannerPreviewRows
     * @private
     */
    _initFloatingBannerInfo: function(floater, innerTable, bannerPreviewRows) {
        var bannerBlocks = this.findBlocksInside(bannerPreviewRows, 'b-stat-banner'),
            /**
             * Обработчик отрыва и приземления флоатера
             * @param {jQuery.Event} e
             */
            freezeHandler = function(e) {
                var params = this._getCurrPositionParams(bannerPreviewRows),
                    banner = e.type === 'freeze' && params.banner;

                // при посадке сносить текущую позицию баннера
                // для возврата к исходному состоянию при следующем взлете флоатера
                e.type === 'unfreeze' && (this._currPosition = null);

                this._updateBannerInfo(floater, innerTable, banner, params);
            },
            /**
             * Обработчик прокрутки документа. Обновляет инфо о баннере
             * во флоатере по мере прокрутки
             */
            scrollHandler = function() {
                var height = floater.getContentHeight(),
                    position,
                    params;

                if (height) {
                    // бинарный поиск (не имеет значения размер списка при поиске)
                    // для нахождения позиции превью баннера
                    position = u._.sortedIndex(
                        bannerBlocks,
                        this.__self.doc.scrollTop() + height,
                        function(item) {
                            return typeof item === 'number' ?
                                item :
                                item.domElem.offset().top;
                        });

                    if (this._currPosition !== position) {
                        this._currPosition = position;

                        // если флоатер уже "плавает" и нужно только обновить контент
                        if (floater.hasMod('fixed', 'yes')) {
                            params = this._getCurrPositionParams(bannerPreviewRows);

                            this._updateBannerInfo(floater, innerTable, params.banner, params);
                        } else {
                            // подписка на отрыв и посадку флоатера для обновления контента
                            floater
                                .un('freeze unfreeze', freezeHandler, this)
                                .on('freeze unfreeze', freezeHandler, this);
                        }
                    }
                }
            };

        // отслеживается скролл для обновления информации о баннере,
        // для которого показывается статистика
        this.bindToWin('scroll', $.throttle(scrollHandler, 100, this));

        scrollHandler.call(this);
    },

    /**
     * Возвращает параметры по баннеру согласно текущей позиции прокрутки страницы
     * @param {jQuery} bannerPreviewRows
     * @returns {Object}
     * @private
     */
    _getCurrPositionParams: function(bannerPreviewRows) {
        var position = this._currPosition;

        return position ? this.elemParams(bannerPreviewRows.eq(position - 1)) : {};
    },

    /**
     * Подгоняет ширину для каждой ячейки в плавающем заголовке по оригинальным ячейкам строки таблицы
     * @param {jQuery} headRow
     * @param {BEM} innerTable
     * @private
     */
    _adjustColumnsWidth: function(headRow, innerTable) {
        this.findElem(headRow, 'head-col-wrap').toArray().forEach(function(col, i) {
            innerTable.elem('head-col-wrap').eq(i).width($(col).width());
        }, this);
    },

    /**
     * Обновляет текст превью баннера в плавающем заголовке согласно позиции,
     * на которой находится видимый баннер
     * @param {BEM} floater
     * @param {BEM} innerTable
     * @param {Object} [banner]
     * @param {Object} [params]
     * @private
     */
    _updateBannerInfo: function(floater, innerTable, banner, params) {
        BEM.DOM.update(innerTable.elem('floating-info'), BEMHTML.apply({
            block: 'b-stat-table',
            elem: 'floating-header',
            banner: banner,
            statusOpenStat: params && params.statusOpenStat
        }));

        this.toggleMod(this.findElem(floater.domElem, 'floater'), 'has-info', 'yes', !!banner);
    }

}, {

    live: false

});
