block('b-stat-tabs').mod('type', 'single-camp')(

    content()(function() {
        var tabs,
            data = this.data,
            showStat = this.statUrlParams.showStat,
            showCampStat = this.statUrlParams.showCampStat,
            currentTab = data.statistic_page_type || data.FORM.stat_type,
            campType = u._.get(data, 'campaign.type'),
            commonParams = {
                cid: data.cid || data.FORM.cid,
                isStat: 1
            },
            notMCBanner = campType !== 'mcbanner',
            notContentPromotion = campType !== 'content_promotion',
            notCPMBanner = !u.campaign.isCpm(campType),
            notInternal = !u.campaign.isInternal(campType),
            campTypesOnSearch = ['mobile_content', 'dynamic', 'text', 'mcbanner', 'performance'],
            isBrandLiftEnabled = !!data.is_feature_brand_lift_enabled && data.campaign.brand_survey_id,
            isFeatureBrandSafetyStatEnabled = u.consts('brandsafetyBaseCategoriesStat');

        showStat = u._.extend({}, showStat, commonParams);
        showCampStat = u._.extend({}, showCampStat, commonParams);

        tabs = u._.compact([
            {
                title: iget2('b-stat-tabs', 'master-otchyotov', 'Мастер отчётов'),
                active: currentTab === 'moc',
                url: u.getUrl('showStat', u._.extend({
                    stat_type: 'moc',
                    single_camp: 1,
                    with_auto_added_phrases: 1
                }, showStat))
            },
            notInternal && notMCBanner && notCPMBanner && {
                title: iget2('b-stat-tabs', 'obshchaya-statistika', 'Общая статистика'),
                active: currentTab === 'default',
                url: u.getUrl('showCampStat', u._.extend({ types: 'total' }, showCampStat))
            },
            notInternal && notMCBanner && {
                title: u.campaign.getPhraseDetailStatTitle(data.mediaType),
                active: currentTab === 'phrase-detail',
                url: u.getUrl('showCampStat', u._.extend({ phrasedate: 'yes' }, showCampStat))
            },
            notMCBanner && {
                title: iget2('b-stat-tabs', 'po-regionam', 'По регионам'),
                active: currentTab === 'geo',
                url: u.getUrl('showCampStat', u._.extend({ stat_type: 'geo' }, showCampStat))
            },
            notMCBanner && notContentPromotion && {
                title: iget2('b-stat-tabs', 'po-ploshchadkam', 'По площадкам'),
                active: currentTab === 'pages',
                url: u.getUrl('showCampStat', u._.extend({ stat_type: 'pages' }, showCampStat))
            },
            campTypesOnSearch.indexOf(campType) !== -1 && {
                title: iget2('b-stat-tabs', 'poiskovye-zaprosy', 'Поисковые запросы'),
                active: currentTab === 'search_queries',
                url: u.getUrl('showStat', u._.extend({
                    stat_type: 'search_queries',
                    single_camp: 1
                }, showStat))
            },
            isBrandLiftEnabled && {
                title: 'Brand Lift',
                active: currentTab === 'brand_lift',
                url: u.getUrl('showCampStat', u._.extend({ stat_type: 'brand_lift' }, showCampStat))
            },
            isFeatureBrandSafetyStatEnabled && data.has_brandsafety_active_campaigns && {
                title: iget2('b-stat-tabs', 'brand-safety-tab-title', 'Фильтр по контенту'),
                active: currentTab === 'brand_safety',
                url: u.getUrl('showCampStat', u._.extend({ stat_type: 'brand_safety' }, showCampStat))
            }
            // Убрано в задаче https://st.yandex-team.ru/DIRECT-65235
            // Задача на полное убирание из кода: https://st.yandex-team.ru/DIRECT-66361
            // ['mobile_content', 'text'].indexOf(campType) !== -1 && {
            //     title: iget('Дополнительные фразы'),
            //     active: currentTab === 'ext_phrases',
            //     url: u.getUrl('showStat', u._.extend({
            //         stat_type: 'ext_phrases',
            //         single_camp: 1,
            //         with_auto_added_phrases: 1
            //     }, showStat))
            // }
        ]);

        data.offline_stat_count && tabs.push({
            title: u._.compact([
                iget2('b-stat-tabs', 'statistika-v-xls', 'Статистика в XLS'),
                data.offline_stat_ready_count
            ]).join(' - '),
            active: this.data.cmd === 'listOfflineReports',
            url: u.getUrl('listOfflineReports', u._.extend({
                stat_type: 'offline-reports'
            }, showCampStat))
        });

        return {
            block: 'tabs-menu',
            mods: {
                size: 's',
                theme: 'normal-red',
                layout: 'horiz'
            },
            content: tabs.map(function(tab) {
                return {
                    elem: 'tab',
                    elemMods: { active: tab.active ? 'yes' : '' },
                    content: {
                        block: 'link',
                        mods: { style: 'without-decoration' },
                        url: tab.url,
                        content: tab.title
                    }
                };
            })
        };
    })

);
