block('b-stat-tabs')(

    def()(function() {
        var showStat = u.getShowStat(),
            showCampStat = u.getShowCampStat();

        return applyNext({
            statUrlParams: {
                showStat: showStat,
                showCampStat: showCampStat
            }
        });
    }),

    content()(function() {
        var data = this.data,
            showStat = this.statUrlParams.showStat,
            showCampStat = this.statUrlParams.showCampStat,
            multiClientsModeDisabled = !u.consts('rights').enableStatsMultiClientsMode,
            tabs = [
                {
                    title: iget2('b-stat-tabs', 'master-otchetov', 'Мастер отчетов'),
                    active: data.statType === 'mol',
                    url: u.getUrl('showStat', u._.extend({ stat_type: 'mol' }, showStat))
                },
                multiClientsModeDisabled && {
                    title: iget2('b-stat-tabs', 'vse', 'Все'),
                    active: data.statType === 'campdate' && (!data.show_favorites || data.show_favorites === '0'),
                    url: u.getUrl('showCampStat', u._.extend({
                        stat_type: 'campdate',
                        show_favorites: '0'
                    }, showCampStat))
                }
            ].filter(Boolean),
            isFeatureBrandSafetyStatEnabled = u.consts('brandsafetyBaseCategoriesStat');

        // для статистики по множеству старых у.е. кампаний показывать другие вкладки не нужно
        // https://st.yandex-team.ru/DIRECT-66604
        if (multiClientsModeDisabled && (data.statType !== 'campdate' || !data.currency_archive)) {
            if (data.show_favorites_filter) {
                tabs.push({
                    title: iget2('b-stat-tabs', 'tolko-samye-vazhnye', 'Только самые важные'),
                    active: data.show_favorites === '1',
                    url: u.getUrl('showCampStat', u._.extend({
                        stat_type: 'campdate',
                        show_favorites: '1'
                    }, showCampStat))
                });
            }

            tabs.push(
                {
                    title: iget2('b-stat-tabs', 'poiskovye-zaprosy', 'Поисковые запросы'),
                    active: data.statType === 'search_queries',
                    url: u.getUrl('showStat', u._.extend({ stat_type: 'search_queries' }, showStat))
                }
                // Убрано в задаче https://st.yandex-team.ru/DIRECT-65235
                // Задача на полное убирание из кода: https://st.yandex-team.ru/DIRECT-66361
                // {
                //     title: iget('Дополнительные фразы'),
                //     active: data.statType === 'ext_phrases',
                //     url: u.getUrl('showStat', u._.extend({ stat_type: 'ext_phrases' }, showStat))
                // },
            );
        }

        if (isFeatureBrandSafetyStatEnabled && data.has_brandsafety_active_campaigns) {
            tabs.push(
                {
                    title: iget2('b-stat-tabs', 'brand-safety-tab-title', 'Фильтр по контенту'),
                    active: data.statType === 'brand_safety_mol',
                    url: u.getUrl('showCampStat', u._.extend({ stat_type: 'brand_safety_mol' }, showStat))
                }
            );
        }

        return {
            block: 'tabs-menu',
            mods: {
                size: 's',
                theme: 'normal-red',
                layout: 'horiz'
            },
            content: u._.compact(tabs).map(function(tab) {
                return {
                    elem: 'tab',
                    elemMods: { active: tab.active ? 'yes' : '' },
                    content: {
                        block: 'link',
                        mods: { style: 'without-decoration' },
                        url: tab.url,
                        content: tab.title
                    }
                };
            })
        };
    })

);
