BEM.DOM.decl({ block: 'b-state-dna' }, {
    onSetMod: {
        js: function() {
            var dna = window.dna;

            if (!dna) {
                throw new Error('An error has occurred in loading DNA dependencies');
            }

            this._renderDna(dna, this.params);
        }
    },

    _renderDna: function(dna, params) {
        var dnaComp = this._getDnaComponent(dna, params),
            domElem = this.domElem.get(0);

        dna.reactDOMRender(dnaComp, domElem, function() {
            BEM.DOM.blocks['b-state-dna']._resolve();
        });
    },

    _getDnaComponent: function(dna, params) {
        return dna.reactCreateElement(dna.components.StateWrapper, {
            login: params.ulogin,
            page: params.page,
            devInfo: params.devInfo,
            tagsAllowed: params.tagsAllowed,
            infoblockTeasersUrl: params.infoblockTeasersUrl,
            cspNonce: params.cspNonce,
            isGridEnabled: params.isGridEnabled,
            csrfToken: params.csrfToken,
            clientFeatures: params.clientFeatures || u.consts('clientFeaturesAll'),
            operatorFeatures: params.operatorFeatures || u.consts('operatorFeaturesAll'),
            isLoginBlocked: params.isLoginBlocked,
        }, null);
    }
}, {
    _resolver: null,
    _promise: null,

    _resolve: function() {
        var self = BEM.DOM.blocks['b-state-dna'];

        self.awaitReady();
        self._resolver();
    },

    awaitReady: function() {
        var self = BEM.DOM.blocks['b-state-dna'];

        if (!self._promise) {
            self._promise = new Promise(function(resolve) {
                self._resolver = resolve;
            });
        }

        return self._promise;
    }
});
