block('b-statistic-columns-slices').elem('item').elemMod('type', 'columns')(

    addMix()([{
        block: 'b-checkboxes-group',
        mods: {
            'check-button-main': 'yes'
        },
        js: true
    }]),

    content()(function() {
        var columnsList = this.columnsList,
            data = this.data,
            campType = this.campType,
            isUniqCompletedViewersEnabled = this.data.is_feature_uniq_completed_viewers_stat_enabled,
            campaign = data.campaign || {},
            isPercOfImpDisabled = u.consts('isPercOfImpDisabled'),
            currency = ' (' + u.currencies.getName(campaign.currency || data.client_currency) + ')',
            items = u._.filter([
                {
                    text: iget2('b-statistic-columns-slices', 'pokazy', 'Показы'),
                    value: 'shows'
                },
                {
                    text: iget2('b-statistic-columns-slices', 'avg-nshow', 'Заметность показов (%)'),
                    help: u.getHelpUrl('report-wizard-avgnshow'),
                    value: 'avg_nshow'
                },
                {
                    text: iget2('b-statistic-columns-slices', 'eshows', 'Взвешенные показы'),
                    help: u.getHelpUrl('report-wizard-weighted-impressions'),
                    value: 'eshows'
                },
                {
                    text: iget2('b-statistic-columns-slices', 'kliki', 'Клики'),
                    value: 'clicks'
                },
                {
                    text: iget2('b-statistic-columns-slices', 'ctr-114', 'CTR (%)'),
                    value: 'ctr'
                },
                {
                    text: iget2('b-statistic-columns-slices', 'wctr', 'wCTR (%)'),
                    value: 'ectr'
                },
                {
                    text: iget2('b-statistic-columns-slices', 'rashod-vsego', 'Расход всего') + currency,
                    value: 'sum'
                },
                {
                    text: iget2('b-statistic-columns-slices', 'sr-cena-klika', 'Ср. цена клика') + currency,
                    value: 'av_sum'
                },
                {
                    text: iget2('b-statistic-columns-slices', 'video-mute', 'Клики выключить звук'),
                    value: 'video_mute'
                },
                {
                    text: iget2('b-statistic-columns-slices', 'video-unmute', 'Клики включить звук'),
                    value: 'video_unmute'
                },
                {
                    text: iget2('b-statistic-columns-slices', 'srednia-stavka-za-klik', 'Ср. ставка за клик') + currency,
                    value: 'avg_bid'
                },
                {
                    text: iget2('b-statistic-columns-slices', 'sr-cena-tys-pokazov', 'Ср. цена тыс. показов') + currency,
                    value: 'avg_cpm'
                },
                {
                    text: iget2('b-statistic-columns-slices', 'cpcc-completed-view', 'Ср. цена досмотра 100% ролика') + currency,
                    value: 'cpcv'
                },
                {
                    text: iget2('b-statistic-columns-slices', 'sr-poziciya-pokaza', 'Ср. позиция показа'),
                    value: 'fp_shows_avg_pos'
                },
                {
                    text: iget2('b-statistic-columns-slices', 'avg_x', 'Ср. объём трафика'),
                    value: 'avg_x'
                },
                {
                    text: iget2('b-statistic-columns-slices', 'sr-poziciya-klika', 'Ср. позиция клика'),
                    value: 'fp_clicks_avg_pos'
                },
                !isPercOfImpDisabled && {
                    text: campType == 'mcbanner' ?
                        iget2(
                            'b-statistic-columns-slices',
                            'procent-poluchennyh-pokazov-vyigrannyh',
                            'Процент полученных показов (выигранных аукционов)'
                        ) :
                        iget2('b-statistic-columns-slices', 'procent-poluchennyh-pokazov', 'Процент полученных показов (%)'),
                    help: u.getHelpUrl('report-wizard-impression-share'),
                    value: 'winrate'
                },
                {
                    text: iget2('b-statistic-columns-slices', 'dolya-vyigryshey-po-pokazam', 'Доля выигрышей по показам (%)'),
                    value: 'cpm_winrate'
                },
                {
                    text: iget2('b-statistic-columns-slices', 'ohvat', 'Охват'),
                    value: 'uniq_viewers',
                    help: u.getHelpUrl('unique-user')
                },
                {
                    text: iget2('b-statistic-columns-slices', 'vykuplennyh-unikalnyh-polzovateley', '% выкупленных уникальных пользователей'),
                    value: 'uniq_users_winrate'
                },
                {
                    text: iget2('b-statistic-columns-slices', 'sr-chastota-pokazov', 'Ср. частота показов'),
                    value: 'avg_view_freq'
                },
                {
                    text: iget2('b-statistic-columns-slices', 'clip-first-quartile', 'Проигрывание 25% ролика'),
                    value: 'video_first_quartile'
                },
                {
                    text: iget2('b-statistic-columns-slices', 'clip-midpoint', 'Проигрывание 50% ролика'),
                    value: 'video_midpoint'
                },
                {
                    text: iget2('b-statistic-columns-slices', 'clip-third-quartile', 'Проигрывание 75% ролика'),
                    value: 'video_third_quartile'
                },
                {
                    text: iget2('b-statistic-columns-slices', 'clip-complete', 'Проигрывание 100% ролика'),
                    value: 'video_complete'
                },
                {
                    text: iget2('b-statistic-columns-slices', 'clip-true-view', 'Просмотры'),
                    value: 'video_true_view'
                },
                {
                    text: iget2('b-statistic-columns-slices', 'clip-avg-true-view-cost', 'Ср. цена просмотра ролика') + currency,
                    value: 'video_avg_true_view_cost'
                },
                {
                    text: iget2('b-statistic-columns-slices', 'clip-first-quartile-rate', 'Доля проигрываний 25% ролика'),
                    value: 'video_first_quartile_rate'
                },
                {
                    text: iget2('b-statistic-columns-slices', 'clip-midpoint-rate', 'Доля проигрываний 50% ролика'),
                    value: 'video_midpoint_rate'
                },
                {
                    text: iget2('b-statistic-columns-slices', 'clip-third-quartile-rate', 'Доля проигрываний 75% ролика'),
                    value: 'video_third_quartile_rate'
                },
                {
                    text: iget2('b-statistic-columns-slices', 'clip-complete-rate', 'Доля проигрываний 100% ролика'),
                    value: 'video_complete_rate'
                },
                {
                    text: iget2('b-statistic-columns-slices', 'avg-nshow-complete', 'Заметность досмотров (%)'),
                    help: u.getHelpUrl('report-wizard-avgnshowcomplete'),
                    value: 'avg_nshow_complete',
                },
                {
                    text: iget2('b-statistic-columns-slices', 'clip-true-view-rate', 'Доля просмотров (%)'),
                    value: 'video_true_view_rate'
                },
                {
                    value: 'bounce_ratio',
                    text: iget2('b-statistic-columns-slices', 'otkazy', 'Отказы (%)'),
                    help: u.getHelpUrl('report-wizard-bounce-rate')
                },
                {
                    text: iget2('b-statistic-columns-slices', 'glubina-str', 'Глубина (стр.)'),
                    value: 'adepth'
                },
                {
                    text: iget2('b-statistic-columns-slices', 'konversiya', 'Конверсия (%)'),
                    value: 'aconv'
                },
                {
                    text: iget2('b-statistic-columns-slices', 'cena-celi', 'Цена цели') + currency,
                    value: 'agoalcost'
                },
                {
                    text: iget2('b-statistic-columns-slices', 'konversii', 'Конверсии'),
                    value: 'agoalnum'
                },
                {
                    text: iget2('b-statistic-columns-slices', 'rentabelnost', 'Рентабельность'),
                    value: 'agoalroi'
                },
                {
                    text: iget2('b-statistic-columns-slices', 'crr', 'Доля рекламных расходов (%)'),
                    value: 'agoalcrr'
                },
                {
                    text: iget2('b-statistic-columns-slices', 'dohod', 'Доход') + currency,
                    help: u.getHelpUrl('report-wizard-revenue'),
                    value: 'agoalincome'
                },
                {
                    text: iget2('b-statistic-columns-slices', 'profit', 'Прибыль') + currency,
                    help: u.getHelpUrl('report-wizard-profit'),
                    value: 'agoals_profit'
                },
                {
                    text: iget2('b-statistic-columns-slices', 'uroven-vovlechennosti', 'Уровень вовлеченности'),
                    help: u.getHelpUrl('report-wizard-engagement-rating'),
                    value: 'aprgoodmultigoal'
                },
                {
                    text: iget2('b-statistic-columns-slices', 'tsena-vovlechenia', 'Цена вовлечения') + currency,
                    help: u.getHelpUrl('report-wizard-engagement-rating'),
                    value: 'aprgoodmultigoal_cpa'
                },
                {
                    text: iget2('b-statistic-columns-slices', 'koefficient-vovlechennosti', 'Коэффициент вовлеченности (%)'),
                    help: u.getHelpUrl('report-wizard-engagement-rating'),
                    value: 'aprgoodmultigoal_conv_rate'
                },
                {
                    text: iget2('b-statistic-columns-slices', 'avg-time-to-conv', 'Ср. время до конверсии (час.)'),
                    value: 'avg_time_to_conv'
                },
                {
                    text: iget2('b-statistic-columns-slices', 'auction-wins2', 'Выигрыши в аукционах'),
                    help: u.getHelpUrl('report-wizard-renderings'),
                    value: 'auction_wins',
                },
                {
                    text: iget2('b-statistic-columns-slices', 'auction-hits', 'Участие в аукционах'),
                    help: u.getHelpUrl('report-wizard-auction-hits'),
                    value: 'auction_hits',
                },
                {
                    text: iget2('b-statistic-columns-slices', 'auction-win-rate2', 'Доля выигрышей (%)'),
                    help: u.getHelpUrl('report-wizard-renderings-rate'),
                    value: 'auction_win_rate',
                },
                {
                    text: iget2('b-statistic-columns-slices', 'imp-reach-rate', 'SOV (%)'),
                    help: u.getHelpUrl('report-wizard-share-of-voice'),
                    value: 'imp_reach_rate'
                },
                {
                    text: iget2('b-statistic-columns-slices', 'served_impressions', 'Выходы'),
                    help: u.getHelpUrl('cpm-campaign-outdoor-served-impressions'),
                    value: 'served_impressions',
                },
                isUniqCompletedViewersEnabled && {
                    text: iget2('b-statistic-columns-slices', 'uniq-completed-viewers', 'Достроенный охват'),
                    help: u.getHelpUrl('completed-reach'),
                    value: 'uniq_completed_viewers',
                },
                {
                    text: campType === 'cpm_price' ?
                        iget2('b-statistic-columns-slices', 'ad-site-clicks-cpm_price', 'Открытие раскрывающегося блока') :
                        iget2('b-statistic-columns-slices', 'ad-site-clicks-cpm_banner', 'Показ пэкшота'),
                    value: 'ad_site_clicks'
                },
                { text: iget2('b-statistic-columns-slices', 'close-clicks', 'Клики закрытия'), value: 'close_clicks' },
                { text: iget2('b-statistic-columns-slices', 'close-ctr', 'CTR закрытия'), value: 'close_ctr' },
                {
                    text: iget2('b-statistic-columns-slices', 'viewable-impressions-mrc', 'Видимые показы, стандарт MRC'),
                    help: u.getHelpUrl('mrc-viewable-impressions'),
                    value: 'viewable_impressions_mrc'
                },
                {
                    text: iget2('b-statistic-columns-slices', 'nonviewable-impressions-mrc', 'Невидимые показы, стандарт MRC'),
                    help: u.getHelpUrl('mrc-nonviewable-impressions'),
                    value: 'nonviewable_impressions_mrc'
                },
                {
                    text: iget2('b-statistic-columns-slices', 'undetermined-impressions-mrc', 'Неустановленные показы, стандарт MRC'),
                    help: u.getHelpUrl('mrc-undetermined-impressions'),
                    value: 'undetermined_impressions_mrc'
                },
                {
                    text: iget2('b-statistic-columns-slices', 'measured-rate-mrc', 'Доля измеряемых показов, стандарт MRC (%)'),
                    help: u.getHelpUrl('mrc-measured-rate'),
                    value: 'measured_rate_mrc'
                },
                {
                    text: iget2('b-statistic-columns-slices', 'viewable-rate-mrc', 'Доля видимых показов, стандарт MRC (%)'),
                    help: u.getHelpUrl('mrc-viewable-rate'),
                    value: 'viewable_rate_mrc'
                }
            ], function(item) {
                return !!~columnsList.indexOf(item.value);
            }),
            columns = data.columns || [];

        return [
            {
                elem: 'title',
                content: iget2('b-statistic-columns-slices', 'stolbcy', 'Столбцы')
            },
            {
                block: 'check-button',
                mix: [{
                    block: 'b-checkboxes-group',
                    elem: 'item'
                }],
                mods: {
                    size: 'xs',
                    checked: columns.length === items.length ? 'yes' : undefined
                },
                content: iget2('b-statistic-columns-slices', 'vybrat-vsyo', 'Выбрать всё')
            },
            {
                block: 'b-drag-chooser',
                mix: { block: 'b-statistic-columns-slices', elem: 'drag-chooser' },
                lockedValues: this.calculatedExclusions.lock,
                disabledValues: this.calculatedExclusions.disable,
                positions: data.columns_positions || [],
                checkParams: {
                    mix: [{
                        block: 'b-checkboxes-group',
                        elem: 'item'
                    }]
                },
                value: columns,
                items: items
            }
        ];
    })
);
