block('b-statistic-columns-slices').elem('item').elemMod('type', 'slices').content()(function() {
    var data = this.data,
        campType = this.campType,
        isMulitpleCampaigns = campType === undefined,
        hasMCBanner = data.available_camp_types.indexOf('mcbanner') !== -1,
        bannerHeader = campType === 'mcbanner' ?
            iget2('b-statistic-columns-slices', 'no-bannera', '№ баннера') :
            isMulitpleCampaigns && hasMCBanner ?
                iget2('b-statistic-columns-slices', 'no-obyavleniya-bannera', '№ объявления/баннера') :
                iget2('b-statistic-columns-slices', 'no-obyavleniya', '№ объявления'),
        slicesList = this.slicesList,
        isSQ = data.FORM.stat_type === 'search_queries', // Поисковые запросы
        isMultiClientEnabled = u.consts('rights').enableStatsMultiClientsMode,
        items = u._.filter([
            {
                text: iget2('b-statistic-columns-slices', 'client-login', 'Аккаунт'),
                value: 'client_login'
            },
            {
                text: iget2('b-statistic-columns-slices', 'tip-dopolnitelnoy-frazy', 'Тип дополнительной фразы'),
                value: 'bm_type'
            },
            {
                text: iget2('b-statistic-columns-slices', 'no-algoritma-podbora', '№ алгоритма подбора'),
                value: 'sim_distance'
            },
            {
                text: iget2('b-statistic-columns-slices', 'poiskovyy-zapros', 'Поисковый запрос'),
                value: 'search_query'
            },
            {
                text: iget2('b-statistic-columns-slices', 'status-poiskovogo-zaprosa', 'Статус поискового запроса'),
                value: 'search_query_status'
            },
            {
                text: iget2('b-statistic-columns-slices', 'tip-kampanii', 'Тип кампании'),
                value: 'campaign_type'
            },
            {
                text: iget2('b-statistic-columns-slices', 'kampanii', 'Кампании'),
                value: 'campaign'
            },
            {
                text: iget2('b-statistic-columns-slices', 'metki', 'Метки'),
                value: 'tags'
            },
            {
                text: iget2('b-statistic-columns-slices', 'strategy_id', 'Стратегия'),
                value: 'strategy_id'
            },
            {
                text: iget2('b-statistic-columns-slices', 'gruppy-115', 'Группы'),
                value: 'adgroup'
            },
            {
                text: bannerHeader,
                value: 'banner'
            },
            {
                text: iget2('b-statistic-columns-slices', 'tip-obyavleniya', 'Тип объявления'),
                value: 'banner_type'
            },
            {
                text: campType == 'mcbanner' ?
                    iget2('b-statistic-columns-slices', 'uslovie-pokaza-frazy', 'Условие показа (фразы)') :
                [
                    iget2('b-statistic-columns-slices', 'uslovie-pokaza', 'Условие показа'),
                    // Возвращает анонимную функцию которая в качестве аргумента
                    // использует результат работы другой анонимной функции
                    (function(text) {
                        return (campType !== 'dynamic') && {
                            block: 'b-statistic-columns-slices',
                            elem: 'text',
                            attrs: {
                                title: text
                            },
                            content: [' (', u.hellipCut(text, 20), ')']
                        };
                    })(
                        (function() {
                            var displayConditions;

                            if (campType === 'performance') {
                                displayConditions = [iget2('b-statistic-columns-slices', 'filtry', 'фильтры')];
                            } else if (campType == 'mcbanner') {
                                displayConditions = [iget2('b-statistic-columns-slices', 'frazy', 'фразы')];
                            } else {
                                displayConditions = [
                                    iget2('b-statistic-columns-slices', 'frazy', 'фразы'),
                                    iget2('b-statistic-columns-slices', 'podbor-auditorii', 'подбор аудитории'),
                                    iget2('b-statistic-columns-slices', 'interesy', 'интересы'),
                                    iget2('b-statistic-columns-slices', 'avtomaticheski-dobavlennye-frazy', 'автоматически добавленные фразы'),
                                    iget2('b-statistic-columns-slices', 'usloviya-dinamicheskih-obyavleniy', 'условия динамических объявлений'),
                                    iget2('b-statistic-columns-slices', 'filtry-smart-bannerov', 'фильтры смарт-баннеров')
                                ];

                                displayConditions.push(iget2('b-statistic-columns-slices', 'avtotargeting', 'автотаргетинг'));
                            }

                            return displayConditions.join(', ');
                        })()
                    )
                ],
                help: u.getHelpUrl('conditions-display-ads'),
                value: 'contextcond_orig'
            },
            {
                text: iget2('b-statistic-columns-slices', 'tip-usloviya-pokaza', 'Тип условия показа'),
                value: 'contexttype_orig'
            },
            {
                text: iget2('b-statistic-columns-slices', 'tip-usloviya-pokaza', 'Тип условия показа'),
                value: 'criterion_type'
            },
            isSQ && {
                text: iget2('b-statistic-columns-slices', 'status-usloviya-pokaza', 'Статус условия показа'),
                value: 'ext_phrase_status'
            },
            {
                text: iget2('b-statistic-columns-slices', 'tip-sootvetstviya', 'Тип соответствия'),
                value: 'match_type'
            },
            isSQ && {
                text: iget2('b-statistic-columns-slices', 'podobrannaya-fraza', 'Подобранная фраза'),
                value: 'matched_phrase'
            },
            {
                text: iget2('b-statistic-columns-slices', 'uslovie-podbora-korrektirovki', 'Условие подбора (корректировки)'),
                value: 'retargeting_coef'
            },
            {
                text: iget2('b-statistic-columns-slices', 'tip-ploshchadki', 'Тип площадки'),
                value: 'targettype'
            },
            {
                text: iget2('b-statistic-columns-slices', 'nazvanie-ploshchadki', 'Название площадки'),
                value: 'page_group'
            },
            {
                text: iget2('b-statistic-columns-slices', 'nazvanie-ploshchadki-podrobno', 'Название площадки (подробно)'),
                value: 'page'
            },
            {
                text: iget2('b-statistic-columns-slices', 'turbo_page_type-2', 'Турбо-версия площадки'),
                value: 'turbo_page_type'
            },
            {
                text: iget2('b-statistic-columns-slices', 'sdelki', 'Сделки'),
                value: 'deal'
            },
            {
                text: iget2('b-statistic-columns-slices', 'vneshnie-seti', 'Внешние сети'),
                help: u.getHelpUrl('report-wizard-ssp'),
                value: 'ssp'
            },
            {
                text: iget2('b-statistic-columns-slices', 'region-targetinga', 'Регион таргетинга'),
                value: 'region'
            },
            {
                text: iget2('b-statistic-columns-slices', 'region-mestonahozhdeniya', 'Регион местонахождения'),
                value: 'physical_region'
            },
            {
                text: iget2('b-statistic-columns-slices', 'region-type', 'Тип соответствия региона'),
                value: 'region_source'
            },
            {
                text: iget2('b-statistic-columns-slices', 'placement-type', 'Вид размещения'),
                value: 'position'
            },
            {
                text: iget2('b-statistic-columns-slices', 'mesto-klika', 'Место клика'),
                help: u.getHelpUrl('report-wizard-click-position'),
                value: 'click_place'
            },
            {
                text: iget2('b-statistic-columns-slices', 'formaty', 'Форматы'),
                value: 'banner_image_type'
            },
            {
                text: iget2('b-statistic-columns-slices', 'razmer-izobrazheniya', 'Размер изображения'),
                value: 'image_size'
            },
            {
                text: iget2('b-statistic-columns-slices', 'tip-ustroystva', 'Тип устройства'),
                value: 'device_type'
            },
            {
                text: iget2('b-statistic-columns-slices', 'tip-operacionnoy-sistemy', 'Тип операционной системы'),
                value: 'detailed_device_type'
            },
            {
                text: iget2('b-statistic-columns-slices', 'tip-svyazi', 'Тип связи'),
                value: 'connection_type'
            },
            {
                text: iget2('b-statistic-columns-slices', 'pol', 'Пол'),
                value: 'gender'
            },
            {
                text: iget2('b-statistic-columns-slices', 'semantic-correspondence-type', 'Категория таргетинга'),
                value: 'targeting_category'
            },
            {
                text: iget2('b-statistic-columns-slices', 'prisma-income-grade', 'Уровень платежеспособности'),
                value: 'prisma_income_grade'
            },
            {
                text: iget2('b-statistic-columns-slices', 'vozrast', 'Возраст'),
                value: 'age'
            },
            {
                text: iget2('b-statistic-columns-slices', 'inventory-type', 'Тип инвентаря'),
                value: 'inventory_type'
            },

            { text: iget2('b-statistic-columns-slices', 'client-id', 'Идентификатор клиента'), value: 'client_id' },
            { text: iget2('b-statistic-columns-slices', 'product-name', 'Название продукта'), value: 'internal_product_name' },
            { text: iget2('b-statistic-columns-slices', 'place-id', 'Номер плейса'), value: 'place_id' },
            { text: iget2('b-statistic-columns-slices', 'place-description', 'Описание плейса'), value: 'place_description' },
            { text: iget2('b-statistic-columns-slices', 'operating-system', 'Операционная система'), value: 'operating_system' },
            { text: iget2('b-statistic-columns-slices', 'browser', 'Браузер'), value: 'browser' },
            { text: iget2('b-statistic-columns-slices', 'page-id', 'Номер пейджа'), value: 'page_id' },
            {
                text: iget2('b-statistic-columns-slices', 'content-targeting', 'Жанры и тематики'),
                value: 'content_targeting',
                help: u.getHelpUrl('report-wizard-category-targeting')
            }
        ], function(item) {
            return !!~slicesList.indexOf(item.value);
        });

    return [
        {
            elem: 'title',
            content: iget2('b-statistic-columns-slices', 'srezy', 'Срезы')
        },
        {
            block: 'b-drag-chooser',
            mix: { block: 'b-statistic-columns-slices', elem: 'drag-chooser' },
            lockedValues: this.calculatedExclusions.lock,
            disabledValues: this.calculatedExclusions.disable,
            positions: data.group_by_positions || [],
            value: u['b-statistics-form'].mapNamesToClientFormat((data.group_by || []), isMultiClientEnabled),
            items: items
        }
    ];
});
