block('b-statistic-columns-slices')(

    def()(function() {
        var columnsList = [],
            slicesList = [],
            exclusionsRules = {},
            vals = (this.data.group_by || []).concat(this.data.columns || []),
            externalVals = [].concat(this.data.attribution_model),
            // Хэлпер для разворачивания данных из декларации в правила взаимодействия для столбцов и срезов
            // и списки столбцов/срезов для шаблонизации
            fillData = function(data, targetArr) {
                data.forEach(function(item) {
                    if (typeof item == 'string') {
                        targetArr.push(item);
                    } else {
                        targetArr.push(item.name);

                        if (item.lock || item.disable || item.externalDisable) {
                            // Преобразовываем правила в формат с которым мы дальше будем работать
                            // Если для поля нет правил - заполняем
                            if (exclusionsRules[item.name]) {
                                (item.lock || []).length &&
                                    (exclusionsRules[item.name].lock =
                                        u._.union(exclusionsRules[item.name].lock, item.lock));

                                (item.disable || []).length &&
                                    (exclusionsRules[item.name].disable =
                                        u._.union(exclusionsRules[item.name].disable, item.disable));

                                (item.externalDisable || []).length &&
                                    (exclusionsRules[item.name].externalDisable =
                                        u._.union(exclusionsRules[item.name].externalDisable, item.externalDisable));
                            } else {
                                exclusionsRules[item.name] = u._.pick(item, ['lock', 'disable', 'externalDisable']);
                            }

                            // если есть правила для disable, разворачиваем их создавая записи для других значений
                            // для взаимного блокирования, пример:
                            // { a: { disable: [b, c] } } > { b: { disable: [a] } }, { c: { disable: [a] } }
                            if ((item.disable || []).length) {
                                item.disable.forEach(function(name) {
                                    if (typeof exclusionsRules[name] === 'object') {
                                        exclusionsRules[name].disable =
                                            u._.union(exclusionsRules[name].disable, [item.name]);
                                    } else {
                                        exclusionsRules[name] = {
                                            disable: [item.name]
                                        };
                                    }
                                });
                            }
                        }
                    }
                });
            };

        // Формируем списки столбцов/срезов и правила взаимодействия
        fillData(this.ctx.columns, columnsList);
        fillData(this.ctx.slices, slicesList);

        return applyNext({
            columnsList: columnsList,
            slicesList: slicesList,
            exclusionsRules: exclusionsRules,
            externalVals: externalVals,
            calculatedExclusions: u['b-statistic-columns-slices'].calculateExclusion(vals, exclusionsRules, externalVals)
        });
    }),

    addJs()(function() {
        return {
            exclusionsRules: this.exclusionsRules,
            externalVals: this.externalVals
        };
    }),

    content()([
        {
            elem: 'item',
            elemMods: {
                type: 'slices'
            }
        },
        {
            elem: 'item',
            elemMods: {
                type: 'columns'
            }
        }
    ]));
