BEM.DOM.decl('b-statistic-columns-slices', {

    onSetMod: {
        js: function() {
            this._externalVals = this.params.externalVals;

            this._initEvents();
        }
    },

    _externalVals: [],

    _onChooserChange: function(chooser) {
        this._recalculate();
        this.trigger('change', { type: chooser });
    },

    _recalculate: function() {
        var exclusions = this._getExclusions();

        ['slices', 'columns'].forEach(function(ch) {
            this._getChooser(ch).setCheckboxesStates({
                lock: exclusions.lock,
                disable: exclusions.disable
            });
        }, this);
    },

    /**
     * Возвращает блок списка выбираемых значений столбцов или колонок
     * @param {String} type тип списка (slices, columns)
     * @returns {BEM.DOM}
     * @private
     */
    _getChooser: function(type) {
        this._choosers || (this._choosers = {});

        return this._choosers[type] ||
            (this._choosers[type] = this.findBlockInside(this.elem('item', 'type', type), 'b-drag-chooser'));
    },

    _getExclusions: function() {
        return u['b-statistic-columns-slices'].calculateExclusion(
            [].concat(
                this._getChooser('slices').getValue(),
                this._getChooser('columns').getValue()
            ),
            this.params.exclusionsRules,
            this._externalVals
        );
    },

    /**
     * Инициализация событий
     * @private
     */
    _initEvents: function() {
        ['slices', 'columns'].forEach(function(chooser) {
            this._getChooser(chooser).on('change', this._onChooserChange.bind(this, chooser), this);
        }, this);
    },

    /**
     * Возвращаем значение каждого столбца в виде хэша
     * где group_by - это срезы (в связи с видом данных приходящих от сервера)
     * @returns {{slices: *, group_by: *}}
     */
    getValue: function() {
        var slices = this._getChooser('slices'),
            columns = this._getChooser('columns');

        return {
            columns: columns.getValue(),
            columns_positions: columns.getPositions(),
            group_by: u['b-statistics-form'].mapNamesToServerFormat(slices.getValue()),
            group_by_positions: u['b-statistics-form'].mapNamesToServerFormat(slices.getPositions())
        }
    },

    /**
     * Выбирает чекбоксы столбцов с соответствующими значениями (если такие есть, они активны и еще не выбраны)
     * @param {String[]} values
     */
    tryToCheckColumns: function(values) {
        var dragChooser = this._getChooser('columns'),
            checkboxes = dragChooser._getAllCheckboxes();

        checkboxes
            .filter(function(checkbox) {
                return u._.includes(values, checkbox.val());
            })
            .forEach(function(checkbox) {
                checkbox.setMod('checked', 'yes');
            });
    },

    /**
     * Меняет расширенние данные для колонок и срезов
     * @param {String[]} vals
     */
    setExternalVals: function(vals) {
        this._externalVals = vals;

        this._recalculate.call(this);
    }
});
