(function() {
    u.register({

        'b-statistic-columns-slices': {

            /**
             * Исходя из выбранных значений и правил вычисляет пункты состояние которых необходимо поменять
             * @param {String[]} vals список выбранных значений
             * @param {Object} rules объект с правилами взаимодействия между столбцами/срезами
             * @returns {*}
             */
            calculateExclusion: function(vals, rules, externalVals) {
                var exclusions = vals.reduce(function(acc, val) {
                    var rule = rules[val];

                    if (rule) {
                        if (rule.externalDisable) {
                            acc.disable[val] = rule.externalDisable.some(function(eD) {
                                return !!~externalVals.indexOf(eD);
                            });
                        }

                        rule.lock && rule.lock.forEach(function(l) { acc.lock[l] = true; });
                        rule.disable && rule.disable.forEach(function(d) { acc.disable[d] = true; });
                    }

                    return acc;
                }, { lock: {}, disable: {} });

                Object.keys(rules).forEach(function(ruleKey) {
                    var rule = rules[ruleKey];

                    if (rule && rule.externalDisable && !exclusions.disable[ruleKey]) {
                        exclusions.disable[ruleKey] = rule.externalDisable.some(function(eD) {
                            return !!~externalVals.indexOf(eD);
                        });
                    }
                });

                return exclusions;
            }

        }

    });
})();
