BEM.DOM.decl({
    block: 'b-statistic-filters-editor',
    elem: 'button'
}, {

    _row: null,

    _button: null,

    /**
     * Обработчик события «клик» на кнопке
     * @private
     */
    _onClick: function() {},

    /**
     * Возвращает экземпляр строки
     * @returns {BEM}
     * @private
     */
    _getRow: function() {
        return this._row || (this._row = this.elemInstance(this.closestElem('row')));
    },

    /**
     * Возвращает экземпляр фильтра
     * @returns {BEM}
     * @private
     */
    _getFilter: function() {
        return this._row || (this._row = this.elemInstance(this.closestElem('filter')));
    },

    /**
     * Возвращает экземпляр строки 'operation'
     * @returns {BEM}
     * @private
     */
    _getOperation: function() {
        return this._operation || (this._operation = this.elemInstance(this.closestElem('operation')));
    },

    /**
     * Возвращает экземпляр кнопки
     * @returns {BEM}
     * @private
     */
    _getButton: function() {
        return this._button || (this._button = this.findBlockOn('button'));
    },

    /**
     * Делает кнопку неактивной
     * @returns {BEM}
     */
    disable: function() {
        this._getButton().setMod('disabled', 'yes');

        return this;
    },

    /**
     * Делает кнопку активной
     * @returns {BEM}
     */
    enable: function() {
        this._getButton().delMod('disabled');

        return this;
    }

}, {

    live: function() {

        this.liveInitOnBlockEvent('click', 'button', function(e) {
            this._onClick(e);
        });

    }

});
