block('b-statistic-filters-editor').elem('control')(

    elemMod('type', 'eq-ne').def()(function() {

        return applyCtx({
            block: 'b-statistic-filters-editor',
            elem: 'control',
            elemMods: { type: 'select' },
            mix: [{
                block: 'b-statistic-filters-editor',
                elem: 'select',
                elemMods: {
                    type: 'eq-ne'
                }
            }],
            selected: this.ctx.selected,
            disabled: this.ctx.disabled,
            options: [
                {
                    text: iget2('b-statistic-filters-editor', 'ravno', 'равно'),
                    value: 'eq'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'ne-ravno', 'не равно'),
                    value: 'ne'
                }
            ]
        });
    }),

    elemMod('type', 'eq-ne-contains-not-contains').def()(function() {

        return applyCtx({
            block: 'b-statistic-filters-editor',
            elem: 'control',
            elemMods: { type: 'select' },
            mix: [{
                block: 'b-statistic-filters-editor',
                elem: 'select',
                elemMods: {
                    type: 'eq-ne-contains-not-contains'
                }
            }],
            selected: this.ctx.selected,
            disabled: this.ctx.disabled,
            options: [
                {
                    text: iget2('b-statistic-filters-editor', 'ravno', 'равно'),
                    value: 'eq'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'ne-ravno', 'не равно'),
                    value: 'ne'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'soderzhit', 'содержит'),
                    value: 'contains'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'ne-soderzhit', 'не содержит'),
                    value: 'not_contains'
                }
            ]
        });
    }),

    elemMod('type', 'gt-eq-lt').def()(function() {

        return applyCtx({
            block: 'b-statistic-filters-editor',
            elem: 'control',
            elemMods: { type: 'select' },
            mix: [{
                block: 'b-statistic-filters-editor',
                elem: 'select',
                elemMods: { type: 'gt-eq-lt' }
            }],
            selected: this.ctx.selected,
            disabled: this.ctx.disabled,
            options: [
                {
                    text: iget2('b-statistic-filters-editor', 'menshe', 'меньше'),
                    value: 'lt'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'ravno', 'равно'),
                    value: 'eq'
                },
                {
                    text: iget2('b-statistic-filters-editor', 'bolshe', 'больше'),
                    value: 'gt'
                }
            ]
        });
    }),

    elemMod('type', 'a-b-delta').def()(function() {

        return applyCtx({
            block: 'b-statistic-filters-editor',
            elem: 'control',
            elemMods: { type: 'select' },
            mix: [{
                block: 'b-statistic-filters-editor',
                elem: 'select',
                elemMods: { type: 'a-b-delta' }
            }],
            selected: this.ctx.selected,
            disabled: this.ctx.disabled,
            options: [
                { text: iget2('b-statistic-filters-editor', 'period-a', 'период А'), value: 'a' },
                { text: iget2('b-statistic-filters-editor', 'period-v', 'период В'), value: 'b' },
                { text: iget2('b-statistic-filters-editor', 'raznica', 'разница'), value: 'absdelta' },
                { text: iget2('b-statistic-filters-editor', 'raznica-121', 'разница, %'), value: 'delta' }
            ]
        });

    }),

    elemMod('type', 'select').def()(function() {
        var selectedText,
            options;

        options = this.ctx.options.map(function(option) {
            var isSelected = this.ctx.selected == option.value,
                disabled = this.ctx.disabled || {},
                attrs = { value: option.value };

            selectedText || (selectedText = option.text);
            isSelected && (selectedText = option.text);

            isSelected && (attrs.selected = 'selected');
            disabled[option.value] && (attrs.disabled = 'disabled');

            return {
                elem: 'option',
                attrs: attrs,
                content: option.text
            };
        }, this);

        return applyCtx({
            block: 'select',
            mods: {
                layout: 'fixed',
                width: this.ctx.width
            },
            mix: [{
                block: 'b-statistic-filters-editor',
                elem: 'control',
                elemMods: this.elemMods
            }].concat(this.ctx.mix || []),
            content: [
                {
                    block: 'button',
                    content: selectedText
                },
                {
                    elem: 'control',
                    content: options
                }
            ]
        });
    }),

    elemMod('type', 'radio-button').def()(function() {

        return applyCtx({
            block: 'radio-button',
            mix: [{
                block: 'b-statistic-filters-editor',
                elem: 'control',
                elemMods: this.elemMods
            }],
            name: this.ctx.name,
            value: this.ctx.value,
            content: this.ctx.options.map(function(option) {

                return {
                    elem: 'radio',
                    content: option.text,
                    controlAttrs: { value: option.value }
                };
            })
        });
    }),

    elemMod('type', 'textarea').def()(function() {

        return applyCtx({
            block: 'input',
            mods: {
                type: 'textarea',
                autocomplete: 'off'
            },
            mix: [{
                block: 'b-statistic-filters-editor',
                elem: 'control',
                elemMods: this.elemMods
            }, {
                block: 'b-statistic-filters-editor',
                elem: 'textarea',
            }],
            value: this.ctx.value,
            placeholder: this.ctx.hint,
            content: [
                {
                    elem: 'control',
                    attrs: this.ctx.attrs || {
                        cols: '40',
                        rows: '2'
                    }
                }
            ]
        });
    }),

    elemMod('type', 'input').def()(function() {

        return applyCtx({
            block: 'input',
            mods: { autocomplete: 'off' },
            mix: [{
                block: 'b-statistic-filters-editor',
                elem: 'control',
                elemMods: this.elemMods
            }],
            value: this.ctx.value,
            content: [{ elem: 'control' }]
        });
    }),

    elemMod('type', 'checkbox').def()(function() {

        return applyCtx({
            block: 'checkbox',
            mods: { checked: this.ctx.checked ? 'yes' : '' },
            mix: [{
                block: 'b-statistic-filters-editor',
                elem: 'control',
                elemMods: this.elemMods
            }],
            checkboxAttrs: { autocomplete: 'off' },
            text: this.ctx.text
        });
    }),

    elemMod('type', 'check-button').def()(function() {

        return applyCtx({
            block: 'check-button',
            mods: {
                checked: this.ctx.checked ? 'yes' : '',
                pseudo: 'yes',
                disabled: this.ctx.disabled ? 'yes' : ''
            },
            mix: [{
                block: 'b-statistic-filters-editor',
                elem: 'control',
                elemMods: this.elemMods
            }],
            controlAttrs: { autocomplete: 'off' },
            name: this.ctx.name,
            content: this.ctx.text
        });
    })
);
