block('b-statistic-filters-editor').elem('dropdown').elemMod('type', 'filters-chooser').replace()(function() {
    var allCount = 0,
        selectedCount = 0,
        rules = this.ctx.calculatedExclusion,
        getChooserItems = function(items) { // рекурсивно строим список
            return items.map(function(item) {
                if (!item.group) {
                    ++allCount;
                    item.operations && ++selectedCount;
                }

                return item.group ?
                {
                    elem: 'group',
                    text: item.text,
                    name: item.name,
                    js: { name: item.name },
                    elemMods: { hidden: rules.hidden[item.name] ? 'yes' : '' },
                    content: getChooserItems(item.group)
                } :
                {
                    elem: 'title-wrap',
                    attrs: { title: item.title },
                    content: {
                        elem: 'item',
                        elemMods: {
                            selected: item.operations ? 'yes' : '',
                            unavailable: item.unavailable ? 'yes' : '',
                            hidden: rules.hidden[item.name] ? 'yes' : ''
                        },
                        js: { text: item.text, name: item.name },
                        name: item.name,
                        content: item.text
                    }
                };
            });
        },
        items = getChooserItems(this.ctx.filtersByGroups);

    return {
        block: 'dropdown',
        mix: [{
            block: 'b-statistic-filters-editor',
            elem: 'dropdown',
            elemMods: { type: 'filters-chooser' },
            js: true
        }],
        content: [
            {
                block: 'button',
                mix: [
                    {
                        block: 'b-statistic-filters-editor',
                        elem: 'filters-chooser-switcher'
                    },
                    {
                        block: 'dropdown',
                        elem: 'switcher'
                    }
                ],
                mods: {
                    theme: 'pseudo',
                    disabled: selectedCount == allCount ? 'yes' : ''
                },
                content: [
                    {
                        block: 'icon',
                        mods: { 'size-16': 'plus' },
                        mix: [{
                            block: 'button',
                            elem: 'icon'
                        }]
                    },
                    iget2('b-statistic-filters-editor', 'uslovie-filtracii', 'Условие фильтрации')
                ]
            },
            {
                elem: 'popup',
                elemMods: { animate: 'no' },
                mix: [{
                    block: 'b-statistic-filters-editor',
                    elem: 'filters-chooser-popup'
                }],
                js: {
                    directions: ['bottom-left', 'top-left']
                },
                content: {
                    block: 'b-chooser',
                    mods: {
                        search: 'yes',
                        multi: 'yes'
                    },
                    mix: [{
                        block: 'b-statistic-filters-editor',
                        elem: 'filters-chooser'
                    }],
                    content: [
                        {
                            elem: 'search',
                            hint: iget2('b-statistic-filters-editor', 'iskat-uslovie', 'Искать условие')
                        },
                        {
                            elem: 'wrap',
                            content: items
                        },
                        {
                            elem: 'not-found'
                        }
                    ]
                }
            }
        ]
    };
});
